/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.dfgui.swing;

import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.parser.ParserException;
import fipaos.platform.dfgui.swing.DFGUIFrame;
import fipaos.util.DocumentRetriever;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;

public class RegisterWithDFFrame
extends JFrame {
    private JButton _b_cancel;
    private JLabel _l_df_name;
    private JTextField _df_addresses;
    private JLabel _l_describe;
    private JButton _b_load_from_file;
    private JButton _b_register;
    private JTextField _df_name;
    private JLabel _l_df_addresses;
    private File _current_dir = new File(".");
    private DFGUIFrame _parent;
    private String _df = null;
    private static final String IMAGE_DIRECTORY = "/images/";
    private static final String FIPA_GIF = "logo.gif";

    public RegisterWithDFFrame(DFGUIFrame dFGUIFrame) {
        this._parent = dFGUIFrame;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initComponents();
        this.pack();
        this._l_describe.setText("Add new DF:");
        this._b_register.setText("Add");
        this.setTitle("Add new DF");
    }

    public RegisterWithDFFrame(DFGUIFrame dFGUIFrame, String string) {
        this._parent = dFGUIFrame;
        this._df = string;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initComponents();
        this.pack();
        this._l_describe.setText("Register " + string + " with DF:");
    }

    private void initComponents() {
        this._l_df_name = new JLabel();
        this._df_name = new JTextField();
        this._l_df_addresses = new JLabel();
        this._df_addresses = new JTextField();
        this._b_load_from_file = new JButton();
        this._b_register = new JButton();
        this._b_cancel = new JButton();
        this._l_describe = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Register with another DF");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/images/logo.gif")).getImage());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RegisterWithDFFrame.this.exitForm(windowEvent);
            }
        });
        this._l_df_name.setText("DF name:");
        this._l_df_name.setForeground(Color.black);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.getContentPane().add((Component)this._l_df_name, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 0, 2, 3);
        this.getContentPane().add((Component)this._df_name, gridBagConstraints);
        this._l_df_addresses.setText("Addresses:");
        this._l_df_addresses.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.getContentPane().add((Component)this._l_df_addresses, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.getContentPane().add((Component)this._df_addresses, gridBagConstraints);
        this._b_load_from_file.setText("Load from file...");
        this._b_load_from_file.setBorder(new BevelBorder(0));
        this._b_load_from_file.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterWithDFFrame.this.loadFromFile(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this._b_load_from_file, gridBagConstraints);
        this._b_register.setText("Register");
        this._b_register.setBorder(new BevelBorder(0));
        this._b_register.setSelected(true);
        this._b_register.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterWithDFFrame.this.register(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this._b_register, gridBagConstraints);
        this._b_cancel.setText("Cancel");
        this._b_cancel.setBorder(new BevelBorder(0));
        this._b_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterWithDFFrame.this.cancel(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this._b_cancel, gridBagConstraints);
        this._l_describe.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.getContentPane().add((Component)this._l_describe, gridBagConstraints);
    }

    private void register(ActionEvent actionEvent) {
        AgentID agentID = null;
        String string = this.parseAID(this._df_name.getText(), this._df_addresses.getText());
        try {
            agentID = new AgentID(string);
        }
        catch (ParserException parserException) {
            JOptionPane.showMessageDialog(this, "'" + string + "' is not a valid AgentID.", "Parsing Error", 0);
        }
        if (agentID != null) {
            if (this._df == null) {
                this._parent.returnAID(agentID);
            } else {
                this._parent.returnRegister(agentID, this._df);
            }
        }
        this.dispose();
    }

    private void cancel(ActionEvent actionEvent) {
        this.dispose();
    }

    private void loadFromFile(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._current_dir);
        int n = jFileChooser.showOpenDialog(this);
        AgentID agentID = null;
        if (n == 0) {
            String string = DocumentRetriever.getDocFromFile(jFileChooser.getSelectedFile().getPath());
            this._current_dir = new File(jFileChooser.getSelectedFile().getParent());
            if (string == null) {
                return;
            }
            try {
                agentID = new AgentID(string);
                this._df_name.setText(agentID.getName());
                String string2 = "";
                Iterator iterator = agentID.getAddresses().iterator();
                while (iterator.hasNext()) {
                    string2 = string2 + " " + iterator.next();
                }
                this._df_addresses.setText(string2);
            }
            catch (ParserException parserException) {
                JOptionPane.showMessageDialog(this, "'" + string + "' is not a valid AgentID.", "Parsing Error", 0);
            }
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        this.dispose();
    }

    private String parseAID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("(agent-identifier :name ");
        stringBuffer.append(string);
        stringBuffer.append(" :addresses (sequence ");
        stringBuffer.append(string2);
        stringBuffer.append("))");
        return stringBuffer.toString();
    }
}

