/*
 * Decompiled with CFR 0.152.
 */
package fipaos.skill.constraint.ccl.object;

import fipaos.agent.conversation.content.Content;
import fipaos.skill.constraint.ccl.constraint.CSPRelation;
import fipaos.skill.constraint.ccl.variable.CSPRange;
import fipaos.skill.constraint.ccl.variable.CSPValue;
import fipaos.skill.constraint.ccl.variable.CSPVariable;
import fipaos.skill.constraint.ccl.variable.IndexPair;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class CSP {
    public static final String CSPVARIABLE = "CSP-variable";
    public static final String CSPRELATION = "CSP-relation";
    public static final String CSPEXCLUSION = "CSP-exclusion";
    public static final String CSPREF = "CSP-ref";
    public static final String CSP = "CSP";
    public static final int CONTENT = 1;
    public static final int LIST = 2;
    public static final int LONG = 3;
    public static final int STRING = 4;
    private String _identifier = "";
    private Vector _variables = new Vector();
    private Vector _relations = new Vector();
    private Vector _exclusions = new Vector();

    public CSP() {
    }

    public CSP(Content content) {
        this.assignContentData(content);
    }

    private void assignContentData(Content content) {
        Iterator iterator;
        Content content2;
        Object object;
        Object object2;
        Set set = content.getAttributeNames();
        if (set.contains(CSPVARIABLE)) {
            object2 = content.getAttribute(CSPVARIABLE);
            switch (this.type(object2)) {
                case 1: {
                    object = (Content)object2;
                    this._variables.addElement(new CSPVariable((Content)object));
                    break;
                }
                case 2: {
                    object = (List)object2;
                    content2 = null;
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        content2 = (Content)iterator.next();
                        this._variables.addElement(new CSPVariable(content2));
                    }
                    break;
                }
            }
        }
        if (set.contains(CSPRELATION)) {
            object2 = content.getAttribute(CSPRELATION);
            switch (this.type(object2)) {
                case 1: {
                    object = (Content)object2;
                    this._relations.addElement(new CSPRelation((Content)object));
                    break;
                }
                case 2: {
                    object = (List)object2;
                    content2 = null;
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        content2 = (Content)iterator.next();
                        this._relations.addElement(new CSPRelation(content2));
                    }
                    break;
                }
            }
        }
        if (set.contains(CSPREF)) {
            this.identify((String)content.getAttribute(CSPREF));
        }
    }

    private int type(Object object) {
        int n = 5;
        if (object instanceof Content) {
            n = 1;
        }
        if (object instanceof List) {
            n = 2;
        }
        if (object instanceof Long) {
            n = 3;
        }
        if (object instanceof String) {
            n = 4;
        }
        return n;
    }

    public void identify(String string) {
        this._identifier = new String(string);
    }

    public String identity() {
        return new String(this._identifier);
    }

    public void addVariable(CSPVariable cSPVariable) {
        this._variables.addElement(cSPVariable.copy());
    }

    public Vector getVariables() {
        Vector<CSPVariable> vector = new Vector<CSPVariable>(this._variables.size());
        Enumeration enumeration = this._variables.elements();
        while (enumeration.hasMoreElements()) {
            CSPVariable cSPVariable = (CSPVariable)enumeration.nextElement();
            vector.addElement(cSPVariable.copy());
        }
        return vector;
    }

    public void addRelationship(CSPRelation cSPRelation) {
        this._relations.addElement(cSPRelation.copy());
    }

    public Vector getRelations() {
        Vector<CSPRelation> vector = new Vector<CSPRelation>(this._relations.size());
        Enumeration enumeration = this._relations.elements();
        while (enumeration.hasMoreElements()) {
            CSPRelation cSPRelation = (CSPRelation)enumeration.nextElement();
            vector.addElement(cSPRelation.copy());
        }
        return vector;
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n******************************");
        stringBuffer.append("\nCSP: " + this._identifier);
        Enumeration enumeration = this._variables.elements();
        while (enumeration.hasMoreElements()) {
            object = (CSPVariable)enumeration.nextElement();
            stringBuffer.append(((CSPVariable)object).toString());
        }
        object = this._relations.elements();
        while (object.hasMoreElements()) {
            CSPRelation cSPRelation = (CSPRelation)object.nextElement();
            stringBuffer.append(cSPRelation.toString());
        }
        stringBuffer.append("\n******************************\n\n");
        return stringBuffer.toString();
    }

    public CSP copy() {
        CSP cSP = new CSP();
        Enumeration enumeration = this._variables.elements();
        while (enumeration.hasMoreElements()) {
            cSP.addVariable((CSPVariable)enumeration.nextElement());
        }
        Enumeration enumeration2 = this._relations.elements();
        while (enumeration2.hasMoreElements()) {
            cSP.addRelationship((CSPRelation)enumeration2.nextElement());
        }
        cSP.identify(this._identifier);
        return cSP;
    }

    public Content toContent() {
        Object object;
        Object object2;
        Content content = new Content(CSP);
        Enumeration enumeration = this._variables.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (CSPVariable)enumeration.nextElement();
            object = ((CSPVariable)object2).toContent();
            content.addAttribute(CSPVARIABLE, object);
        }
        object2 = this._relations.elements();
        while (object2.hasMoreElements()) {
            object = (CSPRelation)object2.nextElement();
            Content content2 = ((CSPRelation)object).toContent();
            content.addAttribute(CSPRELATION, content2);
        }
        content.addAttribute(CSPREF, this._identifier);
        return content;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            CSP cSP = new CSP();
            cSP.identify("auction4");
            CSPRelation cSPRelation = new CSPRelation();
            cSPRelation.setVariableNameOne("house");
            cSPRelation.setVariableNameTwo("insurance");
            cSPRelation.setRelationType("Intensional-equality");
            cSPRelation.addTag("high");
            cSPRelation.addTag("middle");
            IndexPair indexPair = new IndexPair("(2, 2)");
            cSPRelation.addIndexPair(indexPair);
            indexPair = new IndexPair("(3, 3)");
            cSPRelation.addIndexPair(indexPair);
            cSP.addRelationship(cSPRelation);
            cSPRelation = new CSPRelation();
            cSPRelation.setVariableNameOne("boat");
            cSPRelation.setVariableNameTwo("insurance");
            cSPRelation.setRelationType("Intensional-inequality");
            cSPRelation.addTag("extreme");
            cSPRelation.addTag("middle");
            indexPair = new IndexPair("(4, 2)");
            cSPRelation.addIndexPair(indexPair);
            indexPair = new IndexPair("(3, 7)");
            cSPRelation.addIndexPair(indexPair);
            cSP.addRelationship(cSPRelation);
            CSPVariable cSPVariable = new CSPVariable();
            CSPRange cSPRange = new CSPRange();
            cSPRange.addRange("{house, car, boat}");
            cSPVariable.setRange(cSPRange);
            CSPValue cSPValue = new CSPValue();
            cSPValue.addElement("blue");
            cSPValue.addElement("red");
            cSPValue.addElement("green");
            cSPValue.addElement("purple");
            cSPValue.addTag("special");
            cSPValue.addTag("reserved");
            cSPVariable.addValue(cSPValue);
            cSPVariable.setName("auction");
            cSPVariable.addType("hot");
            cSPVariable.addType("cold");
            cSPVariable.setRole("lead");
            cSPVariable.setRole("follow");
            cSP.addVariable(cSPVariable);
            Content content = cSP.toContent();
            cSP = new CSP(content);
        }
        if (stringArray.length == 1) {
            // empty if block
        }
    }
}

