/*
 * Decompiled with CFR 0.152.
 */
package fipaos.skill.constraint.ccl.object;

import fipaos.agent.conversation.content.Content;
import fipaos.skill.constraint.ccl.variable.CSPValue;
import fipaos.skill.constraint.ccl.variable.CSPVariableAssignment;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class CSPSolution {
    public static final String CSPSOLUTION = "CSP-solution";
    public static final String CSPVARIABLEASSIGNMENT = "CSP-variable-assignment";
    public static final String HREF = "href";
    public static final int CONTENT = 1;
    public static final int LIST = 2;
    public static final int LONG = 3;
    public static final int STRING = 4;
    private String _identifier = "";
    private Vector _assignments = new Vector();

    public CSPSolution() {
    }

    public CSPSolution(String string) {
        this._identifier = new String(string);
    }

    public CSPSolution(Content content) {
        this.assignContentData(content);
    }

    private void assignContentData(Content content) {
        Set set = content.getAttributeNames();
        if (set.contains(HREF)) {
            this.identify((String)content.getAttribute(HREF));
        }
        if (set.contains(CSPVARIABLEASSIGNMENT)) {
            Object object = content.getAttribute(CSPVARIABLEASSIGNMENT);
            switch (this.type(object)) {
                case 1: {
                    Content content2 = (Content)object;
                    this._assignments.addElement(new CSPVariableAssignment(content2));
                    break;
                }
                case 2: {
                    List list = (List)object;
                    Content content3 = null;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        content3 = (Content)iterator.next();
                        this._assignments.addElement(new CSPVariableAssignment(content3));
                    }
                    break;
                }
            }
        }
    }

    private int type(Object object) {
        int n = 5;
        if (object instanceof Content) {
            n = 1;
        }
        if (object instanceof List) {
            n = 2;
        }
        if (object instanceof Long) {
            n = 3;
        }
        if (object instanceof String) {
            n = 4;
        }
        return n;
    }

    public void identify(String string) {
        this._identifier = new String(string);
    }

    public String identity() {
        return new String(this._identifier);
    }

    public void addVariable(CSPVariableAssignment cSPVariableAssignment) {
        this._assignments.addElement(cSPVariableAssignment.copy());
    }

    public Vector variables() {
        Vector<CSPVariableAssignment> vector = new Vector<CSPVariableAssignment>(this._assignments.size());
        Enumeration enumeration = this._assignments.elements();
        while (enumeration.hasMoreElements()) {
            CSPVariableAssignment cSPVariableAssignment = (CSPVariableAssignment)enumeration.nextElement();
            vector.addElement(cSPVariableAssignment.copy());
        }
        return vector;
    }

    public CSPSolution copy() {
        CSPSolution cSPSolution = new CSPSolution(this._identifier);
        Enumeration enumeration = this._assignments.elements();
        while (enumeration.hasMoreElements()) {
            CSPVariableAssignment cSPVariableAssignment = (CSPVariableAssignment)enumeration.nextElement();
            cSPSolution.addVariable(cSPVariableAssignment.copy());
        }
        return cSPSolution;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n******************************");
        stringBuffer.append("\nCSPSolution: " + this._identifier);
        Enumeration enumeration = this._assignments.elements();
        while (enumeration.hasMoreElements()) {
            CSPVariableAssignment cSPVariableAssignment = (CSPVariableAssignment)enumeration.nextElement();
            stringBuffer.append(cSPVariableAssignment.toString());
        }
        stringBuffer.append("\n******************************\n\n");
        return stringBuffer.toString();
    }

    public Content toContent() {
        Content content = new Content(CSPSOLUTION);
        content.addAttribute(HREF, this._identifier);
        Enumeration enumeration = this._assignments.elements();
        while (enumeration.hasMoreElements()) {
            CSPVariableAssignment cSPVariableAssignment = (CSPVariableAssignment)enumeration.nextElement();
            content.addAttribute(CSPVARIABLEASSIGNMENT, cSPVariableAssignment.toContent());
        }
        return content;
    }

    public static void main(String[] stringArray) {
        CSPSolution cSPSolution = new CSPSolution();
        cSPSolution.identify("auction4");
        CSPVariableAssignment cSPVariableAssignment = new CSPVariableAssignment();
        cSPVariableAssignment.variableName("bob");
        CSPValue cSPValue = new CSPValue();
        cSPValue.addElement("blue");
        cSPValue.addElement("red");
        cSPValue.addElement("green");
        cSPValue.addElement("purple");
        cSPValue.addTag("special");
        cSPValue.addTag("reserved");
        cSPVariableAssignment.addCSPValue(cSPValue);
        cSPSolution.addVariable(cSPVariableAssignment);
        cSPVariableAssignment = new CSPVariableAssignment();
        cSPVariableAssignment.variableName("joe");
        cSPValue = new CSPValue();
        cSPValue.addElement("blue");
        cSPValue.addElement("red");
        cSPValue.addElement("silver");
        cSPValue.addElement("purple");
        cSPValue.addTag("special");
        cSPValue.addTag("free");
        cSPVariableAssignment.addCSPValue(cSPValue);
        cSPSolution.addVariable(cSPVariableAssignment);
        Content content = cSPSolution.toContent();
        CSPSolution cSPSolution2 = new CSPSolution(content);
    }
}

