/*
 * Decompiled with CFR 0.152.
 */
package fipaos.skill.constraint.ccl.variable;

import fipaos.agent.conversation.content.Content;
import fipaos.skill.constraint.ccl.variable.List;
import fipaos.skill.constraint.ccl.variable.Tuple;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class CSPRange {
    public static final String RANGE = "Range";
    public static final String LIST_RANGE = "List-range";
    public static final String VALUES = "Values";
    public static final String CSPRANGE = "CSP-range";
    private Vector _range = null;
    private String _range_type = "";
    private Vector _tuple_range = null;

    public CSPRange() {
    }

    public CSPRange(Content content) {
        this.assignContentData(content);
    }

    private void assignContentData(Content content) {
        Set set;
        Object object;
        Set set2 = content.getAttributeNames();
        if (set2.contains(RANGE)) {
            object = (String)content.getAttribute(RANGE);
            this._range_type = new String((String)object);
        }
        if (set2.contains(LIST_RANGE) && (set = ((Content)(object = (Content)content.getAttribute(LIST_RANGE))).getAttributeNames()).contains(VALUES)) {
            String string = (String)((Content)object).getAttribute(VALUES);
            if (string.indexOf("(") == -1) {
                this.addRange(string);
            } else {
                Vector vector = List.parseList(string);
                this.addRange(vector);
            }
        }
    }

    public void addRange(String string) {
        if (this._range == null) {
            this._range = new Vector();
        }
        if (string.indexOf("{") != -1) {
            string = string.substring(string.indexOf("{") + 1, string.indexOf("}"));
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                string2 = string2.trim();
                this._range.addElement(new String(string2));
            }
        } else {
            this._range.addElement(string.trim());
        }
    }

    public void addRange(Vector vector) {
        if (this._range == null) {
            this._range = new Vector();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this._range.addElement(new String((String)enumeration.nextElement()));
        }
    }

    public void addTuple(Tuple tuple) {
        if (this._tuple_range == null) {
            this._tuple_range = new Vector();
        }
        this._tuple_range.addElement(tuple.copy());
    }

    public Vector getRange() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._range.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new String((String)enumeration.nextElement()));
        }
        return vector;
    }

    public Vector getTuples() {
        Vector<Tuple> vector = new Vector<Tuple>();
        Enumeration enumeration = this._tuple_range.elements();
        while (enumeration.hasMoreElements()) {
            Tuple tuple = (Tuple)enumeration.nextElement();
            vector.addElement(tuple.copy());
        }
        return vector;
    }

    public CSPRange copy() {
        CSPRange cSPRange = new CSPRange();
        if (!this._range_type.equals("")) {
            cSPRange.setRangeType(this._range_type);
        }
        if (this._range != null) {
            cSPRange.addRange(this._range);
        }
        if (this._tuple_range != null) {
            Enumeration enumeration = this._tuple_range.elements();
            while (enumeration.hasMoreElements()) {
                Tuple tuple = (Tuple)enumeration.nextElement();
                cSPRange.addTuple(tuple.copy());
            }
        }
        return cSPRange;
    }

    public String toString() {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n******************************");
        stringBuffer.append("\nCSPRange:");
        if (!this._range_type.equals("")) {
            stringBuffer.append("\nRangeType: " + this._range_type + "\n");
        }
        if (this._range != null) {
            stringBuffer.append("\nValues: ");
            stringBuffer.append("\n{ ");
            enumeration = this._range.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((String)enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }\n");
        }
        if (this._tuple_range != null) {
            stringBuffer.append("\nValues: ");
            stringBuffer.append("\n{ ");
            enumeration = this._tuple_range.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((Tuple)enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }\n");
        }
        stringBuffer.append("\n******************************\n");
        return stringBuffer.toString();
    }

    public void setRangeType(String string) {
        this._range_type = new String(string);
    }

    public String getRangeType() {
        return new String(this._range_type);
    }

    public Content toContent() {
        Content content;
        Content content2 = new Content(CSPRANGE);
        if (!this._range_type.equals("")) {
            content2.addAttribute(RANGE, new String(this._range_type));
        }
        if (this._range != null) {
            content = new Content(LIST_RANGE);
            content.addAttribute(VALUES, List.toString(this._range));
            content2.addAttribute(LIST_RANGE, content);
        }
        if (this._tuple_range != null) {
            content = new Content(LIST_RANGE);
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this._tuple_range.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((Tuple)enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
            content.addAttribute(VALUES, "{ " + stringBuffer + " }");
            content2.addAttribute(LIST_RANGE, content);
        }
        return content2;
    }

    public static void main(String[] stringArray) {
        CSPRange cSPRange = new CSPRange();
        cSPRange.setRangeType("Transport");
        cSPRange.addRange("{house, car, boat}");
        cSPRange = new CSPRange();
        cSPRange.addTuple(new Tuple("(Savoy, London)"));
        cSPRange.addTuple(new Tuple("(Ritz, Paris)"));
        cSPRange = new CSPRange();
        Vector<String> vector = new Vector<String>();
        vector.addElement("blue");
        vector.addElement("green");
        cSPRange.addRange(vector);
        Content content = new Content(CSPRANGE);
        content.setAttribute(RANGE, "Car");
        Content content2 = new Content(LIST_RANGE);
        content2.setAttribute(VALUES, "{Renault, Fiat}");
        content.setAttribute(LIST_RANGE, content2);
        cSPRange = new CSPRange(content);
        content = new Content(CSPRANGE);
        content.setAttribute(RANGE, "Car");
        content2 = new Content(LIST_RANGE);
        content2.setAttribute(VALUES, "{(Renault, \u00a31000), (Fiat, \u00a32000)}");
        content.setAttribute(LIST_RANGE, content2);
        cSPRange = new CSPRange(content);
        CSPRange cSPRange2 = new CSPRange();
        cSPRange2.setRangeType("Constraint");
        Vector vector2 = List.parseList("{(Fiat, \u00a31000), (Renault, \u00a31000)}");
        cSPRange2.addRange(vector2);
    }
}

