/*
 * Decompiled with CFR 0.152.
 */
package fipaos.skill.constraint.ccl.variable;

import fipaos.agent.conversation.content.Content;
import fipaos.skill.constraint.ccl.variable.CSPRange;
import fipaos.skill.constraint.ccl.variable.CSPValue;
import fipaos.skill.constraint.ccl.variable.List;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class CSPVariable {
    public static final String NAME = "Name";
    public static final String TYPE = "Type";
    public static final String DOMAIN = "Domain";
    public static final String CSPVARIABLE = "CSP-variable";
    private String _name = "";
    private CSPRange _range = null;
    private Vector _values = null;
    private Vector _role = null;
    private Vector _type = null;

    public CSPVariable() {
    }

    public CSPVariable(Content content) {
        this.assignContentData(content);
    }

    private void assignContentData(Content content) {
        Set set;
        Object object;
        Set set2 = content.getAttributeNames();
        if (set2.contains(TYPE)) {
            object = (String)content.getAttribute(TYPE);
            this.addType((String)object);
        }
        if (set2.contains(NAME)) {
            this._name = new String((String)content.getAttribute(NAME));
        }
        if (set2.contains(DOMAIN) && (set = ((Content)(object = (Content)content.getAttribute(DOMAIN))).getAttributeNames()).contains("CSP-range")) {
            Content content2 = (Content)((Content)object).getAttribute("CSP-range");
            this._range = new CSPRange(content2);
        }
    }

    public Vector getValues() {
        Vector<CSPValue> vector = new Vector<CSPValue>();
        Enumeration enumeration = this._values.elements();
        while (enumeration.hasMoreElements()) {
            CSPValue cSPValue = (CSPValue)enumeration.nextElement();
            vector.addElement(cSPValue.copy());
        }
        return vector;
    }

    public void addValue(CSPValue cSPValue) {
        if (this._values == null) {
            this._values = new Vector();
        }
        this._values.addElement(cSPValue.copy());
    }

    public Vector getRoles() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._role.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new String((String)enumeration.nextElement()));
        }
        return vector;
    }

    public void setRole(String string) {
        if (this._role == null) {
            this._role = new Vector();
        }
        this._role.addElement(new String(string));
    }

    public Vector getTypes() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._type.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new String((String)enumeration.nextElement()));
        }
        return vector;
    }

    public void addType(String string) {
        if (this._type == null) {
            this._type = new Vector();
        }
        this._type.addElement(new String(string));
    }

    public CSPRange getRange() {
        return this._range.copy();
    }

    public void setRange(CSPRange cSPRange) {
        this._range = cSPRange.copy();
    }

    public String getName() {
        return new String(this._name);
    }

    public void setName(String string) {
        this._name = new String(string);
    }

    public CSPVariable copy() {
        Enumeration enumeration;
        CSPVariable cSPVariable = new CSPVariable();
        cSPVariable.setName(this._name);
        if (this._type != null) {
            enumeration = this._type.elements();
            while (enumeration.hasMoreElements()) {
                cSPVariable.addType((String)enumeration.nextElement());
            }
        }
        if (this._role != null) {
            enumeration = this._role.elements();
            while (enumeration.hasMoreElements()) {
                cSPVariable.setRole((String)enumeration.nextElement());
            }
        }
        if (this._values != null) {
            enumeration = this._values.elements();
            while (enumeration.hasMoreElements()) {
                cSPVariable.addValue((CSPValue)enumeration.nextElement());
            }
        }
        if (this._range != null) {
            cSPVariable.setRange(this._range);
        }
        return cSPVariable;
    }

    public String toString() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (this._type != null) {
            string = this._type.toString();
        }
        if (this._role != null) {
            string2 = this._role.toString();
        }
        if (this._values != null) {
            string3 = this._values.toString();
        }
        if (this._range != null) {
            string4 = this._range.toString();
        }
        String string5 = "\n\n******************************\nCSPVariable:\nName: " + this._name + "\nTypes: " + string + "\nRoles: " + string2 + "\nValues: " + string3 + "\nRange: " + string4 + "\n\n******************************\n\n";
        return string5;
    }

    public Content toContent() {
        Object object;
        Content content = new Content(CSPVARIABLE);
        if (this._type != null) {
            object = "";
            object = this._type.size() == 1 ? (String)this._type.firstElement() : List.toString(this._type);
            content.addAttribute(TYPE, object);
        }
        if (!this._name.equals("")) {
            content.addAttribute(NAME, this._name);
        }
        object = new Content(DOMAIN);
        if (this._range != null) {
            Content content2 = this._range.toContent();
            ((Content)object).addAttribute("CSP-range", content2);
            content.addAttribute(DOMAIN, object);
        }
        return content;
    }

    public static void main(String[] stringArray) {
        CSPVariable cSPVariable = new CSPVariable();
        CSPRange cSPRange = new CSPRange();
        cSPRange.addRange("{house, car, boat}");
        cSPVariable.setRange(cSPRange);
        CSPValue cSPValue = new CSPValue();
        cSPValue.addElement("blue");
        cSPValue.addElement("red");
        cSPValue.addElement("green");
        cSPValue.addElement("purple");
        cSPValue.addTag("special");
        cSPValue.addTag("reserved");
        cSPVariable.addValue(cSPValue);
        cSPVariable.setName("auction");
        cSPVariable.addType("hot");
        cSPVariable.addType("cold");
        cSPVariable.setRole("lead");
        cSPVariable.setRole("follow");
        Content content = new Content("CSP-range");
        content.setAttribute("Range", "Car");
        Content content2 = new Content("List-range");
        content2.setAttribute("Values", "{(Renault, \u00a31000), (Fiat, \u00a32000)}");
        content.setAttribute("List-range", content2);
        Content content3 = new Content(DOMAIN);
        content3.addAttribute("CSP-range", content);
        Content content4 = new Content(CSPVARIABLE);
        content4.addAttribute(TYPE, "Car");
        content4.addAttribute(NAME, "buyer_request");
        content4.addAttribute(DOMAIN, content3);
        CSPVariable cSPVariable2 = new CSPVariable(content4);
        CSPVariable cSPVariable3 = new CSPVariable();
        CSPRange cSPRange2 = new CSPRange();
        cSPRange2.setRangeType("Constraint");
        Vector vector = List.parseList("{(Fiat, \u00a31000), (Renault, \u00a31000)}");
        cSPRange2.addRange(vector);
        cSPVariable3.setRange(cSPRange2);
    }
}

