/*
 * Decompiled with CFR 0.152.
 */
package fipaos.skill.db;

import fipaos.agent.profile.DatabaseProfileImpl;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseException;
import fipaos.skill.db.DatabaseFactory;
import fipaos.skill.db.DatabaseObject;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DatabaseTestHarness {
    private static List _writes = new LinkedList();
    private static List _reads = new LinkedList();
    private static List _lists = new LinkedList();
    private static List _deletes = new LinkedList();

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.exit(-10);
        }
        try {
            DatabaseProfileImpl databaseProfileImpl = new DatabaseProfileImpl();
            databaseProfileImpl.setDatabaseLocation(System.getProperty("user.dir"));
            databaseProfileImpl.setDatabaseType(stringArray[0]);
            Database database = DatabaseFactory.getDatabase("test-db", databaseProfileImpl);
            database.createDatabase();
            DatabaseTestHarness.testWrites(database, 1000);
            DatabaseTestHarness.testReads(database, 1000);
            DatabaseTestHarness.testLists(database, 1000);
            DatabaseTestHarness.testDeletes(database, 500);
        }
        catch (Throwable throwable) {
            System.exit(-20);
        }
    }

    private static void testWrites(Database database, int n) throws DatabaseException {
        String string = "test-object";
        int n2 = 0;
        while (n2 < n) {
            DBTestObject dBTestObject = new DBTestObject(string + n2);
            Timer timer = new Timer();
            database.startTransaction(false);
            database.addObject(dBTestObject);
            database.endTransaction();
            timer.stop();
            _writes.add(timer);
            ++n2;
        }
    }

    private static void testReads(Database database, int n) throws DatabaseException {
        String string = "test-object";
        int n2 = 0;
        while (n2 < n) {
            Timer timer = new Timer();
            database.startTransaction(true);
            database.findObject(string + n2);
            database.endTransaction();
            timer.stop();
            _reads.add(timer);
            ++n2;
        }
    }

    private static void testLists(Database database, int n) throws DatabaseException {
        int n2 = 0;
        while (n2 < n) {
            Timer timer = new Timer();
            database.startTransaction(true);
            int n3 = 0;
            Enumeration enumeration = database.getIDs();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n3;
            }
            if (n3 != n) {
                // empty if block
            }
            database.endTransaction();
            timer.stop();
            _lists.add(timer);
            ++n2;
        }
    }

    private static void testDeletes(Database database, int n) throws DatabaseException {
        database.startTransaction(true);
        int n2 = 0;
        Enumeration enumeration = database.getIDs();
        while (enumeration.hasMoreElements() && n2 < n) {
            String string = (String)enumeration.nextElement();
            Timer timer = new Timer();
            database.removeObject(string);
            timer.stop();
            ++n2;
            _deletes.add(timer);
        }
        database.endTransaction();
    }

    private static int calcSize(Database database) throws DatabaseException {
        database.startTransaction(true);
        int n = 0;
        Enumeration enumeration = database.getIDs();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        database.endTransaction();
        return n;
    }

    private static long calcAverage(List list) {
        double d = 0.0;
        long l = list.size();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Timer timer = (Timer)iterator.next();
            d += (double)timer.time() / (double)l;
        }
        return (long)d;
    }

    public static class Timer {
        private long start = System.currentTimeMillis();
        private long stop;

        public void stop() {
            if (this.stop == 0L) {
                this.stop = System.currentTimeMillis();
            }
        }

        public long time() {
            if (this.stop != 0L) {
                return this.stop - this.start;
            }
            return -1L;
        }

        public String toString() {
            return this.time() + "ms";
        }
    }

    private static class DBTestObject
    implements DatabaseObject {
        byte[] content = new byte[4096];
        String name;

        public DBTestObject(String string) {
            this.name = string;
        }

        public String getObjectID() {
            return this.name;
        }
    }
}

