/*
 * Decompiled with CFR 0.152.
 */
package fipaos.skill.db.memorydatabase;

import fipaos.agent.profile.DatabaseProfile;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseException;
import fipaos.skill.db.DatabaseObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class MemoryDatabase
implements Database {
    private static Hashtable __databases = new Hashtable();
    private Hashtable _our_hashtable;
    private String _db_name;
    private boolean _in_transaction = false;
    private DatabaseInfo _database_info;
    private Thread _in_control_thread;
    private DatabaseProfile _db_profile;

    public MemoryDatabase(String string, DatabaseProfile databaseProfile) {
        this._db_name = string;
        this._db_profile = databaseProfile;
    }

    public void createDatabase() {
        Hashtable hashtable = __databases;
        synchronized (hashtable) {
            this._our_hashtable = new Hashtable();
            this._database_info = new DatabaseInfo();
            this._database_info._db = this._our_hashtable;
            __databases.put(this._db_name, this._database_info);
            this._in_transaction = false;
        }
    }

    public void openDatabase() {
        Hashtable hashtable = __databases;
        synchronized (hashtable) {
            this._database_info = (DatabaseInfo)__databases.get(this._db_name);
            this._in_transaction = false;
            if (this._database_info == null) {
                this.createDatabase();
            } else {
                this._our_hashtable = this._database_info._db;
            }
        }
    }

    public void closeDatabase() {
        this._our_hashtable = null;
    }

    public void deleteDatabase() {
        Hashtable hashtable = __databases;
        synchronized (hashtable) {
            this._our_hashtable = null;
            __databases.remove(this._db_name);
        }
    }

    public void addObject(DatabaseObject databaseObject) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("Error - no transaction associated with DB!");
        }
        this._our_hashtable.put(databaseObject.getObjectID(), databaseObject);
    }

    public DatabaseObject findObject(String string) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("Error - no transaction associated with DB!");
        }
        return (DatabaseObject)this._our_hashtable.get(string);
    }

    public void updateObject(DatabaseObject databaseObject) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("Error - no transaction associated with DB!");
        }
        if (this._our_hashtable.get(databaseObject.getObjectID()) == null) {
            throw new DatabaseException("Error - cannot update object, it doesn't exist in DB");
        }
        this.addObject(databaseObject);
    }

    public void removeObject(DatabaseObject databaseObject) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("Error - no transaction associated with DB!");
        }
        this._our_hashtable.remove(databaseObject.getObjectID());
    }

    public void removeObject(String string) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("Error - no transaction associated with DB!");
        }
        this._our_hashtable.remove(string);
    }

    public void createRelation(String string) {
    }

    public void deleteRelation(String string) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startTransaction(boolean bl) {
        DatabaseInfo databaseInfo = this._database_info;
        synchronized (databaseInfo) {
            while (this._database_info._lock != 0 && this._in_control_thread != Thread.currentThread()) {
                try {
                    this._database_info.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this._database_info._lock;
            this._in_transaction = true;
            this._in_control_thread = Thread.currentThread();
            return;
        }
    }

    public void endTransaction() {
        DatabaseInfo databaseInfo = this._database_info;
        synchronized (databaseInfo) {
            --this._database_info._lock;
            this._database_info.notify();
            if (this._database_info._lock == 0) {
                this._in_transaction = false;
                this._in_control_thread = null;
            }
        }
    }

    public Enumeration getIDs() throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("Error - no transaction associated with DB!");
        }
        return this._our_hashtable.keys();
    }

    public class DatabaseInfo {
        public Hashtable _db;
        public int _lock = 0;
    }
}

