/*
 * Decompiled with CFR 0.152.
 */
package fipaos.skill.db.serializationdatabase;

import fipaos.agent.profile.DatabaseProfile;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseException;
import fipaos.skill.db.DatabaseObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class SerializationDatabase
implements Database {
    private String _db_name;
    private File _db_dir;
    private boolean _in_transaction = true;
    private Thread _in_control_thread;
    private int _lock = 0;
    private Stack _locks = new Stack();
    private DatabaseProfile _db_profile;

    public SerializationDatabase(String string, DatabaseProfile databaseProfile) {
        this._db_name = string + ".jsdb";
        this._db_profile = databaseProfile;
    }

    public synchronized void createDatabase() throws DatabaseException {
        try {
            this._db_dir = new File(this._db_profile.getDatabaseLocation());
            this._db_dir = new File(this._db_dir, this._db_name);
            if (this._db_dir.exists()) {
                if (!this.removeDir(this._db_dir)) {
                    throw new IOException("Couldn't remove previous DB in directory " + this._db_dir.getPath());
                }
            } else if (!this._db_dir.mkdirs()) {
                throw new IOException("Couldn't create directory " + this._db_dir.getPath());
            }
        }
        catch (Throwable throwable) {
            throw new DatabaseException("An error occured whilst creating the Database" + throwable);
        }
    }

    public synchronized void openDatabase() throws DatabaseException {
        try {
            this._db_dir = new File(this._db_profile.getDatabaseLocation());
            this._db_dir = new File(this._db_dir, this._db_name);
            if (!this._db_dir.exists() && !this._db_dir.mkdirs()) {
                throw new IOException("Couldn't create directory " + this._db_dir.getPath());
            }
        }
        catch (Throwable throwable) {
            throw new DatabaseException("An error occured whilst creating the Database" + throwable);
        }
    }

    public synchronized void closeDatabase() throws DatabaseException {
        this._db_dir = null;
    }

    public synchronized void deleteDatabase() throws DatabaseException {
        try {
            if (this._db_dir != null) {
                this.closeDatabase();
            }
            File file = new File(this._db_profile.getDatabaseLocation());
            if ((file = new File(file, this._db_name)).exists()) {
                this.removeDir(file);
            }
        }
        catch (Throwable throwable) {
            throw new DatabaseException("Error when attempting to delete database: " + throwable);
        }
    }

    public synchronized void addObject(DatabaseObject databaseObject) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("No transaction associated with DB!");
        }
        if (((Boolean)this._locks.peek()).booleanValue()) {
            throw new DatabaseException("addObject() called in 'readonly' transaction");
        }
        this.writeObjectFile(databaseObject);
    }

    public synchronized DatabaseObject findObject(String string) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("Error - no transaction associated with DB!");
        }
        try {
            return this.readObjectFile(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void updateObject(DatabaseObject databaseObject) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("No transaction associated with DB!");
        }
        if (((Boolean)this._locks.peek()).booleanValue()) {
            throw new DatabaseException("updateObject() called in 'readonly' transaction");
        }
        this.updateObjectFile(databaseObject);
    }

    public void removeObject(DatabaseObject databaseObject) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("No transaction associated with DB!");
        }
        if (((Boolean)this._locks.peek()).booleanValue()) {
            throw new DatabaseException("removeObject() called in 'readonly' transaction");
        }
        this.removeObjectFile(databaseObject.getObjectID());
    }

    public void removeObject(String string) throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("No transaction associated with DB!");
        }
        if (((Boolean)this._locks.peek()).booleanValue()) {
            throw new DatabaseException("removeObject() called in 'readonly' transaction");
        }
        this.removeObjectFile(string);
    }

    public void createRelation(String string) {
    }

    public void deleteRelation(String string) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startTransaction(boolean bl) throws DatabaseException {
        SerializationDatabase serializationDatabase = this;
        synchronized (serializationDatabase) {
            while (this._lock != 0 && this._in_control_thread != Thread.currentThread()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                if (this._lock > 0 && ((Boolean)this._locks.peek()).booleanValue() && !bl) {
                    throw new DatabaseException("'update' transaction attempted within a 'readonly' transaction");
                }
                this._locks.push(new Boolean(bl));
            }
            catch (Throwable throwable) {
                throw new DatabaseException("Exception during startTransaction(): " + throwable);
            }
            ++this._lock;
            this._in_transaction = true;
            this._in_control_thread = Thread.currentThread();
            return;
        }
    }

    public void endTransaction() throws DatabaseException {
        SerializationDatabase serializationDatabase = this;
        synchronized (serializationDatabase) {
            --this._lock;
            try {
                if (this._lock == 0) {
                    this._in_transaction = false;
                    this._in_control_thread = null;
                    this.notify();
                }
                this._locks.pop();
            }
            catch (Throwable throwable) {
                throw new DatabaseException("Exception during endTransaction(): " + throwable);
            }
        }
    }

    public synchronized Enumeration getIDs() throws DatabaseException {
        if (!this._in_transaction) {
            throw new DatabaseException("No transaction associated with DB!");
        }
        return this.getObjectFileEnumeration();
    }

    private static String keyToFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer2.length()) {
            char c = stringBuffer2.charAt(n);
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
            } else {
                byte by = (byte)c;
                stringBuffer.append('#');
                if (by < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(by));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String filenameToKey(String string) throws NumberFormatException {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (Character.isLetterOrDigit(c)) {
                stringBuffer2.append(c);
            } else if (c == '#') {
                byte by = Byte.valueOf(stringBuffer.toString().substring(n + 1, n + 3), 16);
                stringBuffer2.append((char)by);
                n += 2;
            }
            ++n;
        }
        return stringBuffer2.toString();
    }

    private boolean removeDir(File file) throws DatabaseException {
        try {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (!file2.delete()) {
                    throw new DatabaseException("Couldn't remove " + file2.getPath());
                }
                ++n;
            }
        }
        catch (DatabaseException databaseException) {
            throw databaseException;
        }
        catch (Throwable throwable) {
            throw new DatabaseException("Error removing directory " + file.getPath() + " : " + throwable);
        }
        return true;
    }

    private void writeObjectFile(DatabaseObject databaseObject) throws DatabaseException {
        File file = new File(this._db_dir, SerializationDatabase.keyToFilename(databaseObject.getObjectID()));
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(databaseObject);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            throw new DatabaseException("Error writing file " + file.getPath() + " : " + throwable);
        }
    }

    private DatabaseObject readObjectFile(String string) throws DatabaseException {
        File file = new File(this._db_dir, SerializationDatabase.keyToFilename(string));
        DatabaseObject databaseObject = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            databaseObject = (DatabaseObject)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Throwable throwable) {
            throw new DatabaseException("Error reading file " + file.getPath() + throwable);
        }
        return databaseObject;
    }

    private void removeObjectFile(String string) throws DatabaseException {
        File file = new File(this._db_dir, SerializationDatabase.keyToFilename(string));
        if (!file.delete()) {
            throw new DatabaseException("Error removing file " + file.getPath() + " !");
        }
    }

    private void updateObjectFile(DatabaseObject databaseObject) throws DatabaseException {
        this.removeObjectFile(databaseObject.getObjectID());
        this.writeObjectFile(databaseObject);
    }

    private Enumeration getObjectFileEnumeration() throws DatabaseException {
        Vector<String> vector = new Vector<String>();
        try {
            String[] stringArray = this._db_dir.list();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(SerializationDatabase.filenameToKey(stringArray[n]));
                ++n;
            }
        }
        catch (Throwable throwable) {
            throw new DatabaseException("Problem when creating list of objects in DB: " + throwable);
        }
        return vector.elements();
    }
}

