/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.agent;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.test.agent.AgentTestFramework;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AgentMessagingTest
extends TestCase {
    private static final int MSG_COUNT = 10;
    private static final int AGENT_COUNT = 3;
    private TestAgent[] _agents = new TestAgent[3];
    private String[] _agent_names = new String[3];

    public AgentMessagingTest(String string) {
        super(string);
    }

    protected void setUp() {
        int n = 0;
        while (n < 3) {
            this._agents[n] = new TestAgent("testagent" + n);
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            this._agent_names[n2] = "testagent" + n2 + "@" + this._agents[n2].getPlatformProfile().getHAPName();
            ++n2;
        }
    }

    protected void tearDown() {
        int n = 0;
        while (n < 3) {
            if (this._agents[n] != null) {
                this._agents[n].shutdown();
                this._agents[n] = null;
            }
            ++n;
        }
    }

    protected void runTest() throws Throwable {
        this.messageTest1();
        this.multicastTest1();
    }

    private void messageTest1() throws Throwable {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        while (n4 < 3) {
            this._agents[n4]._rcvd = 0;
            ++n4;
        }
        int n5 = 0;
        while (n5 < 10) {
            int n6 = 0;
            while (n6 < 3) {
                n3 = 0;
                while (n3 < 3) {
                    if (n6 != n3) {
                        this._agents[n6].sendMessage(this._agent_names[n3]);
                    }
                    ++n3;
                }
                ++n6;
            }
            ++n5;
        }
        int[] nArray = new int[3];
        n3 = 0;
        do {
            n2 = 0;
            while (n2 < 3) {
                nArray[n2] = this._agents[n2]._rcvd;
                ++n2;
            }
            Thread.sleep(1000L);
            n3 = 0;
            n = 0;
            while (n < 3) {
                n3 |= nArray[n] < this._agents[n]._rcvd ? 1 : 0;
                ++n;
            }
        } while (n3 != 0);
        n2 = 20;
        n = 0;
        while (n < 3) {
            Assert.assert((String)("Agent " + n + " received " + this._agents[n]._rcvd + "/" + n2), (this._agents[n]._rcvd == n2 ? 1 : 0) != 0);
            ++n;
        }
    }

    private void multicastTest1() throws Throwable {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < 3) {
            this._agents[n3]._rcvd = 0;
            ++n3;
        }
        List<String> list = Arrays.asList(this._agent_names);
        int n4 = 0;
        while (n4 < 10) {
            int n5 = 0;
            while (n5 < 3) {
                LinkedList<String> linkedList = new LinkedList<String>(list);
                linkedList.remove(this._agent_names[n5]);
                this._agents[n5].sendMulticastMessage(linkedList);
                ++n5;
            }
            ++n4;
        }
        int[] nArray = new int[3];
        boolean bl = false;
        do {
            n2 = 0;
            while (n2 < 3) {
                nArray[n2] = this._agents[n2]._rcvd;
                ++n2;
            }
            Thread.sleep(1000L);
            bl = false;
            n = 0;
            while (n < 3) {
                bl |= nArray[n] < this._agents[n]._rcvd;
                ++n;
            }
        } while (bl);
        n2 = 20;
        n = 0;
        while (n < 3) {
            Assert.assert((String)("Agent " + n + " received " + this._agents[n]._rcvd + "/" + n2), (this._agents[n]._rcvd == n2 ? 1 : 0) != 0);
            ++n;
        }
    }

    public class TestAgent
    extends FIPAOSAgent {
        public int _rcvd = 0;

        public TestAgent(String string) {
            super(AgentTestFramework.getPlatformProfile("testhap"), AgentTestFramework.getAgentProfile(), string, "MicroFIPAOS_Test", true);
            this.setListenerTask(new IdleTask());
        }

        public void sendMessage(String string) {
            AgentID agentID = new AgentID();
            agentID.setName(string);
            ACL aCL = new ACL();
            aCL.setSenderAID(this.getAID());
            aCL.setReceiverAID(agentID);
            aCL.setPerformative("inform");
            aCL.setConversationID(this.getAID().getName());
            this.forward(aCL);
        }

        public void sendMulticastMessage(List list) {
            Cloneable cloneable;
            LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                cloneable = new AgentID();
                ((AgentID)cloneable).setName((String)iterator.next());
                linkedList.add(cloneable);
            }
            cloneable = new ACL();
            ((ACL)cloneable).setSenderAID(this.getAID());
            ((ACL)cloneable).setReceiverAIDs(linkedList);
            ((ACL)cloneable).setPerformative("inform");
            ((ACL)cloneable).setConversationID(this.getAID().getName());
            this.forward((ACL)cloneable);
        }

        public class IdleTask
        extends Task {
            public void handleInform(Conversation conversation) {
                ++TestAgent.this._rcvd;
            }
        }
    }
}

