/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.agent;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.conversation.ConversationManager;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.Envelope;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class MessageTimingAgent
extends FIPAOSAgent {
    private static final int MAX_ITER = 100;
    private static final String ROUND_TRIP = "rt";
    private static final int[] _payload_sizes = new int[]{1, 100, 1000, 5000};
    private AgentID _counterpart;
    private Map[] _results = new Map[_payload_sizes.length];
    private int _current_payload = 0;

    public MessageTimingAgent(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setListenerTask(new IdleTask());
    }

    List getList(String string) {
        LinkedList linkedList;
        HashMap hashMap = this._results[this._current_payload];
        if (hashMap == null) {
            hashMap = this._results[this._current_payload] = new HashMap();
        }
        if ((linkedList = (LinkedList)hashMap.get(string)) == null) {
            linkedList = new LinkedList();
            hashMap.put(string, linkedList);
        }
        return linkedList;
    }

    long calcAverage(List list) {
        long l = 0L;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            l += ((Long)iterator.next()).longValue();
        }
        return l /= (long)list.size();
    }

    public ConversationManager getCM() {
        return super.getCM();
    }

    public static void main(String[] stringArray) {
        new MessageTimingAgent(stringArray[1], stringArray[0], "fipaos");
    }

    public class MessageTestTask
    extends Task {
        private long _start;
        private ACL _message = new ACL();
        private long _round_trip;

        public MessageTestTask(AgentID agentID, Object object) {
            this._message.setPerformative("request");
            this._message.setSenderAID(MessageTimingAgent.this.getAID());
            this._message.setReceiverAID(agentID);
            this._message.setContentObject(object);
        }

        public void startTask() {
            this._start = System.currentTimeMillis();
            this.forward(this._message);
        }

        public void handleInform(Conversation conversation) {
            Object object;
            String string;
            long l = System.currentTimeMillis() - this._start;
            Envelope envelope = conversation.getEnvelope(conversation.getLatestMessageIndex());
            Set set = envelope.getUserSlots();
            Iterator iterator = set.iterator();
            long l2 = Long.MAX_VALUE;
            while (iterator.hasNext()) {
                try {
                    string = (String)iterator.next();
                    object = envelope.getSlotValue(string);
                    if (!string.startsWith("X-fipaos-debug-")) continue;
                    Long l3 = null;
                    if (object instanceof String) {
                        l3 = new Long((String)object);
                    } else if (object instanceof Long) {
                        l3 = (Long)object;
                    }
                    if (l3 == null || l3 >= l2) continue;
                    l2 = l3;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            set = envelope.getUserSlots();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    string = (String)iterator.next();
                    object = envelope.getSlotValue(string);
                    if (!string.startsWith("X-fipaos-debug-")) continue;
                    string = string.substring("X-fipaos-debug-".length());
                    if (object instanceof String) {
                        long l4 = Long.parseLong((String)object) - l2;
                        MessageTimingAgent.this.getList(string).add(new Long(l4));
                        continue;
                    }
                    if (!(object instanceof Long)) continue;
                    long l5 = (Long)object - l2;
                    MessageTimingAgent.this.getList(string).add(new Long(l5));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                MessageTimingAgent.this.getCM().removeConversation(conversation.getConversationID());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.done(new Long(l));
        }

        public void handleOther(Conversation conversation) {
            throw new RuntimeException("Unexpected response from target agent");
        }
    }

    public class TestingTask
    extends Task {
        private AgentID _target;
        private boolean _reachable;
        private int _iteration;
        private String _payload;

        public TestingTask(AgentID agentID) {
            this._target = agentID;
        }

        public void startTask() {
            this.newTask((Task)new MessageTestTask(this._target, (Object)"( inital-test )"), 30000L);
        }

        public void startTesting() {
            if (MessageTimingAgent.this._current_payload >= _payload_sizes.length) {
                this.finishedTesting();
            } else {
                this._iteration = 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("( ");
                int n = 0;
                while (n < _payload_sizes[MessageTimingAgent.this._current_payload]) {
                    stringBuffer.append("t");
                    ++n;
                }
                stringBuffer.append(" )");
                this._payload = stringBuffer.toString();
                this.continueTesting();
            }
        }

        public void continueTesting() {
            ++this._iteration;
            if (this._iteration > 100) {
                this._iteration = 0;
                MessageTimingAgent.this._current_payload++;
                this.startTesting();
            } else {
                this.newTask((Task)new MessageTestTask(this._target, (Object)this._payload), 15000L);
            }
        }

        public void finishedTesting() {
            StringBuffer stringBuffer = new StringBuffer("\nResults\n=======\n\n");
            int n = 0;
            while (n < _payload_sizes.length) {
                stringBuffer.append("Payload = " + _payload_sizes[n] + "\n");
                Map map = MessageTimingAgent.this._results[n];
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    long l = MessageTimingAgent.this.calcAverage((List)map.get(string));
                    stringBuffer.append("\t" + string + "\t" + l + "\n");
                }
                stringBuffer.append("\n\n");
                ++n;
            }
            this.done();
        }

        public void timeoutMessageTimingAgent_MessageTestTask(Task task) {
            this.finishedTesting();
        }

        public void doneMessageTimingAgent_MessageTestTask(Object object) {
            if (!this._reachable) {
                this._reachable = true;
                this.startTesting();
            } else {
                MessageTimingAgent.this.getList(MessageTimingAgent.ROUND_TRIP).add(object);
                this.continueTesting();
            }
        }
    }

    public class IdleTask
    extends Task {
        public void startTask() {
            String string = JOptionPane.showInputDialog("Counter-part agent name? (or hit cancel to just listen)");
            if (string != null && string.length() > 0) {
                MessageTimingAgent.this._counterpart = new AgentID();
                MessageTimingAgent.this._counterpart.setName(string);
            }
            if (MessageTimingAgent.this._counterpart != null) {
                this._tm.newTask(new TestingTask(MessageTimingAgent.this._counterpart));
            }
        }

        public void handleRequest(Conversation conversation) {
            ACL aCL = (ACL)conversation.getACL(conversation.getLatestMessageIndex()).clone();
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(MessageTimingAgent.this.getAID());
            aCL.setPerformative("inform");
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            this.forward(aCL);
            try {
                MessageTimingAgent.this.getCM().removeConversation(aCL.getConversationID());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

