/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.agent;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.test.agent.AgentTestFramework;
import fipaos.util.DIAGNOSTICS;
import junit.framework.Assert;
import junit.framework.TestCase;

public class NotUnderstoodTest
extends TestCase {
    private static final int AGENT_COUNT = 2;
    private TestAgent[] _agents = new TestAgent[2];
    private String[] _agent_names = new String[2];

    public NotUnderstoodTest(String string) {
        super(string);
    }

    protected void setUp() {
        DIAGNOSTICS.setFileLevel(1);
        int n = 0;
        while (n < 2) {
            this._agents[n] = new TestAgent("testagent" + n);
            ++n;
        }
        int n2 = 0;
        while (n2 < 2) {
            this._agent_names[n2] = "testagent" + n2 + "@" + this._agents[n2].getPlatformProfile().getHAPName();
            ++n2;
        }
    }

    protected void tearDown() {
        int n = 0;
        while (n < 2) {
            if (this._agents[n] != null) {
                this._agents[n].shutdown();
                this._agents[n] = null;
            }
            ++n;
        }
    }

    protected void runTest() throws Throwable {
        this.messageTest1();
    }

    private void messageTest1() throws Throwable {
        this._agents[1].not_understoods_recieved = 0;
        this._agents[0].not_understoods_recieved = 0;
        int n = 2;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            this._agents[0].sendMessage(this._agent_names[1]);
            ++n3;
        }
        Thread.sleep(1000L);
        Assert.assert((String)"More than one not-understood recieved within a single conversation with no protocol . Error occured", (this._agents[1].not_understoods_recieved != n ? 1 : 0) != 0);
        this._agents[1].not_understoods_recieved = 0;
        n2 = 0;
        this._agents[0].sendMessage3(this._agent_names[1]);
        ++n2;
        this._agents[0].sendMessage4(this._agent_names[1]);
        this._agents[0].sendMessage3(this._agent_names[1]);
        Thread.sleep(2000L);
        Assert.assert((String)"Number of not-understood messages sent is not the same as the number of not-understood messages received. Error occured", (this._agents[1].not_understoods_recieved == ++n2 ? 1 : 0) != 0);
    }

    private void messageTest2() throws Throwable {
        this._agents[1].not_understoods_recieved = 0;
        this._agents[0].not_understoods_recieved = 0;
        this._agents[0].sendMessage2(this._agent_names[1]);
        int[] nArray = new int[2];
        boolean bl = false;
        Thread.sleep(1000L);
        Assert.assert((String)"Not-understood recieved in reply to a not-understood", (this._agents[0].not_understoods_recieved > 0 ? 1 : 0) != 0);
    }

    public class TestAgent
    extends FIPAOSAgent {
        public int not_understoods_recieved = 0;
        public int requests_recieved = 0;

        public TestAgent(String string) {
            super(AgentTestFramework.getPlatformProfile("testhap"), AgentTestFramework.getAgentProfile(), string, "MicroFIPAOS_Test", true);
            this.setListenerTask(new IdleTask());
        }

        public void sendMessage(String string) {
            AgentID agentID = new AgentID();
            agentID.setName(string);
            ACL aCL = new ACL();
            aCL.setSenderAID(this.getAID());
            aCL.setReceiverAID(agentID);
            aCL.setPerformative("not-understood");
            aCL.setConversationID(this.getAID().getName());
            this.forward(aCL);
        }

        public void sendMessage2(String string) {
            AgentID agentID = new AgentID();
            agentID.setName(string);
            ACL aCL = new ACL();
            aCL.setSenderAID(this.getAID());
            aCL.setReceiverAID(agentID);
            aCL.setPerformative("request");
            aCL.setProtocol("fipa-request");
            this.forward(aCL);
        }

        public void sendMessage3(String string) {
            AgentID agentID = new AgentID();
            agentID.setName(string);
            ACL aCL = new ACL();
            aCL.setSenderAID(this.getAID());
            aCL.setReceiverAID(agentID);
            aCL.setPerformative("not-understood");
            aCL.setConversationID(this.getAID().getName() + "1");
            this.forward(aCL);
        }

        public void sendMessage4(String string) {
            AgentID agentID = new AgentID();
            agentID.setName(string);
            ACL aCL = new ACL();
            aCL.setSenderAID(this.getAID());
            aCL.setReceiverAID(agentID);
            aCL.setPerformative("inform");
            aCL.setConversationID(this.getAID().getName() + "1");
            this.forward(aCL);
        }

        public class IdleTask
        extends Task {
            public void handleRequest(Conversation conversation) {
                ++TestAgent.this.requests_recieved;
                int n = conversation.getLatestMessageIndex();
                ACL aCL = conversation.getACL(n);
                String string = aCL.getPerformative();
                ACL aCL2 = conversation.getFilledInACL();
                aCL2.setPerformative("not-understood");
                aCL2.setReceiverAID(aCL.getSenderAID());
                this.forward(aCL2);
            }

            public void handleInform(Conversation conversation) {
            }

            public void handleOther(Conversation conversation) {
                int n = conversation.getLatestMessageIndex();
                ACL aCL = conversation.getACL(n);
                String string = aCL.getPerformative();
                String string2 = aCL.getProtocol();
                ++TestAgent.this.not_understoods_recieved;
            }
        }
    }
}

