/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.mts.service;

import fipaos.mts.Message;
import fipaos.mts.service.ParserService;
import fipaos.mts.service.PostParserService;
import fipaos.mts.service.PreParserService;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.parser.acl.bitefficient.Parser;
import fipaos.test.mts.service.CollectorService;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ParserServiceTest
extends TestCase {
    public static final String ACL_STRING = "(inform :sender (agent-identifier :name someAgent@here.com :addresses (sequence fipaos-rmi://192.168.0.1/someAgent ) ) :receiver ( set (agent-identifier :name otherAgent@here.com :addresses (sequence fipaos-rmi://192.168.0.1/otherAgent ) ) ) :reply-to ( set (agent-identifier :name someAgent@here.com :addresses (sequence fipaos-rmi://192.168.0.1/someAgent ) ) ) :content some-content :reply-with reply-with-value :in-reply-to in-reply-to-value :conversation-id conversation-id-value )";
    public static final int[] ACL_INT = new int[]{250, 16, 8, 2, 2, 16, 115, 111, 109, 101, 65, 103, 101, 110, 116, 64, 104, 101, 114, 101, 46, 99, 111, 109, 0, 2, 16, 102, 105, 112, 97, 111, 115, 45, 114, 109, 105, 58, 47, 47, 49, 57, 50, 46, 49, 54, 56, 46, 48, 46, 49, 47, 115, 111, 109, 101, 65, 103, 101, 110, 116, 0, 1, 1, 3, 2, 16, 111, 116, 104, 101, 114, 65, 103, 101, 110, 116, 64, 104, 101, 114, 101, 46, 99, 111, 109, 0, 2, 16, 102, 105, 112, 97, 111, 115, 45, 114, 109, 105, 58, 47, 47, 49, 57, 50, 46, 49, 54, 56, 46, 48, 46, 49, 47, 111, 116, 104, 101, 114, 65, 103, 101, 110, 116, 0, 1, 1, 1, 13, 16, 99, 111, 110, 118, 101, 114, 115, 97, 116, 105, 111, 110, 45, 105, 100, 45, 118, 97, 108, 117, 101, 0, 8, 2, 16, 115, 111, 109, 101, 65, 103, 101, 110, 116, 64, 104, 101, 114, 101, 46, 99, 111, 109, 0, 2, 16, 102, 105, 112, 97, 111, 115, 45, 114, 109, 105, 58, 47, 47, 49, 57, 50, 46, 49, 54, 56, 46, 48, 46, 49, 47, 115, 111, 109, 101, 65, 103, 101, 110, 116, 0, 1, 1, 1, 4, 16, 115, 111, 109, 101, 45, 99, 111, 110, 116, 101, 110, 116, 0, 7, 16, 105, 110, 45, 114, 101, 112, 108, 121, 45, 116, 111, 45, 118, 97, 108, 117, 101, 0, 5, 16, 114, 101, 112, 108, 121, 45, 119, 105, 116, 104, 45, 118, 97, 108, 117, 101, 0, 1, 13, 10};
    private static final byte[] ACL_BYTE = new byte[ACL_INT.length];
    private ParserService _ps;
    private CollectorService _before;
    private CollectorService _after;

    public ParserServiceTest(String string) {
        super(string);
    }

    protected void setUp() {
        this._ps = new ParserService();
        this._before = new CollectorService();
        this._after = new CollectorService();
        this._ps.initialise(this._before, (PreParserService)null);
        this._ps.initialise((PostParserService)null, this._after);
    }

    protected void runTest() throws Throwable {
        this.testGoodOutgoingMessages();
        this.testGoodIncomingMessages();
    }

    private void testGoodOutgoingMessages() throws Throwable {
        ACL aCL = new ACL(ACL_STRING);
        Message message = new Message(aCL);
        Message message2 = new Message(aCL);
        message2.getEnvelope().setACLRepresentation("fipa.acl.rep.bitefficient.std");
        this._ps.outgoing(message);
        this._ps.outgoing(message2);
        Object[] objectArray = this._after.getNextEnvelopeAndByteArray();
        Object[] objectArray2 = this._after.getNextEnvelopeAndByteArray();
        Assert.assert((String)"No output from ParserService!", (objectArray[1] != null ? 1 : 0) != 0);
        ACL aCL2 = new ACL(new String((byte[])objectArray[1]));
        Assert.assert((String)"Standard ACL encoding hasn't occured as expected", (boolean)aCL2.toString().equals(aCL.toString()));
        Assert.assert((String)"No output from ParserService!", (objectArray2[1] != null ? 1 : 0) != 0);
        ACL aCL3 = Parser.parse((byte[])objectArray2[1]);
        Assert.assert((String)"BitEfficient ACL wasn't deparsed correctly", (aCL3 != null ? 1 : 0) != 0);
        Assert.assert((String)"BitEfficient ACL encoding hasn't occured as expected", (boolean)aCL3.toString().equals(aCL.toString()));
    }

    private void testGoodIncomingMessages() throws Throwable {
        ACL aCL = new ACL(ACL_STRING);
        byte[] byArray = aCL.toString().getBytes();
        byte[] byArray2 = Parser.deparse(aCL);
        Envelope envelope = new Envelope();
        Envelope envelope2 = new Envelope();
        envelope2.setACLRepresentation("fipa.acl.rep.bitefficient.std");
        this._ps.incoming(envelope, byArray);
        this._ps.incoming(envelope2, byArray2);
        Message message = this._before.getNextMessage();
        Message message2 = this._before.getNextMessage();
        Assert.assert((String)"Standard ACL decoding hasn't occured as expected", (boolean)message.getACL().toString().equals(aCL.toString()));
        Assert.assert((String)"BitEfficient ACL decoding hasn't occured as expected", (boolean)message2.getACL().toString().equals(aCL.toString()));
    }

    static {
        int n = 0;
        while (n < ACL_INT.length) {
            int n2 = ACL_INT[n];
            ParserServiceTest.ACL_BYTE[n] = n2 >= 129 ? (byte)(n2 - 256) : (byte)n2;
            ++n;
        }
    }
}

