/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.ont.fipa.fipaman;

import fipaos.ont.fipa.fipaman.AgentManagementAction;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AgentManagementActionTest
extends TestCase {
    public static final String[] JADE_CONTENT = new String[]{"(action (agent-identifier :name df@IBM10308:1099/JADE :addresses (sequence ) :resolvers (sequence ) ) (register (df-agent-description :name (agent-identifier :name df@cmddata :addresses (sequence fipaos-rmi://cmddata:3000/df ) :resolvers (sequence ) ) :services (set (service-description :name fipa-df :type fipa-df :ontologies (set ) :languages (set ) :protocols (set ) :properties (set ) ) ) :protocols (set ) :ontologies (set ) :languages (set ) ) ) ) ", "(action (agent-identifier :name df@cmddata :addresses (sequence fipaos-rmi://cmddata:3000/df fipaos-rmi://cmddata:3000/acc IOR:000000000000001149444c3a464950412f4d54533a312e30000000000000000100000000000000300001000000000008636d6464617461000700000000000018afabcafe00000002f6c4c59c000000080000000000000000 corbaname://cmddata:4000/acc ) :resolvers (sequence ) ) (search (df-agent-description :services (set ) :protocols (set ) :ontologies (set ) :languages (set ) ) (search-constraints :max-depth 0 :max-results 9 ) ) )"};

    public AgentManagementActionTest(String string) {
        super(string);
    }

    protected void setUp() {
    }

    protected void runTest() throws Throwable {
        this.testOldTests();
        this.testRegression1();
        this.testRegression2();
    }

    private void testOldTests() throws Throwable {
        String string = "(action (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) (register (ams-agent-description :name (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) :state active )))";
        AgentManagementAction agentManagementAction = new AgentManagementAction(string);
        Assert.assert((String)"Expected action isn't register", (boolean)agentManagementAction.getAction().equals("register"));
        Assert.assert((String)"Expected AMSAgentDescription not found", (agentManagementAction.getAMSAgentDescription() != null ? 1 : 0) != 0);
        Assert.assert((String)"Requestor not that expected", (boolean)agentManagementAction.getAMSAgentDescription().getAgentID().getName().equals("CameraProxy@foo.com"));
        Assert.assert((String)"Expected Agent state isn't \"active\"", (boolean)agentManagementAction.getAMSAgentDescription().getState().equals("active"));
        Assert.assert((String)"Unexpectedly found DFAgentDescription!", (agentManagementAction.getDFAgentDescription() == null ? 1 : 0) != 0);
        Assert.assert((String)"Unexpectedly found SearchConstraints!", (agentManagementAction.getSearchConstraints() == null ? 1 : 0) != 0);
        string = "(action (agent-identifier :name df@phard1f0.europe.nortel.com ) (register (df-agent-description :name (agent-identifier :name df2@phard1f0.europe.nortel.com :addresses (sequence fipaos-rmi://localhost:3000/df2 ) ) :services (set (service-description :type fipa-df )) ))) ";
        agentManagementAction = new AgentManagementAction(string);
        Assert.assert((String)"Expected action type not found!", (boolean)agentManagementAction.getAction().equals("register"));
        Assert.assert((String)"Unexpectedly found AMSAgentDescription", (agentManagementAction.getAMSAgentDescription() == null ? 1 : 0) != 0);
        Assert.assert((String)"Expected DFAgentDescription not found!", (agentManagementAction.getDFAgentDescription() != null ? 1 : 0) != 0);
        Assert.assert((String)"Requestor not that expected", (boolean)agentManagementAction.getDFAgentDescription().getAgentID().getName().equals("df2@phard1f0.europe.nortel.com"));
        Assert.assert((String)"Unexpected SearchConstratins found", (agentManagementAction.getSearchConstraints() == null ? 1 : 0) != 0);
        string = "(action (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) (search (df-agent-description :name (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) :ontology (set meeting-scheduler) :language (set FIPA-L0 KIF)) (search-constraints :max-depth 2)))";
        agentManagementAction = new AgentManagementAction(string);
        Assert.assert((String)"Expected action type not found!", (boolean)agentManagementAction.getAction().equals("search"));
        Assert.assert((String)"Unexpectedly found AMSAgentDescription", (agentManagementAction.getAMSAgentDescription() == null ? 1 : 0) != 0);
        Assert.assert((String)"Expected DFAgentDescription not found!", (agentManagementAction.getDFAgentDescription() != null ? 1 : 0) != 0);
        Assert.assert((String)"Requestor not that expected", (boolean)agentManagementAction.getDFAgentDescription().getAgentID().getName().equals("CameraProxy@foo.com"));
        Assert.assert((String)"Expected SearchConstratins not found", (agentManagementAction.getSearchConstraints() != null ? 1 : 0) != 0);
        Assert.assert((String)"Expected max-depth value of 2 not found", (agentManagementAction.getSearchConstraints().getMaxDepth() == 2 ? 1 : 0) != 0);
    }

    private void testRegression1() throws Throwable {
        String string = "(action (agent-identifier :name test1 ) (deregister (ams-agent-description :name (agent-identifier :name test2 )))))";
        AgentManagementAction agentManagementAction = new AgentManagementAction(string);
        Assert.assert((String)"AMSAgentDescription is null!", (agentManagementAction.getAMSAgentDescription() != null ? 1 : 0) != 0);
        Assert.assert((String)"Expected AID in AMSAgentDescription is null", (agentManagementAction.getAMSAgentDescription().getAgentID() != null ? 1 : 0) != 0);
        Assert.assert((String)"Expected AID not found", (boolean)agentManagementAction.getAMSAgentDescription().getAgentID().getName().equals("test2"));
    }

    private void testRegression2() throws Throwable {
        int n = 0;
        while (n < JADE_CONTENT.length) {
            try {
                AgentManagementAction agentManagementAction = new AgentManagementAction(JADE_CONTENT[n]);
            }
            catch (Throwable throwable) {
                Assert.assert((String)("JADE AgentManagement content " + (n + 1) + " failed to be parsed"), (boolean)false);
            }
            ++n;
        }
    }
}

