/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.ont.fipa.fipaman;

import fipaos.ont.fipa.fipaman.Envelope;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

public class EnvelopeTest
extends TestCase {
    public EnvelopeTest(String string) {
        super(string);
    }

    protected void setUp() {
    }

    protected void runTest() throws Throwable {
        this.testGetLatest();
        this.testUserSlots();
        this.testRegression1();
    }

    private void testGetLatest() throws Throwable {
        Envelope envelope = new Envelope();
        envelope.setACLRepresentation("type1");
        envelope.setACLRepresentation("type2");
        Assert.assert((String)"Slot value change failed (use of a single Envelope)", (boolean)envelope.getACLRepresentation().equals("type2"));
        envelope.setACLRepresentation("type1");
        envelope.newSubEnvelope();
        envelope.setACLRepresentation("type2");
        Assert.assert((String)"Slot value not correctly changed after new sub-envelope created", (boolean)envelope.getACLRepresentation().equals("type2"));
        Assert.assert((String)"Old slot value not maintained after new sub-envelope created", (boolean)envelope.getSubEnvelope(0).getACLRepresentation().equals("type1"));
    }

    private void testUserSlots() throws Throwable {
        Envelope envelope = new Envelope();
        String[] stringArray = new String[]{"X-test-1", "X-test-2", "X-test-3"};
        int n = 0;
        while (n < stringArray.length) {
            envelope.setSlotValue(stringArray[n], "test-value");
            ++n;
        }
        envelope.setPayloadEncoding("test-payload-enc");
        envelope.setPayloadLength(3);
        List<String> list = Arrays.asList(stringArray);
        Set set = envelope.getUserSlots();
        Assert.assert((String)"User-slots expected not found", (boolean)list.containsAll(set));
        Assert.assert((String)"Extra user-slots found", (boolean)set.containsAll(list));
    }

    private void testRegression1() throws Throwable {
        Envelope envelope = new Envelope();
        Envelope envelope2 = (Envelope)envelope.clone();
        envelope2.setACLRepresentation("test1");
        Assert.assert((String)"Envelope._current_envelop is decoupled from last Envelope in Envelope._sub_envelopes!", (envelope2.getACLRepresentation() != null && envelope2.getACLRepresentation().equals("test1") ? 1 : 0) != 0);
    }
}

