/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.parser.acl.bitefficient;

import fipaos.ont.fipa.ACL;
import fipaos.parser.acl.string.Parser;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ParserTest
extends TestCase {
    public static final String ACL_STRING = "(inform :sender (agent-identifier :name someAgent@here.com :addresses (sequence fipaos-rmi://192.168.0.1/someAgent ) ) :receiver ( set (agent-identifier :name otherAgent@here.com :addresses (sequence fipaos-rmi://192.168.0.1/otherAgent ) ) ) :reply-to ( set (agent-identifier :name someAgent@here.com :addresses (sequence fipaos-rmi://192.168.0.1/someAgent ) ) ) :content \"some-content\" :reply-with reply-with-value :in-reply-to in-reply-to-value :conversation-id conversation-id-value )";
    public static final int[] ACL_INT = new int[]{250, 16, 8, 2, 2, 16, 115, 111, 109, 101, 65, 103, 101, 110, 116, 64, 104, 101, 114, 101, 46, 99, 111, 109, 0, 2, 16, 102, 105, 112, 97, 111, 115, 45, 114, 109, 105, 58, 47, 47, 49, 57, 50, 46, 49, 54, 56, 46, 48, 46, 49, 47, 115, 111, 109, 101, 65, 103, 101, 110, 116, 0, 1, 1, 3, 2, 16, 111, 116, 104, 101, 114, 65, 103, 101, 110, 116, 64, 104, 101, 114, 101, 46, 99, 111, 109, 0, 2, 16, 102, 105, 112, 97, 111, 115, 45, 114, 109, 105, 58, 47, 47, 49, 57, 50, 46, 49, 54, 56, 46, 48, 46, 49, 47, 111, 116, 104, 101, 114, 65, 103, 101, 110, 116, 0, 1, 1, 1, 13, 16, 99, 111, 110, 118, 101, 114, 115, 97, 116, 105, 111, 110, 45, 105, 100, 45, 118, 97, 108, 117, 101, 0, 8, 2, 16, 115, 111, 109, 101, 65, 103, 101, 110, 116, 64, 104, 101, 114, 101, 46, 99, 111, 109, 0, 2, 16, 102, 105, 112, 97, 111, 115, 45, 114, 109, 105, 58, 47, 47, 49, 57, 50, 46, 49, 54, 56, 46, 48, 46, 49, 47, 115, 111, 109, 101, 65, 103, 101, 110, 116, 0, 1, 1, 1, 4, 16, 115, 111, 109, 101, 45, 99, 111, 110, 116, 101, 110, 116, 0, 7, 16, 105, 110, 45, 114, 101, 112, 108, 121, 45, 116, 111, 45, 118, 97, 108, 117, 101, 0, 5, 16, 114, 101, 112, 108, 121, 45, 119, 105, 116, 104, 45, 118, 97, 108, 117, 101, 0, 1, 13, 10};
    private static final byte[] ACL_BYTE = new byte[ACL_INT.length];
    private ACL _acl;

    public ParserTest(String string) {
        super(string);
    }

    protected void setUp() {
    }

    protected void runTest() throws Throwable {
        this.testParseAndDeparse();
        this.testComparePredefinedMessage();
    }

    private void testComparePredefinedMessage() throws Throwable {
        ACL aCL = Parser.parse(ACL_STRING.getBytes());
        byte[] byArray = fipaos.parser.acl.bitefficient.Parser.deparse(aCL);
        Assert.assert((String)"Deparsed ACL is null)", (byArray != null ? 1 : 0) != 0);
        Assert.assert((String)"Deparsed ACL doesn't match pre-produced Bit-Efficient ACL (length-wise)", (byArray.length != ACL_BYTE.length ? 1 : 0) != 0);
        int n = 0;
        while (n < byArray.length) {
            Assert.assert((String)"Deparsed ACL doesn't match pre-produced Bit-Efficient ACL (content-wise)", (ACL_BYTE[n] == byArray[n] ? 1 : 0) != 0);
            ++n;
        }
        ACL aCL2 = fipaos.parser.acl.bitefficient.Parser.parse(ACL_BYTE);
        Assert.assert((String)"Parsed Bit-Efficient ACL doesn't match pre-produced Stringified ACL", (boolean)new String(Parser.deparse(aCL2)).equals(ACL_STRING));
    }

    private void testParseAndDeparse() throws Throwable {
        ACL aCL = Parser.parse(ACL_STRING.getBytes());
        Assert.assert((String)"Parsed ACL is null)", (aCL != null ? 1 : 0) != 0);
        byte[] byArray = fipaos.parser.acl.bitefficient.Parser.deparse(aCL);
        ACL aCL2 = fipaos.parser.acl.bitefficient.Parser.parse(byArray);
        Assert.assert((String)"Deparsed ACL is null)", (byArray != null ? 1 : 0) != 0);
        Assert.assert((String)"String->BitEff.->String isn't reflexive!", (boolean)new String(Parser.deparse(aCL)).equals(new String(Parser.deparse(aCL2))));
    }

    static {
        int n = 0;
        while (n < ACL_INT.length) {
            int n2 = ACL_INT[n];
            ParserTest.ACL_BYTE[n] = n2 >= 129 ? (byte)(n2 - 256) : (byte)n2;
            ++n;
        }
    }
}

