/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.parser.envelope.xml;

import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.parser.envelope.xml.Parser;
import fipaos.util.URL;
import fipaos.util.UTCTime;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ParserTest
extends TestCase {
    private static String FIPA_EXAMPLE_ENVELOPE_1 = "<?xml version=\"1.0\"?>\n<envelope>\n\t<params index=\"1\">\n\t\t<to>\n\t\t\t<agent-identifier>\n\t\t\t\t<name>receiver@foo.com</name>\n\t\t\t\t<addresses>\n\t\t\t\t\t<url>http://foo.com/acc</url>\n\t\t\t\t</addresses>\n\t\t\t</agent-identifier>\n\t\t</to>\n\t\t<from>\n\t\t\t<agent-identifier>\n\t\t\t\t<name>sender@bar.com</name>\n\t\t\t\t<addresses>\n\t\t\t\t\t<url>http://bar.com/acc</url>\n\t\t\t\t</addresses>\n\t\t\t</agent-identifier>\n\t\t</from>\n\t\t<acl-representation>fipa.acl.rep.xml.std</acl-representation>\n\t\t<date>20000508T042651481</date>\n\t\t<encrypted>no encryption</encrypted>\n\t\t<received >\n\t\t\t<received-by value=\"http://foo.com/acc\" />\n\t\t\t<received-date value=\"20000508T042651481\" />\n\t\t\t<received-id value=\"123456789\" />\n\t\t</received>\n\t</params>\n</envelope>\n";

    public ParserTest(String string) {
        super(string);
    }

    protected void setUp() {
    }

    protected void runTest() throws Throwable {
        this.testComparePredefinedMessage();
    }

    private void testComparePredefinedMessage() throws Throwable {
        Envelope envelope = Parser.parse(FIPA_EXAMPLE_ENVELOPE_1.getBytes());
        this.testPredefinedEnvelope1(envelope);
        this.testPredefinedEnvelope1(Parser.parse(Parser.deparse(envelope)));
    }

    private void testPredefinedEnvelope1(Envelope envelope) {
        Assert.assert((String)"Receiver AID name not parsed correctly - not found in Envelope receiver field", (envelope.getReceivers() != null && envelope.getReceivers().size() > 0 ? 1 : 0) != 0);
        AgentID agentID = (AgentID)envelope.getReceivers().get(0);
        Assert.assert((String)"Receiver AID name not parsed correctly - name part not as expected", (boolean)agentID.getName().equals("receiver@foo.com"));
        Assert.assert((String)"Receiver AID addresses not parsed correctly - they're missing", (agentID.getAddresses() != null || agentID.getAddresses().size() > 0 ? 1 : 0) != 0);
        URL uRL = (URL)agentID.getAddresses().get(0);
        Assert.assert((String)("Receiver AID addresses not parsed correctly - address incorrect (\"" + uRL + "\")"), (boolean)uRL.equals(new URL("http://foo.com/acc")));
        Assert.assert((String)"Sender AID name not parsed correctly - not found in Envelope sender field", (envelope.getSender() != null ? 1 : 0) != 0);
        agentID = envelope.getSender();
        Assert.assert((String)"Sender AID name not parsed correctly - name part not as expected", (boolean)agentID.getName().equals("sender@bar.com"));
        Assert.assert((String)"Sender AID addresses not parsed correctly - they're missing", (agentID.getAddresses() != null || agentID.getAddresses().size() > 0 ? 1 : 0) != 0);
        uRL = (URL)agentID.getAddresses().get(0);
        Assert.assert((String)("Sender AID addresses not parsed correctly - address incorrect (\"" + uRL + "\")"), (boolean)uRL.equals(new URL("http://bar.com/acc")));
        Assert.assert((String)"Received parameter doesn't exist!", (envelope.getReceived() != null ? 1 : 0) != 0);
        Assert.assert((String)"Received.by value is incorrect", (envelope.getReceived().getBy() != null && envelope.getReceived().getBy().equals(new URL("http://foo.com/acc")) ? 1 : 0) != 0);
        Assert.assert((String)"Received.date value is incorrect", (envelope.getReceived().getDateTime() != null && envelope.getReceived().getDateTime().equals(new UTCTime("20000508T042651481")) ? 1 : 0) != 0);
        Assert.assert((String)"Received.id value is incorrect", (envelope.getReceived().getId() != null && envelope.getReceived().getId().equals("123456789") ? 1 : 0) != 0);
        Assert.assert((String)("ACL representation not parsed correctly (\"" + envelope.getACLRepresentation() + "\")"), (envelope.getACLRepresentation() != null && envelope.getACLRepresentation().equals("fipa.acl.rep.xml.std") ? 1 : 0) != 0);
        Assert.assert((String)("Date not parsed correctly (\"" + envelope.getDate() + "\")"), (envelope.getDate() != null && envelope.getDate().equals(new UTCTime("20000508T042651481")) ? 1 : 0) != 0);
        Assert.assert((String)("Encryption settings not parsed correctly (\"" + envelope.getEncrypted() + "\")"), (envelope.getEncrypted() != null && envelope.getEncrypted().size() > 0 && envelope.getEncrypted().get(0).equals("no encryption") ? 1 : 0) != 0);
    }

    private void testParseAndDeparse() throws Throwable {
    }
}

