/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.platform;

import fipaos.mts.Message;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementException;
import fipaos.test.agent.AgentTestFramework;
import junit.framework.Assert;

public class AMSAgentTest
extends AgentTestFramework {
    public final String REGISTRATION_MSG = "(action %ams% (register (ams-agent-description :name %test% :state active))))";
    public final String DEREGISTRATION_MSG = "(action %ams% (deregister (ams-agent-description :name %test%))))";
    public final String MODIFICATION_MSG = "(action %ams% (modify (ams-agent-description :name %test% :state wait))))";
    private long _conv_id_count = 0L;
    private AgentID _ams_aid;

    public AMSAgentTest(String string) {
        super(string);
    }

    protected void setUp() {
        super.setUp();
        this._ams_aid = new AgentID();
        this._ams_aid.setName(this.getTestAgentName() + "@" + this.getAPName());
        this.startAgent(this.getTestAgentName(), "fipaos.platform.AgentManagementSystem");
    }

    protected void runTest() throws Throwable {
        this.testFirstRegistrationDeregistration();
        this.testDeregisterWithoutRegister();
        this.testAlreadyRegisted();
        this.testModification();
    }

    private void testFirstRegistrationDeregistration() throws Throwable {
        this.sendRegistrationMessage();
        Message message = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when registering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't succeed in registration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
        this.sendDeregistrationMessage();
        Message message3 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when deregistering", (boolean)message3.getACL().getPerformative().equals("agree"));
        Message message4 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't succeed in deregistration as expected", (boolean)message4.getACL().getPerformative().equals("inform"));
    }

    private void testDeregisterWithoutRegister() throws Throwable {
        this.sendDeregistrationMessage();
        Message message = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when deregistering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't indicate failure as expected", (boolean)message2.getACL().getPerformative().equals("failure"));
        AgentManagementException agentManagementException = (AgentManagementException)message2.getACL().getContentObject();
        Assert.assert((String)"AMS failure reason not \"not-registered\" as expected", (boolean)agentManagementException.getException().equals("not-registered"));
    }

    private void testAlreadyRegisted() throws Throwable {
        this.sendRegistrationMessage();
        Message message = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when deregistering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't succeed in registration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
        this.sendRegistrationMessage();
        Message message3 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when deregistering", (boolean)message3.getACL().getPerformative().equals("agree"));
        Message message4 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't indicate failure as expected", (boolean)message4.getACL().getPerformative().equals("failure"));
        AgentManagementException agentManagementException = (AgentManagementException)message4.getACL().getContentObject();
        Assert.assert((String)"AMS failure reason not \"not-registered\" as expected", (boolean)agentManagementException.getException().equals("already-registered"));
        this.sendDeregistrationMessage();
        Message message5 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when deregistering", (boolean)message5.getACL().getPerformative().equals("agree"));
        Message message6 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't succeed in deregistration as expected", (boolean)message6.getACL().getPerformative().equals("inform"));
    }

    private void testModification() throws Throwable {
        this.sendModificationMessage();
        Message message = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when modifying", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't fail as expected when modifying", (boolean)message2.getACL().getPerformative().equals("failure"));
        AgentManagementException agentManagementException = (AgentManagementException)message2.getACL().getContentObject();
        Assert.assert((String)"AMS failure reason not \"not-registered\" as expected", (boolean)agentManagementException.getException().equals("not-registered"));
        this.sendRegistrationMessage();
        Message message3 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when registering", (boolean)message3.getACL().getPerformative().equals("agree"));
        Message message4 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't succeed in registration as expected", (boolean)message4.getACL().getPerformative().equals("inform"));
        this.sendModificationMessage();
        Message message5 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when modifying", (boolean)message5.getACL().getPerformative().equals("agree"));
        Message message6 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't succeed in modifying as expected", (boolean)message6.getACL().getPerformative().equals("inform"));
        this.sendDeregistrationMessage();
        Message message7 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't agree as expected when deregistering", (boolean)message7.getACL().getPerformative().equals("agree"));
        Message message8 = this.getIncomingMessage();
        Assert.assert((String)"AMS didn't succeed in deregistration as expected", (boolean)message8.getACL().getPerformative().equals("inform"));
    }

    private void sendRegistrationMessage() {
        String string = AgentTestFramework.findAndReplace("(action %ams% (register (ams-agent-description :name %test% :state active))))", "%ams%", this._ams_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        ACL aCL = new ACL();
        aCL.setContentObject(string);
        aCL.setSenderAID(this.getAID());
        aCL.setReceiverAID(this._ams_aid);
        aCL.setProtocol("fipa-request");
        aCL.setPerformative("request");
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setConversationID(Long.toString(this._conv_id_count++));
        this.sendMessage(new Message(aCL));
    }

    private void sendDeregistrationMessage() {
        String string = AgentTestFramework.findAndReplace("(action %ams% (deregister (ams-agent-description :name %test%))))", "%ams%", this._ams_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        ACL aCL = new ACL();
        aCL.setContentObject(string);
        aCL.setSenderAID(this.getAID());
        aCL.setReceiverAID(this._ams_aid);
        aCL.setProtocol("fipa-request");
        aCL.setPerformative("request");
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setConversationID(Long.toString(this._conv_id_count++));
        this.sendMessage(new Message(aCL));
    }

    private void sendModificationMessage() {
        String string = AgentTestFramework.findAndReplace("(action %ams% (modify (ams-agent-description :name %test% :state wait))))", "%ams%", this._ams_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        ACL aCL = new ACL();
        aCL.setContentObject(string);
        aCL.setSenderAID(this.getAID());
        aCL.setReceiverAID(this._ams_aid);
        aCL.setProtocol("fipa-request");
        aCL.setPerformative("request");
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setConversationID(Long.toString(this._conv_id_count++));
        this.sendMessage(new Message(aCL));
    }

    protected String getAPName() {
        return "testap";
    }

    protected String getTestAgentName() {
        return "ams";
    }
}

