/*
 * Decompiled with CFR 0.152.
 */
package fipaos.test.platform.df;

import fipaos.mts.Message;
import fipaos.mts.rmi.internal.ns.RMIAgentNamingServiceImpl;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.fipa.fipaman.ServiceDescription;
import fipaos.ont.proprietary.subscription.DFSubscriptionAction;
import fipaos.test.agent.AgentTestFramework;
import fipaos.util.DIAGNOSTICS;
import java.util.HashSet;
import junit.framework.Assert;

public class DFSubscriptionTest
extends AgentTestFramework {
    private AgentID _df_aid;
    private DFSubscriptionAction _subscribe_no_constraints;
    private DFSubscriptionAction _subscribe_with_constraints1;
    private DFSubscriptionAction _subscribe_with_constraints2;
    private DFSubscriptionAction _subscribe_with_constraints3;
    private DFSubscriptionAction _subscribe_with_constraints4;
    private DFSubscriptionAction _subscribe_with_constraints5;
    private DFAgentDescription[] _description1;
    private DFAgentDescription[] _description2;
    private DFAgentDescription[] _description3;
    private DFAgentDescription[] _description4;
    private DFAgentDescription[] _description5;
    private RMIAgentNamingServiceImpl _name_service = null;
    public final String REGISTRATION_MSG = "(action %df% (register (df-agent-description :name %test% :state active))))";
    public final String DEREGISTRATION_MSG = "(action %df% (deregister (df-agent-description :name %test%))))";
    public final String EMPTY_REGISTRATION_MSG = "(action %df% (register %desc%)))";
    private long _conv_id_count = 0L;

    public DFSubscriptionTest(String string) {
        super(string);
    }

    public void setUp() {
        super.setUp();
        this._subscribe_no_constraints = new DFSubscriptionAction();
        this._subscribe_no_constraints.setDFAction(new String[]{"register", "deregister", "modify"});
        this._subscribe_with_constraints1 = new DFSubscriptionAction();
        this._subscribe_with_constraints1.setDFAction(new String[]{"register", "deregister", "modify"});
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        AgentID agentID = this.getAID();
        dFAgentDescription.setAgentID(agentID);
        this._description1 = new DFAgentDescription[]{dFAgentDescription};
        this._subscribe_with_constraints1.setDFDescriptions(this._description1);
        this._subscribe_with_constraints2 = new DFSubscriptionAction();
        this._subscribe_with_constraints2.setDFAction(new String[]{"register", "deregister", "modify"});
        DFAgentDescription dFAgentDescription2 = new DFAgentDescription();
        HashSet<ServiceDescription> hashSet = new HashSet<ServiceDescription>();
        ServiceDescription serviceDescription = new ServiceDescription();
        serviceDescription.setServiceName("test-service");
        hashSet.add(serviceDescription);
        dFAgentDescription2.setAgentID(agentID);
        dFAgentDescription2.setAgentServices(hashSet);
        this._description2 = new DFAgentDescription[]{dFAgentDescription2};
        this._subscribe_with_constraints2.setDFDescriptions(this._description2);
        this._subscribe_with_constraints3 = new DFSubscriptionAction();
        this._subscribe_with_constraints3.setDFAction(new String[]{"register", "deregister", "modify"});
        DFAgentDescription dFAgentDescription3 = new DFAgentDescription();
        dFAgentDescription3.setAgentID(agentID);
        dFAgentDescription3.setAgentServices(hashSet);
        String[] stringArray = new String[]{"test-language"};
        dFAgentDescription3.setLanguages(stringArray);
        this._description3 = new DFAgentDescription[]{dFAgentDescription3};
        this._subscribe_with_constraints3.setDFDescriptions(this._description3);
        this._subscribe_with_constraints4 = new DFSubscriptionAction();
        this._subscribe_with_constraints4.setDFAction(new String[]{"register", "deregister", "modify"});
        DFAgentDescription dFAgentDescription4 = new DFAgentDescription();
        dFAgentDescription4.setAgentID(agentID);
        dFAgentDescription4.setAgentServices(hashSet);
        dFAgentDescription4.setLanguages(stringArray);
        String[] stringArray2 = new String[]{"test-protocol"};
        dFAgentDescription4.setProtocols(stringArray2);
        this._description4 = new DFAgentDescription[]{dFAgentDescription4};
        this._subscribe_with_constraints4.setDFDescriptions(this._description4);
        this._subscribe_with_constraints5 = new DFSubscriptionAction();
        this._subscribe_with_constraints5.setDFAction(new String[]{"register", "deregister", "modify"});
        DFAgentDescription dFAgentDescription5 = new DFAgentDescription();
        dFAgentDescription5.setAgentID(agentID);
        dFAgentDescription5.setAgentServices(hashSet);
        dFAgentDescription5.setLanguages(stringArray);
        String[] stringArray3 = new String[]{"test-ontology"};
        dFAgentDescription5.setOntologies(stringArray3);
        this._description5 = new DFAgentDescription[]{dFAgentDescription5};
        this._subscribe_with_constraints5.setDFDescriptions(this._description5);
        this._df_aid = new AgentID();
        this._df_aid.setName(this.getTestAgentName() + "@" + this.getAPName());
        this.startAgent("ams", "fipaos.platform.AgentManagementSystem");
        this.startAgent(this.getTestAgentName(), "fipaos.platform.DirectoryFacilitator");
    }

    protected void tearDown() {
        super.tearDown();
        DIAGNOSTICS.flush();
    }

    protected void runTest() throws Throwable {
    }

    public String getAPName() {
        return "testap";
    }

    public String getTestAgentName() {
        return "df";
    }

    private void doUnsubscribe1() {
        String string = AgentTestFramework.findAndReplace("(action %df% (register (df-agent-description :name %test% :state active))))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        this.sendUnsubscribeMessage(string, 1);
    }

    private void doRegisterAgent1() {
        String string = AgentTestFramework.findAndReplace("(action %df% (register (df-agent-description :name %test% :state active))))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        this.sendRegistrationMessage(string, 11);
        Message message = this.getIncomingMessage();
        Assert.assert((String)("DF didn't agree as expected when registering, got " + message.getACL().getPerformative()), (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)("DF didn't succeed in registration as expected, got " + message2.getACL().getPerformative()), (boolean)message2.getACL().getPerformative().equals("inform"));
    }

    private void doDeregisterAgent1() {
        String string = AgentTestFramework.findAndReplace("(action %df% (deregister (df-agent-description :name %test%))))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        this.sendDeregistrationMessage(string, 111);
        Message message = this.getIncomingMessage();
        Assert.assert((String)("DF didn't agree as expected when deregistering, got " + message.getACL().getPerformative() + " content: " + message.getACL().getContentObject() + " conv_id: " + message.getACL().getConversationID()), (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in deregistration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
    }

    private void doRegisterAgent2() {
        AgentManagementAction agentManagementAction = new AgentManagementAction();
        agentManagementAction.setAgentID(this.getAID());
        agentManagementAction.setDFAgentDescription(this._description1[0]);
        agentManagementAction.setAction("register");
        this.sendRegistrationMessage(agentManagementAction, 22);
        Message message = this.getIncomingMessage();
        Assert.assert((String)("DF didn't agree as expected when registering, got " + message.getACL().getPerformative() + " content: " + message.getACL().getContentObject()), (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in registration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
        Message message3 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't inform as expected", (boolean)message3.getACL().getPerformative().equals("inform"));
    }

    private void doRegisterAgent3() {
        AgentManagementAction agentManagementAction = new AgentManagementAction();
        agentManagementAction.setAgentID(this.getAID());
        agentManagementAction.setDFAgentDescription(this._description2[0]);
        agentManagementAction.setAction("register");
        this.sendRegistrationMessage(agentManagementAction, 33);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when registering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in registration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
        Message message3 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't inform as expected", (boolean)message3.getACL().getPerformative().equals("inform"));
    }

    private void doRegisterAgent4() {
        AgentManagementAction agentManagementAction = new AgentManagementAction();
        agentManagementAction.setAgentID(this.getAID());
        agentManagementAction.setDFAgentDescription(this._description3[0]);
        agentManagementAction.setAction("register");
        this.sendRegistrationMessage(agentManagementAction, 44);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when registering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in registration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
        Message message3 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't inform as expected", (boolean)message3.getACL().getPerformative().equals("inform"));
    }

    private void doRegisterAgent5() {
        AgentManagementAction agentManagementAction = new AgentManagementAction();
        agentManagementAction.setAgentID(this.getAID());
        agentManagementAction.setDFAgentDescription(this._description4[0]);
        agentManagementAction.setAction("register");
        this.sendRegistrationMessage(agentManagementAction, 55);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when registering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in registration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
        Message message3 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't inform as expected", (boolean)message3.getACL().getPerformative().equals("inform"));
    }

    private void doRegisterAgent6() {
        AgentManagementAction agentManagementAction = new AgentManagementAction();
        agentManagementAction.setAgentID(this.getAID());
        agentManagementAction.setDFAgentDescription(this._description5[0]);
        agentManagementAction.setAction("register");
        this.sendRegistrationMessage(agentManagementAction, 66);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when registering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in registration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
        Message message3 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't inform as expected", (boolean)message3.getACL().getPerformative().equals("inform"));
    }

    private void doSubscribeWithoutConstraints() {
        this.sendSubscriptionWithoutConstraintsMessage();
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in subscriptions as expected", (boolean)message.getACL().getPerformative().equals("inform"));
    }

    private void doDeregisterAgent2() {
        String string = AgentTestFramework.findAndReplace("(action %df% (deregister (df-agent-description :name %test%))))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        this.sendDeregistrationMessage(string, 222);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when deregistering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in deregistration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
    }

    private void doDeregisterAgent3() {
        String string = AgentTestFramework.findAndReplace("(action %df% (deregister (df-agent-description :name %test%))))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        this.sendDeregistrationMessage(string, 333);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when deregistering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in deregistration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
    }

    private void doDeregisterAgent4() {
        String string = AgentTestFramework.findAndReplace("(action %df% (deregister (df-agent-description :name %test%))))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        this.sendDeregistrationMessage(string, 444);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when deregistering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in deregistration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
    }

    private void doDeregisterAgent5() {
        String string = AgentTestFramework.findAndReplace("(action %df% (deregister (df-agent-description :name %test%))))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        this.sendDeregistrationMessage(string, 555);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when deregistering", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in deregistration as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
    }

    private void doUnsubscribe2() {
        String string = AgentTestFramework.findAndReplace("(action %df% (register %desc%)))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        string = AgentTestFramework.findAndReplace(string, "%desc%", this._description1.toString());
        this.sendUnsubscribeMessage(string, 2);
    }

    private void doUnsubscribe3() {
        String string = AgentTestFramework.findAndReplace("(action %df% (register %desc%)))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        string = AgentTestFramework.findAndReplace(string, "%desc%", this._description2.toString());
        this.sendUnsubscribeMessage(string, 3);
    }

    private void doUnsubscribe4() {
        String string = AgentTestFramework.findAndReplace("(action %df% (register %desc%)))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        string = AgentTestFramework.findAndReplace(string, "%desc%", this._description3.toString());
        this.sendUnsubscribeMessage(string, 4);
    }

    private void doUnsubscribe5() {
        String string = AgentTestFramework.findAndReplace("(action %df% (register %desc%)))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        string = AgentTestFramework.findAndReplace(string, "%desc%", this._description4.toString());
        this.sendUnsubscribeMessage(string, 5);
    }

    private void doSubscribeWithConstraints2() {
        this.sendSubscriptionWithConstraintsMessage(this._subscribe_with_constraints1, 2);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in subscriptions as expected", (boolean)message.getACL().getPerformative().equals("inform"));
    }

    private void doSubscribeWithConstraints3() {
        this.sendSubscriptionWithConstraintsMessage(this._subscribe_with_constraints2, 3);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in subscriptions as expected", (boolean)message.getACL().getPerformative().equals("inform"));
    }

    private void doSubscribeWithConstraints4() {
        this.sendSubscriptionWithConstraintsMessage(this._subscribe_with_constraints3, 4);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in subscriptions as expected", (boolean)message.getACL().getPerformative().equals("inform"));
    }

    private void doSubscribeWithConstraints5() {
        this.sendSubscriptionWithConstraintsMessage(this._subscribe_with_constraints4, 5);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in subscriptions as expected", (boolean)message.getACL().getPerformative().equals("inform"));
    }

    private void doSubscribeWithConstraints6() {
        this.sendSubscriptionWithConstraintsMessage(this._subscribe_with_constraints5, 6);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in subscriptions as expected", (boolean)message.getACL().getPerformative().equals("inform"));
    }

    private void doRegisterNonMatchingAgent() {
        String string = AgentTestFramework.findAndReplace("(action %df% (register (df-agent-description :name %test% :state active))))", "%df%", this._df_aid.toString());
        string = AgentTestFramework.findAndReplace(string, "%test%", this.getAID().toString());
        this.sendSubscriptionWithConstraintsMessage(string, 66);
        Message message = this.getIncomingMessage();
        Assert.assert((String)"DF didn't agree as expected when subscribing", (boolean)message.getACL().getPerformative().equals("agree"));
        Message message2 = this.getIncomingMessage();
        Assert.assert((String)"DF didn't succeed in subscriptions as expected", (boolean)message2.getACL().getPerformative().equals("inform"));
    }

    private void sendRegistrationMessage(Object object, int n) {
        ACL aCL = new ACL();
        aCL.setContentObject(object.toString());
        aCL.setSenderAID(this.getAID());
        aCL.setReceiverAID(this._df_aid);
        aCL.setProtocol("fipa-request");
        aCL.setPerformative("request");
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setConversationID(Integer.toString(n));
        this.sendMessage(new Message(aCL));
    }

    private void sendDeregistrationMessage(Object object, int n) {
        ACL aCL = new ACL();
        aCL.setContentObject(object.toString());
        aCL.setSenderAID(this.getAID());
        aCL.setReceiverAID(this._df_aid);
        aCL.setProtocol("fipa-request");
        aCL.setPerformative("request");
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setConversationID(Integer.toString(n));
        this.sendMessage(new Message(aCL));
    }

    private void sendUnsubscribeMessage(Object object, int n) {
        ACL aCL = new ACL();
        aCL.setContentObject(object);
        aCL.setSenderAID(this.getAID());
        aCL.setReceiverAID(this._df_aid);
        aCL.setProtocol("fipa-subscribe");
        aCL.setPerformative("cancel");
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setConversationID(Integer.toString(n));
        this.sendMessage(new Message(aCL));
    }

    private void sendSubscriptionWithConstraintsMessage(Object object, int n) {
        ACL aCL = new ACL();
        aCL.setContentObject(object);
        aCL.setSenderAID(this.getAID());
        aCL.setReceiverAID(this._df_aid);
        aCL.setProtocol("fipa-subscribe");
        aCL.setPerformative("subscribe");
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setConversationID(Integer.toString(n));
        this.sendMessage(new Message(aCL));
    }

    private void sendSubscriptionWithoutConstraintsMessage() {
        ACL aCL = new ACL();
        aCL.setContentObject(this._subscribe_no_constraints);
        aCL.setSenderAID(this.getAID());
        aCL.setReceiverAID(this._df_aid);
        aCL.setProtocol("fipa-subscribe");
        aCL.setPerformative("subscribe");
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setConversationID(Long.toString(1L));
        this.sendMessage(new Message(aCL));
    }

    public void test1() {
        this.doSubscribeWithoutConstraints();
        this.doRegisterAgent1();
        this.doUnsubscribe1();
        this.doDeregisterAgent1();
    }

    public void test2() {
        this.doSubscribeWithConstraints2();
        this.doRegisterAgent2();
        this.doUnsubscribe2();
        this.doDeregisterAgent2();
    }

    public void test3() {
        this.doSubscribeWithConstraints3();
        this.doRegisterAgent3();
        this.doUnsubscribe3();
        this.doDeregisterAgent3();
    }

    public void test4() {
        this.doSubscribeWithConstraints4();
        this.doRegisterAgent4();
        this.doUnsubscribe4();
        this.doDeregisterAgent4();
    }

    public void test5() {
        this.doSubscribeWithConstraints5();
        this.doRegisterAgent5();
        this.doUnsubscribe5();
        this.doDeregisterAgent5();
    }

    public void test6() {
        this.doSubscribeWithConstraints6();
        this.doRegisterAgent6();
    }
}

