/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.task.Task;
import fipaos.mts.Message;
import fipaos.tool.VisualACLParser;
import java.io.File;
import javax.swing.UIManager;

public class IOTestAgent
extends FIPAOSAgent {
    private VisualACLParser _visual = null;
    private IdleTask _idle = null;

    public IOTestAgent(String string, String string2, String string3) {
        super(string, string2, string3);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._idle = new IdleTask();
        this.setListenerTask(this._idle);
        PlatformProfile platformProfile = this.getPlatformProfile();
        File file = new File(platformProfile.getProfileDirectory());
        if (!file.exists()) {
            file = new File(".");
        } else if (!(file = new File(file.getParent(), "examples")).exists()) {
            file = new File(".");
        }
        this._visual = new VisualACLParser(this, file);
    }

    public void send(Message message) {
        this._idle.send(message);
    }

    public void shutdown() {
        this._visual.dispose();
        super.shutdown();
    }

    public void activate() {
        if (this._visual != null) {
            this._visual.setVisible(true);
        }
    }

    private class IdleTask
    extends Task {
        private IdleTask() {
        }

        public void handleOther(Conversation conversation) {
            IOTestAgent.this._visual.setACLMessage(conversation.getACL(conversation.getLatestMessageIndex()));
            IOTestAgent.this._visual.println("Received message");
        }

        public void send(Message message) {
            this.forward(message);
        }
    }
}

