/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.configurator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataBindingEditor
extends JDialog
implements ActionListener {
    private Object _to_edit;
    private Vector _members;
    private Vector _values;
    private Vector _jtf_editable;
    private Vector _jb_children;
    private JButton _jb_save;
    private JButton _jb_cancel;

    public DataBindingEditor(Object object, Object object2, String string) {
        super((Frame)((JFrame)object), true);
        Object object3;
        Object object4;
        this._to_edit = object2;
        this._members = this.getMembers(this._to_edit);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 25;
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JPanel jPanel2 = new JPanel(gridBagLayout);
        this._jtf_editable = new Vector();
        this._jb_children = new Vector();
        this._values = new Vector();
        int n = 0;
        while (n < this._members.size()) {
            Method method = (Method)this._members.get(n);
            object4 = new JLabel(method.getName().substring(3));
            gridBagLayout.setConstraints((Component)object4, gridBagConstraints);
            jPanel2.add((Component)object4);
            object3 = this.getCurrentValue(method);
            this._values.add(object3);
            if (this.returnsSimpleType(method)) {
                if (object3 == null) {
                    object3 = new String();
                }
                JTextField jTextField = new JTextField(object3.toString());
                this._jtf_editable.add(jTextField);
                gridBagLayout.setConstraints(jTextField, gridBagConstraints);
                jPanel2.add(jTextField);
            } else if (this.returnsListType(method)) {
                // empty if block
            }
            ++n;
        }
        object4 = this._to_edit.getClass().getName();
        if (((String)object4).indexOf(46) != -1) {
            object4 = ((String)object4).substring(((String)object4).lastIndexOf(46) + 1);
        }
        if (((String)object4).endsWith("Impl")) {
            object4 = ((String)object4).substring(0, ((String)object4).length() - 4);
        }
        this.setTitle(string + " " + (String)object4);
        this.setResizable(true);
        object3 = new JPanel(new FlowLayout(1));
        gridBagLayout.setConstraints((Component)object3, gridBagConstraints);
        this._jb_save = new JButton("Save");
        this._jb_save.addActionListener(this);
        gridBagLayout.setConstraints(this._jb_save, gridBagConstraints);
        this._jb_cancel = new JButton("Cancel");
        this._jb_cancel.addActionListener(this);
        gridBagLayout.setConstraints(this._jb_cancel, gridBagConstraints);
        ((Container)object3).add(this._jb_save);
        ((Container)object3).add(this._jb_cancel);
        jPanel2.add((Component)object3);
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.pack();
        this.centre();
        this.setVisible(true);
    }

    private Vector getMembers(Object object) {
        Class<?> clazz = object.getClass();
        Vector<Method> vector = new Vector<Method>();
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            String string = methodArray[n].getName();
            if (string.startsWith("get") && !string.equals("getClass") && methodArray[n].getDeclaringClass().equals(clazz)) {
                vector.add(methodArray[n]);
            }
            ++n;
        }
        return vector;
    }

    private boolean returnsSimpleType(Method method) {
        String string = method.getReturnType().getName();
        if (string.startsWith("java.lang.")) {
            return true;
        }
        return string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("short") || string.equals("boolean") || string.equals("byte");
    }

    private boolean returnsListType(Method method) {
        Class<?> clazz = method.getReturnType();
        try {
            return Class.forName("java.util.List").isAssignableFrom(clazz);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private Object getCurrentValue(Method method) {
        try {
            Object object = method.invoke(this._to_edit, new Object[0]);
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._jb_save) {
            try {
                Class<?> clazz = this._to_edit.getClass();
                int n = 0;
                while (n < this._members.size()) {
                    Object object2;
                    Method method = (Method)this._members.get(n);
                    Class<?> clazz2 = method.getReturnType();
                    String string = "set" + method.getName().substring(3);
                    Method method2 = clazz.getMethod(string, clazz2);
                    if (this.returnsSimpleType(method)) {
                        String string2 = ((JTextField)this._jtf_editable.get(n)).getText();
                        object2 = this.convertToParamType(string2, clazz2);
                    } else {
                        object2 = this._values.get(n);
                    }
                    method2.invoke(this._to_edit, object2);
                    ++n;
                }
                this.dispose();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else if (object == this._jb_cancel) {
            this.dispose();
        }
    }

    private Object convertToParamType(String string, Class clazz) {
        Object object = null;
        String string2 = clazz.getName();
        if (string2.equals("java.lang.String")) {
            object = string;
        } else if (string2.equals("int") || string2.equals("java.lang.Integer")) {
            object = Integer.valueOf(string);
        } else if (string2.equals("long") || string2.equals("java.lang.Long")) {
            object = Long.valueOf(string);
        } else if (string2.equals("float") || string2.equals("java.lang.Float")) {
            object = Float.valueOf(string);
        } else if (string2.equals("double") || string2.equals("java.lang.Double")) {
            object = Double.valueOf(string);
        } else if (string2.equals("short") || string2.equals("java.lang.Short")) {
            object = Short.valueOf(string);
        } else if (string2.equals("boolean") || string2.equals("java.lang.Boolean")) {
            object = Boolean.valueOf(string);
        }
        return object;
    }

    private void centre() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }
}

