/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.configurator;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.profile.Profile;
import fipaos.parser.ParserException;
import fipaos.tool.configurator.FIPAOSConfiguratorGUI;
import fipaos.tool.configurator.ScriptEditor;
import fipaos.util.XMLDataBinding;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FIPAOSConfigurator {
    private static final String MARKER = "FIPA_OS_Installation_Marker.txt";
    private static final String PROFILES = "profiles";
    private static final String PLATFORM_PROFILE = "platform.profile";
    private static final String ACC_PROFILE = "acc.profile";
    private static final String DEFAULT_PROFILE = "default.profile";
    private static final String LOADER_PROFILE = "loader.profile";
    private String _platform_profile_location;
    private String _acc_profile_location;
    private String _default_profile_location;
    private String _loader_profile_location;
    private String _true_fipaos_location;
    private static final String _separator = System.getProperty("file.separator");

    public FIPAOSConfigurator(String string) {
        ScriptEditor scriptEditor;
        boolean bl;
        this._true_fipaos_location = this.locateFIPAOS(string);
        if (this._true_fipaos_location == null) {
            System.exit(-1);
        }
        String string2 = this._true_fipaos_location + _separator + PROFILES + _separator;
        boolean bl2 = false;
        this._platform_profile_location = string2 + PLATFORM_PROFILE;
        PlatformProfile platformProfile = (PlatformProfile)this.fetchProfile(this._platform_profile_location, PLATFORM_PROFILE);
        if (platformProfile.getProfileDirectory() == null || platformProfile.getProfileDirectory().equals("")) {
            platformProfile.setProfileDirectory(string2);
            bl2 = true;
        } else {
            string2 = platformProfile.getProfileDirectory();
        }
        this._acc_profile_location = string2 + ACC_PROFILE;
        this._default_profile_location = string2 + DEFAULT_PROFILE;
        this._loader_profile_location = string2 + LOADER_PROFILE;
        ACCProfile aCCProfile = (ACCProfile)this.fetchProfile(this._acc_profile_location, ACC_PROFILE);
        AgentProfile agentProfile = (AgentProfile)this.fetchProfile(this._default_profile_location, DEFAULT_PROFILE);
        LoaderProfile loaderProfile = (LoaderProfile)this.fetchProfile(this._loader_profile_location, LOADER_PROFILE);
        if (bl2) {
            if (aCCProfile != null) {
                aCCProfile.setLocalAddressesLocation(this._true_fipaos_location + _separator + "platform.addresses");
                aCCProfile.getDatabaseProfile().setDatabaseLocation(this._true_fipaos_location + _separator + "databases" + _separator);
            }
            if (agentProfile != null) {
                agentProfile.getDatabaseProfile().setDatabaseLocation(this._true_fipaos_location + _separator + "databases" + _separator);
            }
        }
        if (bl = (scriptEditor = new ScriptEditor()).populate(this._true_fipaos_location)) {
            FIPAOSConfiguratorGUI fIPAOSConfiguratorGUI = new FIPAOSConfiguratorGUI(this, platformProfile, aCCProfile, agentProfile, loaderProfile, scriptEditor);
        } else {
            System.exit(-1);
        }
    }

    public void saveProfile(Profile profile) throws ParserException, IOException {
        if (profile instanceof PlatformProfile) {
            XMLDataBinding.marshallFile((Object)profile, this._platform_profile_location);
        } else if (profile instanceof ACCProfile) {
            XMLDataBinding.marshallFile((Object)profile, this._acc_profile_location);
        } else if (profile instanceof AgentProfile) {
            XMLDataBinding.marshallFile((Object)profile, this._default_profile_location);
        } else if (profile instanceof LoaderProfile) {
            XMLDataBinding.marshallFile((Object)profile, this._loader_profile_location);
        }
    }

    private Profile fetchProfile(String string, String string2) {
        int n;
        Object[] objectArray;
        Profile profile = null;
        if (string == null) {
            objectArray = new JFileChooser(this._true_fipaos_location);
            objectArray.setDialogTitle("Select location of " + string2);
            n = objectArray.showDialog(null, "Select");
            if (n == 0) {
                string = objectArray.getSelectedFile().getAbsolutePath();
            }
        }
        try {
            profile = (Profile)XMLDataBinding.unmarshallFile(string);
        }
        catch (Throwable throwable) {
            profile = null;
        }
        if (profile == null) {
            objectArray = new Object[]{"Search", "Create New"};
            n = JOptionPane.showOptionDialog(null, "Could not locate " + string2, "Warning", -1, 2, null, objectArray, objectArray[0]);
            if (n == 0) {
                return this.fetchProfile(null, string2);
            }
            return null;
        }
        return profile;
    }

    private String locateFIPAOS(String string) {
        boolean bl;
        File file = null;
        if (string == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Select FIPA-OS installation directory");
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setFileFilter(new DirFilter());
            int n = jFileChooser.showDialog(null, "Select");
            if (n == 0) {
                file = jFileChooser.getSelectedFile();
            }
        } else {
            file = new File(string);
        }
        if (bl = this.verifyLocation(file)) {
            try {
                return file.getCanonicalPath();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    private boolean verifyLocation(File file) {
        if (file == null) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(MARKER)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            FIPAOSConfigurator fIPAOSConfigurator = new FIPAOSConfigurator(stringArray[0]);
        } else {
            FIPAOSConfigurator fIPAOSConfigurator = new FIPAOSConfigurator(null);
        }
    }

    private class DirFilter
    extends FileFilter {
        private DirFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }

        public String getDescription() {
            return "Directories";
        }
    }
}

