/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.configurator;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.ACCProfileImpl;
import fipaos.agent.profile.AgentDescription;
import fipaos.agent.profile.AgentDescriptionImpl;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.AgentProfileImpl;
import fipaos.agent.profile.DatabaseProfile;
import fipaos.agent.profile.DatabaseProfileImpl;
import fipaos.agent.profile.ExternalAddress;
import fipaos.agent.profile.ExternalAddressImpl;
import fipaos.agent.profile.InternalAddress;
import fipaos.agent.profile.InternalAddressImpl;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.LoaderProfileImpl;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.profile.PlatformProfileImpl;
import fipaos.agent.profile.ProtocolMapping;
import fipaos.agent.profile.ProtocolMappingImpl;
import fipaos.agent.profile.ProtocolProfile;
import fipaos.agent.profile.ProtocolProfileImpl;
import fipaos.agent.profile.RemoteAgentPlatformProfile;
import fipaos.agent.profile.RemoteAgentPlatformProfileImpl;
import fipaos.agent.profile.TaskManagerProfile;
import fipaos.agent.profile.TaskManagerProfileImpl;
import fipaos.tool.configurator.DataBindingEditor;
import fipaos.tool.configurator.FIPAOSConfigurator;
import fipaos.tool.configurator.ScriptEditor;
import fipaos.tool.configurator.TwoWayMapping;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class FIPAOSConfiguratorGUI
extends JFrame
implements ActionListener,
WindowListener {
    private PlatformProfile _platform_profile;
    private ACCProfile _acc_profile;
    private AgentProfile _default_profile;
    private LoaderProfile _loader_profile;
    private ScriptEditor _script_editor;
    private TaskManagerProfile _tm_profile;
    private static final String title = "FIPA-OS Configuration Tool";
    private static String ACC_PROFILE = "ACC Profile";
    private static String PLATFORM_PROFILE = "Platform Profile";
    private static String LOADER_PROFILE = "Loader Profile";
    private static String SETUP_PROFILE = "SetupFIPAOS Script";
    private static String DEFAULT_PROFILE = "Default Agent Profile";
    private static String ADDING = "Adding";
    private static String EDITING = "Editing";
    private static final int ADD_REMOTE_PROFILE = 0;
    private static final int EDIT_REMOTE_PROFILE = 1;
    private static final int ADD_INTERNAL_TRANSPORT = 2;
    private static final int EDIT_INTERNAL_TRANSPORT = 3;
    private static final int ADD_EXTERNAL_TRANSPORT = 4;
    private static final int EDIT_EXTERNAL_TRANSPORT = 5;
    private static final int ACC_PANE = 0;
    private static final int DEFAULT_PANE = 1;
    private int _pane;
    private static final String REMOTE_PROFILE_NAME = "Remote Profile Name";
    private static final String HOME_AGENT_PLATFORM = "Platform Name";
    private static final String ADDRESSES = "Location of published addresses";
    private static final String INTERNAL_ADDRESSES = "Platform Transport Naming Services";
    private static final String EXTERNAL_ADDRESSES = "External Transport Naming Services";
    private static final String INTERNAL_ADDRESS = "Naming Service URL";
    private static final String EXTERNAL_ADDRESS = "Naming Service URL";
    private static final String DATABASE_LOCATION = "Database Location";
    private static final String DATABASE_TYPE = "Database Type";
    private static final String EDIT_REMOTE_PLATFORMS = "Edit Remote Platforms";
    private static final String LOCAL_ADDRESS_LOCATION = "Publish Transport Addresses To";
    private static final String PROTOCOL_MAPPINGS = "Protocol Mappings";
    private static final String ADD = "Add";
    private static final String EDIT = "Edit";
    private static final String DELETE = "Delete";
    private static final String SERIALIZATION_DATABASE = "SerializationDatabase";
    private static final String MEMORY_DATABASE = "MemoryDatabase";
    private static final String NO_DATABASE = "NoDatabase";
    private static String FIPA_OS_LOCATION = "FIPA-OS Installation";
    private static String FIPA_OS_VERSION = "FIPA-OS Version";
    private static String PLATFORM_PROFILE_LOCATION = "Location of platform.profile";
    private static String VM_LOCATION = "Location of Java VM";
    private static String VM_JIT_SETTING = "VM JIT/HotSpot Setting";
    private static String SHOW_DEBUG_OUTPUT = "Show output for debugging";
    private static String USE_LOADER_GUI = "Use AgentLoader GUI";
    private static String DEBUG_LEVEL_MEM = "Memory debug level";
    private static String DEBUG_LEVEL_FILE = "File debug level";
    private static String AMS_URL = "AMS URL";
    private static String HAP_NAME = "Home Agent Platform Name";
    private static String PROFILE_DIR = "Profile Directory";
    private static String AGENT_LOADER_MAPPINGS = "Agent Loader Mappings";
    private static String MANAGE_THREAD_POOLING = "Thread Pool Management";
    private static String MANAGE = "Manage";
    private static JPanel _spacer;
    private JPanel _jp_acc;
    private JTextArea _jta_external_addresses;
    private JTextField _jtf_local_address_location;
    private JButton _jb_add_remote_platform;
    private JButton _jb_edit_remote_platform;
    private JButton _jb_del_remote_platform;
    private Vector _remote_platform_profiles;
    private JList _jli_remote_profiles;
    private JButton _jb_acc_add_internal_transport;
    private JButton _jb_acc_edit_internal_transport;
    private JButton _jb_acc_del_internal_transport;
    private Vector _acc_internal_transport_addresses;
    private JList _jli_acc_internal_transports;
    private JButton _jb_acc_add_external_transport;
    private JButton _jb_acc_edit_external_transport;
    private JButton _jb_acc_del_external_transport;
    private Vector _acc_external_transport_addresses;
    private JList _jli_acc_external_transports;
    private JComboBox _jcb_acc_database_type;
    private JTextField _jtf_acc_database_location;
    private JPanel _jp_platform;
    private JTextField _jtf_hap_name;
    private JTextField _jtf_ams_url;
    private JTextField _jtf_profile_directory;
    private JPanel _jp_setup;
    private JPanel _jp_buttons;
    private JButton _jb_save;
    private JButton _jb_exit;
    private static final String JIT_KEY1 = "Normal VM Operation";
    private static final String JIT_KEY2 = "JIT Disabled";
    private static final String JIT_KEY3 = "HotSpot Disabled";
    private static final String JIT_VAL1 = "";
    private static final String JIT_VAL2 = "-Djava.compiler=NONE";
    private static final String JIT_VAL3 = "-classic -Djava.compiler=NONE";
    private static final String DEBUG_KEY1 = "Yes";
    private static final String DEBUG_KEY2 = "No";
    private static final String DEBUG_VAL1 = "_debug";
    private static final String DEBUG_VAL2 = "";
    private static final String LOADER_GUI_KEY1 = "Yes";
    private static final String LOADER_GUI_KEY2 = "No";
    private static final String LOADER_GUI_VAL1 = "";
    private static final String LOADER_GUI_VAL2 = "-nogui";
    private static String DBG_LVL_KEY1;
    private static String DBG_LVL_KEY2;
    private static String DBG_LVL_KEY3;
    private static String DBG_LVL_KEY4;
    private static String DBG_LVL_KEY5;
    private static String DBG_LVL_VAL1;
    private static String DBG_LVL_VAL2;
    private static String DBG_LVL_VAL3;
    private static String DBG_LVL_VAL4;
    private static String DBG_LVL_VAL5;
    private JTextField _jtf_fipa_os_location;
    private JTextField _jtf_fipa_os_ver;
    private JTextField _jtf_jdk_location;
    private JTextField _jtf_platform_profile_location;
    private JComboBox _jcb_dbg_lvl_mem;
    private JComboBox _jcb_dbg_lvl_file;
    private TwoWayMapping _dbg_lvl_mappings;
    private JComboBox _jcb_jit_option;
    private TwoWayMapping _jit_mappings;
    private JComboBox _jcb_debug_option;
    private TwoWayMapping _debug_on_mappings;
    private JComboBox _jcb_loader_gui_option;
    private TwoWayMapping _loader_gui_mappings;
    private JPanel _jp_default;
    private JButton _jb_default_add_internal_transport;
    private JButton _jb_default_edit_internal_transport;
    private JButton _jb_default_del_internal_transport;
    private Vector _default_internal_transport_addresses;
    private JList _jli_default_internal_transports;
    private JButton _jb_default_add_protocol_mapping;
    private JButton _jb_default_edit_protocol_mapping;
    private JButton _jb_default_del_protocol_mapping;
    private JButton _jb_default_manage_thread_pooling;
    private Vector _default_protocol_mappings;
    private JList _jli_default_protocol_mappings;
    private JComboBox _jcb_default_database_type;
    private JTextField _jtf_default_database_location;
    private FIPAOSConfigurator _owner;
    private JPanel _jp_loader;
    private JButton _jb_loader_add_agent_mapping;
    private JButton _jb_loader_edit_agent_mapping;
    private JButton _jb_loader_del_agent_mapping;
    private Vector _loader_agent_mappings;
    private JList _jli_loader_agent_mappings;

    public FIPAOSConfiguratorGUI(FIPAOSConfigurator fIPAOSConfigurator, PlatformProfile platformProfile, ACCProfile aCCProfile, AgentProfile agentProfile, LoaderProfile loaderProfile, ScriptEditor scriptEditor) {
        this._owner = fIPAOSConfigurator;
        this._platform_profile = platformProfile;
        if (this._platform_profile == null) {
            this._platform_profile = new PlatformProfileImpl();
        }
        this._acc_profile = aCCProfile;
        if (this._acc_profile == null) {
            this._acc_profile = new ACCProfileImpl();
        }
        this._default_profile = agentProfile;
        if (this._default_profile == null) {
            this._default_profile = new AgentProfileImpl();
            this._tm_profile = new TaskManagerProfileImpl();
        }
        this._loader_profile = loaderProfile;
        if (this._loader_profile == null) {
            this._loader_profile = new LoaderProfileImpl();
        }
        this._script_editor = scriptEditor;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/logo.gif")).getImage());
        this.setTitle(title);
        this.setResizable(true);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.ipadx = 25;
        JPanel jPanel = new JPanel(gridBagLayout);
        JTabbedPane jTabbedPane = new JTabbedPane();
        gridBagLayout.setConstraints(jTabbedPane, gridBagConstraints);
        this._jit_mappings = new TwoWayMapping();
        this._jit_mappings.put(JIT_KEY1, "");
        this._jit_mappings.put(JIT_KEY2, JIT_VAL2);
        this._jit_mappings.put(JIT_KEY3, JIT_VAL3);
        this._debug_on_mappings = new TwoWayMapping();
        this._debug_on_mappings.put("Yes", DEBUG_VAL1);
        this._debug_on_mappings.put("No", "");
        this._loader_gui_mappings = new TwoWayMapping();
        this._loader_gui_mappings.put("Yes", "");
        this._loader_gui_mappings.put("No", LOADER_GUI_VAL2);
        this._dbg_lvl_mappings = new TwoWayMapping();
        this._dbg_lvl_mappings.put(DBG_LVL_KEY1, DBG_LVL_VAL1);
        this._dbg_lvl_mappings.put(DBG_LVL_KEY2, DBG_LVL_VAL2);
        this._dbg_lvl_mappings.put(DBG_LVL_KEY3, DBG_LVL_VAL3);
        this._dbg_lvl_mappings.put(DBG_LVL_KEY4, DBG_LVL_VAL4);
        this._dbg_lvl_mappings.put(DBG_LVL_KEY5, DBG_LVL_VAL5);
        this._jli_remote_profiles = new JList();
        this._remote_platform_profiles = new Vector();
        this._jb_add_remote_platform = new JButton(ADD);
        this._jb_edit_remote_platform = new JButton(EDIT);
        this._jb_del_remote_platform = new JButton(DELETE);
        this._jli_acc_internal_transports = new JList();
        this._acc_internal_transport_addresses = new Vector();
        this._jb_acc_add_internal_transport = new JButton(ADD);
        this._jb_acc_edit_internal_transport = new JButton(EDIT);
        this._jb_acc_del_internal_transport = new JButton(DELETE);
        this._jli_default_internal_transports = new JList();
        this._default_internal_transport_addresses = new Vector();
        this._jb_default_add_internal_transport = new JButton(ADD);
        this._jb_default_edit_internal_transport = new JButton(EDIT);
        this._jb_default_del_internal_transport = new JButton(DELETE);
        this._jli_default_protocol_mappings = new JList();
        this._default_protocol_mappings = new Vector();
        this._jb_default_add_protocol_mapping = new JButton(ADD);
        this._jb_default_edit_protocol_mapping = new JButton(EDIT);
        this._jb_default_del_protocol_mapping = new JButton(DELETE);
        this._jli_acc_external_transports = new JList();
        this._acc_external_transport_addresses = new Vector();
        this._jb_acc_add_external_transport = new JButton(ADD);
        this._jb_acc_edit_external_transport = new JButton(EDIT);
        this._jb_acc_del_external_transport = new JButton(DELETE);
        this._jli_loader_agent_mappings = new JList();
        this._loader_agent_mappings = new Vector();
        this._jb_loader_add_agent_mapping = new JButton(ADD);
        this._jb_loader_edit_agent_mapping = new JButton(EDIT);
        this._jb_loader_del_agent_mapping = new JButton(DELETE);
        this.makeACCPane();
        this.makePlatformPane();
        this.makeSetupPane();
        this.makeDefaultPane();
        this.makeLoaderPane();
        this.makeButtonsPane();
        gridBagLayout.setConstraints(this._jp_buttons, gridBagConstraints);
        jTabbedPane.add((Component)this._jp_acc, ACC_PROFILE);
        jTabbedPane.add((Component)this._jp_platform, PLATFORM_PROFILE);
        jTabbedPane.add((Component)this._jp_setup, SETUP_PROFILE);
        jTabbedPane.add((Component)this._jp_default, DEFAULT_PROFILE);
        jTabbedPane.add((Component)this._jp_loader, LOADER_PROFILE);
        jPanel.add(jTabbedPane);
        jPanel.add(this._jp_buttons);
        this.getContentPane().add(jPanel);
        this.readDataIntoGUI();
        this.updateLists();
        this.centre();
        this.setVisible(true);
    }

    private void makeACCPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 25;
        this._jp_acc = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel(INTERNAL_ADDRESSES);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this._jp_acc.add(jLabel);
        JPanel jPanel = this.makeListEditPanel(this._jli_acc_internal_transports, this._jb_acc_add_internal_transport, this._jb_acc_edit_internal_transport, this._jb_acc_del_internal_transport);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this._jp_acc.add(jPanel);
        JLabel jLabel2 = new JLabel(EXTERNAL_ADDRESSES);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this._jp_acc.add(jLabel2);
        JPanel jPanel2 = this.makeListEditPanel(this._jli_acc_external_transports, this._jb_acc_add_external_transport, this._jb_acc_edit_external_transport, this._jb_acc_del_external_transport);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this._jp_acc.add(jPanel2);
        JLabel jLabel3 = new JLabel(LOCAL_ADDRESS_LOCATION);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this._jp_acc.add(jLabel3);
        this._jtf_local_address_location = new JTextField(32);
        gridBagLayout.setConstraints(this._jtf_local_address_location, gridBagConstraints);
        this._jp_acc.add(this._jtf_local_address_location);
        JLabel jLabel4 = new JLabel(EDIT_REMOTE_PLATFORMS);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        this._jp_acc.add(jLabel4);
        JPanel jPanel3 = this.makeListEditPanel(this._jli_remote_profiles, this._jb_add_remote_platform, this._jb_edit_remote_platform, this._jb_del_remote_platform);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this._jp_acc.add(jPanel3);
        JLabel jLabel5 = new JLabel(DATABASE_TYPE);
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        this._jp_acc.add(jLabel5);
        this._jcb_acc_database_type = new JComboBox();
        this._jcb_acc_database_type.addItem(SERIALIZATION_DATABASE);
        this._jcb_acc_database_type.addItem(MEMORY_DATABASE);
        gridBagLayout.setConstraints(this._jcb_acc_database_type, gridBagConstraints);
        this._jp_acc.add(this._jcb_acc_database_type);
        JLabel jLabel6 = new JLabel(DATABASE_LOCATION);
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        this._jtf_acc_database_location = new JTextField(32);
        gridBagLayout.setConstraints(this._jtf_acc_database_location, gridBagConstraints);
        this._jp_acc.add(jLabel6);
        this._jp_acc.add(this._jtf_acc_database_location);
    }

    private JPanel makeListEditPanel(JList jList, JButton jButton, JButton jButton2, JButton jButton3) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 25;
        JPanel jPanel = new JPanel(gridBagLayout);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jList.setSelectionMode(0);
        jList.setFixedCellWidth(300);
        jList.setVisibleRowCount(3);
        gridBagConstraints.gridheight = 3;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        jButton.addActionListener(this);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jButton2.addActionListener(this);
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jButton3.addActionListener(this);
        gridBagLayout.setConstraints(jButton3, gridBagConstraints);
        jPanel.add(jScrollPane);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    private void makePlatformPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.weightx = 1.0;
        this._jp_platform = new JPanel(new FlowLayout());
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel(HAP_NAME);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this._jtf_hap_name = new JTextField(32);
        gridBagLayout.setConstraints(this._jtf_hap_name, gridBagConstraints);
        jPanel.add(this._jtf_hap_name);
        JLabel jLabel2 = new JLabel(AMS_URL);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this._jtf_ams_url = new JTextField(32);
        gridBagLayout.setConstraints(this._jtf_ams_url, gridBagConstraints);
        jPanel.add(this._jtf_ams_url);
        JLabel jLabel3 = new JLabel(PROFILE_DIR);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        this._jtf_profile_directory = new JTextField(32);
        gridBagLayout.setConstraints(this._jtf_profile_directory, gridBagConstraints);
        jPanel.add(this._jtf_profile_directory);
        this._jp_platform.add(jPanel);
    }

    private void makeSetupPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.weightx = 1.0;
        this._jp_setup = new JPanel(new FlowLayout());
        JPanel jPanel = new JPanel(gridBagLayout);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel = new JLabel(FIPA_OS_LOCATION);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        this._jtf_fipa_os_location = new JTextField();
        gridBagLayout.setConstraints(this._jtf_fipa_os_location, gridBagConstraints);
        jPanel.add(this._jtf_fipa_os_location);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel2 = new JLabel(FIPA_OS_VERSION);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        this._jtf_fipa_os_ver = new JTextField();
        gridBagLayout.setConstraints(this._jtf_fipa_os_ver, gridBagConstraints);
        jPanel.add(this._jtf_fipa_os_ver);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel3 = new JLabel(PLATFORM_PROFILE_LOCATION);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        this._jtf_platform_profile_location = new JTextField();
        gridBagLayout.setConstraints(this._jtf_platform_profile_location, gridBagConstraints);
        jPanel.add(this._jtf_platform_profile_location);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel4 = new JLabel(VM_LOCATION);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        this._jtf_jdk_location = new JTextField();
        gridBagLayout.setConstraints(this._jtf_jdk_location, gridBagConstraints);
        jPanel.add(this._jtf_jdk_location);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel5 = new JLabel(VM_JIT_SETTING);
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel.add(jLabel5);
        gridBagConstraints.gridwidth = 0;
        this._jcb_jit_option = new JComboBox();
        this._jcb_jit_option.addItem(JIT_KEY1);
        this._jcb_jit_option.addItem(JIT_KEY2);
        this._jcb_jit_option.addItem(JIT_KEY3);
        gridBagLayout.setConstraints(this._jcb_jit_option, gridBagConstraints);
        jPanel.add(this._jcb_jit_option);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel6 = new JLabel(SHOW_DEBUG_OUTPUT);
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        jPanel.add(jLabel6);
        gridBagConstraints.gridwidth = 0;
        this._jcb_debug_option = new JComboBox();
        this._jcb_debug_option.addItem("Yes");
        this._jcb_debug_option.addItem("No");
        gridBagLayout.setConstraints(this._jcb_debug_option, gridBagConstraints);
        jPanel.add(this._jcb_debug_option);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel7 = new JLabel(USE_LOADER_GUI);
        gridBagLayout.setConstraints(jLabel7, gridBagConstraints);
        jPanel.add(jLabel7);
        gridBagConstraints.gridwidth = 0;
        this._jcb_loader_gui_option = new JComboBox();
        this._jcb_loader_gui_option.addItem("Yes");
        this._jcb_loader_gui_option.addItem("No");
        gridBagLayout.setConstraints(this._jcb_loader_gui_option, gridBagConstraints);
        jPanel.add(this._jcb_loader_gui_option);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel8 = new JLabel(DEBUG_LEVEL_MEM);
        gridBagLayout.setConstraints(jLabel8, gridBagConstraints);
        jPanel.add(jLabel8);
        gridBagConstraints.gridwidth = 0;
        this._jcb_dbg_lvl_mem = new JComboBox();
        this._jcb_dbg_lvl_mem.addItem(DBG_LVL_KEY1);
        this._jcb_dbg_lvl_mem.addItem(DBG_LVL_KEY2);
        this._jcb_dbg_lvl_mem.addItem(DBG_LVL_KEY3);
        this._jcb_dbg_lvl_mem.addItem(DBG_LVL_KEY4);
        this._jcb_dbg_lvl_mem.addItem(DBG_LVL_KEY5);
        gridBagLayout.setConstraints(this._jcb_dbg_lvl_mem, gridBagConstraints);
        jPanel.add(this._jcb_dbg_lvl_mem);
        gridBagConstraints.gridwidth = -1;
        JLabel jLabel9 = new JLabel(DEBUG_LEVEL_FILE);
        gridBagLayout.setConstraints(jLabel9, gridBagConstraints);
        jPanel.add(jLabel9);
        gridBagConstraints.gridwidth = 0;
        this._jcb_dbg_lvl_file = new JComboBox();
        this._jcb_dbg_lvl_file.addItem(DBG_LVL_KEY1);
        this._jcb_dbg_lvl_file.addItem(DBG_LVL_KEY2);
        this._jcb_dbg_lvl_file.addItem(DBG_LVL_KEY3);
        this._jcb_dbg_lvl_file.addItem(DBG_LVL_KEY4);
        this._jcb_dbg_lvl_file.addItem(DBG_LVL_KEY5);
        gridBagLayout.setConstraints(this._jcb_dbg_lvl_file, gridBagConstraints);
        jPanel.add(this._jcb_dbg_lvl_file);
        this._jp_setup.add(jPanel);
    }

    private void makeDefaultPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 25;
        this._jp_default = new JPanel(new FlowLayout());
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel(INTERNAL_ADDRESSES);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JPanel jPanel2 = this.makeListEditPanel(this._jli_default_internal_transports, this._jb_default_add_internal_transport, this._jb_default_edit_internal_transport, this._jb_default_del_internal_transport);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JLabel jLabel2 = new JLabel(PROTOCOL_MAPPINGS);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        JPanel jPanel3 = this.makeListEditPanel(this._jli_default_protocol_mappings, this._jb_default_add_protocol_mapping, this._jb_default_edit_protocol_mapping, this._jb_default_del_protocol_mapping);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        JLabel jLabel3 = new JLabel(DATABASE_TYPE);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        this._jcb_default_database_type = new JComboBox();
        this._jcb_default_database_type.addItem(SERIALIZATION_DATABASE);
        this._jcb_default_database_type.addItem(MEMORY_DATABASE);
        this._jcb_default_database_type.addItem(NO_DATABASE);
        gridBagLayout.setConstraints(this._jcb_default_database_type, gridBagConstraints);
        jPanel.add(this._jcb_default_database_type);
        JLabel jLabel4 = new JLabel(DATABASE_LOCATION);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        this._jtf_default_database_location = new JTextField(32);
        gridBagLayout.setConstraints(this._jtf_default_database_location, gridBagConstraints);
        jPanel.add(jLabel4);
        jPanel.add(this._jtf_default_database_location);
        JLabel jLabel5 = new JLabel(MANAGE_THREAD_POOLING);
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        this._jb_default_manage_thread_pooling = new JButton(MANAGE);
        this._jb_default_manage_thread_pooling.addActionListener(this);
        gridBagLayout.setConstraints(this._jb_default_manage_thread_pooling, gridBagConstraints);
        jPanel.add(jLabel5);
        jPanel.add(this._jb_default_manage_thread_pooling);
        this._jp_default.add(jPanel);
    }

    private void makeLoaderPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 25;
        this._jp_loader = new JPanel(new FlowLayout());
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel(AGENT_LOADER_MAPPINGS);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JPanel jPanel2 = this.makeListEditPanel(this._jli_loader_agent_mappings, this._jb_loader_add_agent_mapping, this._jb_loader_edit_agent_mapping, this._jb_loader_del_agent_mapping);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this._jp_loader.add(jPanel);
    }

    private void makeButtonsPane() {
        this._jp_buttons = new JPanel(new FlowLayout(1));
        this._jb_save = new JButton("Save");
        this._jb_save.addActionListener(this);
        this._jb_exit = new JButton("Exit");
        this._jb_exit.addActionListener(this);
        this._jp_buttons.add(this._jb_save);
        this._jp_buttons.add(this._jb_exit);
    }

    private void readDataIntoGUI() {
        this.readACCData();
        this.readPlatformData();
        this.readScriptData();
        this.readDefaultData();
        this.readLoaderData();
    }

    private void readACCData() {
        String string;
        this._acc_external_transport_addresses = (Vector)this._acc_profile.getExternalAddresss();
        if (this._acc_external_transport_addresses == null) {
            this._acc_external_transport_addresses = new Vector();
        }
        this._acc_internal_transport_addresses = (Vector)this._acc_profile.getInternalAddresss();
        if (this._acc_internal_transport_addresses == null) {
            this._acc_internal_transport_addresses = new Vector();
        }
        this._jtf_local_address_location.setText(this._acc_profile.getLocalAddressesLocation());
        DatabaseProfile databaseProfile = this._acc_profile.getDatabaseProfile();
        if (databaseProfile == null) {
            databaseProfile = new DatabaseProfileImpl();
        }
        if ((string = databaseProfile.getDatabaseType()) != null) {
            if (string.equals(SERIALIZATION_DATABASE)) {
                this._jcb_acc_database_type.setSelectedItem(SERIALIZATION_DATABASE);
            } else {
                this._jcb_acc_database_type.setSelectedItem(MEMORY_DATABASE);
            }
            this._jtf_acc_database_location.setText(databaseProfile.getDatabaseLocation());
        } else {
            this._jcb_acc_database_type.setSelectedItem(MEMORY_DATABASE);
        }
        this._remote_platform_profiles = (Vector)this._acc_profile.getRemoteAgentPlatformProfiles();
        if (this._remote_platform_profiles == null) {
            this._remote_platform_profiles = new Vector();
        }
    }

    private void readPlatformData() {
        this._jtf_hap_name.setText(this._platform_profile.getHAPName());
        this._jtf_ams_url.setText(this._platform_profile.getAMSAddress());
        this._jtf_profile_directory.setText(this._platform_profile.getProfileDirectory());
    }

    private void readScriptData() {
        String string;
        Map map = this._script_editor.getScriptVariables();
        this._jtf_fipa_os_location.setText((String)map.get("FIPAOS"));
        this._jtf_fipa_os_ver.setText((String)map.get("FIPAOS_VER"));
        this._jtf_jdk_location.setText((String)map.get("JDK"));
        this._jtf_platform_profile_location.setText((String)map.get("PLATFORM"));
        String string2 = (String)map.get("DEBUGVER");
        if (string2 != null && string2.equals(DEBUG_VAL1)) {
            this._jcb_debug_option.setSelectedItem("Yes");
        } else {
            this._jcb_debug_option.setSelectedItem("No");
        }
        String string3 = (String)map.get("LOADER_GUI");
        if (string3 != null && string3.equals("")) {
            this._jcb_loader_gui_option.setSelectedItem("Yes");
        } else {
            this._jcb_loader_gui_option.setSelectedItem("No");
        }
        String string4 = (String)map.get("NOJIT");
        if (string4 == null) {
            this._jcb_jit_option.setSelectedItem(JIT_KEY1);
        } else {
            string = (String)this._jit_mappings.get(string4);
            if (string == null) {
                this._jcb_jit_option.setSelectedItem(JIT_KEY1);
            } else {
                this._jcb_jit_option.setSelectedItem(string);
            }
        }
        string4 = (String)map.get("DBG_LVL_MEM");
        if (string4 == null) {
            this._jcb_dbg_lvl_mem.setSelectedItem(DBG_LVL_KEY3);
        } else {
            string = (String)this._dbg_lvl_mappings.get(string4);
            if (string == null) {
                this._jcb_dbg_lvl_mem.setSelectedItem(DBG_LVL_KEY3);
            } else {
                this._jcb_dbg_lvl_mem.setSelectedItem(string);
            }
        }
        string4 = (String)map.get("DBG_LVL_FILE");
        if (string4 == null) {
            this._jcb_dbg_lvl_file.setSelectedItem(DBG_LVL_KEY3);
        } else {
            string = (String)this._dbg_lvl_mappings.get(string4);
            if (string == null) {
                this._jcb_dbg_lvl_file.setSelectedItem(DBG_LVL_KEY3);
            } else {
                this._jcb_dbg_lvl_file.setSelectedItem(string);
            }
        }
    }

    private void readDefaultData() {
        String string;
        DatabaseProfile databaseProfile;
        ProtocolProfile protocolProfile;
        this._default_internal_transport_addresses = (Vector)this._default_profile.getInternalAddresss();
        if (this._default_internal_transport_addresses == null) {
            this._default_internal_transport_addresses = new Vector();
        }
        if ((protocolProfile = this._default_profile.getProtocolProfile()) == null) {
            protocolProfile = new ProtocolProfileImpl();
        }
        this._default_protocol_mappings = (Vector)protocolProfile.getProtocolMappings();
        if (this._default_protocol_mappings == null) {
            this._default_protocol_mappings = new Vector();
        }
        if ((databaseProfile = this._default_profile.getDatabaseProfile()) == null) {
            databaseProfile = new DatabaseProfileImpl();
        }
        if ((string = databaseProfile.getDatabaseType()) != null) {
            if (string.equals(SERIALIZATION_DATABASE)) {
                this._jcb_default_database_type.setSelectedItem(SERIALIZATION_DATABASE);
            } else if (string.equals(MEMORY_DATABASE)) {
                this._jcb_default_database_type.setSelectedItem(MEMORY_DATABASE);
            } else {
                this._jcb_default_database_type.setSelectedItem(NO_DATABASE);
            }
            this._jtf_default_database_location.setText(databaseProfile.getDatabaseLocation());
        } else {
            this._jcb_default_database_type.setSelectedItem(NO_DATABASE);
        }
        this._tm_profile = this._default_profile.getTaskManagerProfile() != null ? this._default_profile.getTaskManagerProfile() : new TaskManagerProfileImpl();
    }

    private void readLoaderData() {
        this._loader_agent_mappings = (Vector)this._loader_profile.getAgentDescriptions();
        if (this._loader_agent_mappings == null) {
            this._loader_agent_mappings = new Vector();
        }
    }

    private void updateList(List list, JList jList) {
        if (list != null) {
            Iterator iterator = list.iterator();
            Vector<String> vector = new Vector<String>();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof InternalAddressImpl) {
                    vector.add(((InternalAddressImpl)e).getAddress());
                    continue;
                }
                if (e instanceof ExternalAddressImpl) {
                    vector.add(((ExternalAddressImpl)e).getAddress());
                    continue;
                }
                if (e instanceof RemoteAgentPlatformProfileImpl) {
                    vector.add(((RemoteAgentPlatformProfileImpl)e).getHAPName());
                    continue;
                }
                if (e instanceof ProtocolMappingImpl) {
                    vector.add(((ProtocolMappingImpl)e).getProtocolName());
                    continue;
                }
                if (!(e instanceof AgentDescription)) continue;
                vector.add(((AgentDescription)e).getAgentName());
            }
            jList.setListData(vector.toArray());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            this.handleButtonPressed(object);
        }
        this.updateLists();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.confirmExit();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void handleButtonPressed(Object object) {
        if (object == this._jb_save) {
            this.saveNewValues();
        } else if (object == this._jb_exit) {
            this.confirmExit();
        } else if (object == this._jb_add_remote_platform) {
            this.addRemotePlatformProfile();
        } else if (object == this._jb_edit_remote_platform) {
            this.editRemotePlatformProfile();
        } else if (object == this._jb_del_remote_platform) {
            this.delListItem(this._remote_platform_profiles, this._jli_remote_profiles);
        } else if (object == this._jb_acc_add_internal_transport) {
            this._pane = 0;
            this.addInternalTransport();
        } else if (object == this._jb_acc_edit_internal_transport) {
            this._pane = 0;
            this.editInternalTransport();
        } else if (object == this._jb_acc_del_internal_transport) {
            this.delListItem(this._acc_internal_transport_addresses, this._jli_acc_internal_transports);
        } else if (object == this._jb_default_add_internal_transport) {
            this._pane = 1;
            this.addInternalTransport();
        } else if (object == this._jb_default_edit_internal_transport) {
            this._pane = 1;
            this.editInternalTransport();
        } else if (object == this._jb_default_del_internal_transport) {
            this.delListItem(this._default_internal_transport_addresses, this._jli_default_internal_transports);
        } else if (object == this._jb_default_add_protocol_mapping) {
            this.addProtocolMapping();
        } else if (object == this._jb_default_edit_protocol_mapping) {
            this.editProtocolMapping();
        } else if (object == this._jb_default_del_protocol_mapping) {
            this.delListItem(this._default_protocol_mappings, this._jli_default_protocol_mappings);
        } else if (object == this._jb_acc_add_external_transport) {
            this.addExternalTransport();
        } else if (object == this._jb_acc_edit_external_transport) {
            this.editExternalTransport();
        } else if (object == this._jb_acc_del_external_transport) {
            this.delListItem(this._acc_external_transport_addresses, this._jli_acc_external_transports);
        } else if (object == this._jb_loader_add_agent_mapping) {
            this.addLoaderAgentDescription();
        } else if (object == this._jb_loader_edit_agent_mapping) {
            this.editLoaderAgentDescription();
        } else if (object == this._jb_loader_del_agent_mapping) {
            this.delListItem(this._loader_agent_mappings, this._jli_loader_agent_mappings);
        } else if (object == this._jb_default_manage_thread_pooling) {
            this.editThreadPooling();
        }
    }

    private void editThreadPooling() {
        DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, this._tm_profile, EDITING);
    }

    private void addRemotePlatformProfile() {
        RemoteAgentPlatformProfileImpl remoteAgentPlatformProfileImpl = new RemoteAgentPlatformProfileImpl();
        this._remote_platform_profiles.add(remoteAgentPlatformProfileImpl);
        DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, remoteAgentPlatformProfileImpl, ADDING);
        this.updateLists();
    }

    private void editRemotePlatformProfile() {
        RemoteAgentPlatformProfile remoteAgentPlatformProfile;
        int n = this._jli_remote_profiles.getSelectedIndex();
        if (n != -1 && (remoteAgentPlatformProfile = (RemoteAgentPlatformProfile)this._remote_platform_profiles.get(n)) != null) {
            DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, remoteAgentPlatformProfile, EDITING);
            this.updateLists();
        }
    }

    private void delListItem(List list, JList jList) {
        int n = jList.getSelectedIndex();
        if (n != -1) {
            list.remove(n);
            this.updateList(list, jList);
        }
    }

    private void addInternalTransport() {
        if (this._pane == 0) {
            InternalAddressImpl internalAddressImpl = new InternalAddressImpl();
            this._acc_internal_transport_addresses.add(internalAddressImpl);
            DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, internalAddressImpl, ADDING);
            this.updateLists();
        } else {
            InternalAddressImpl internalAddressImpl = new InternalAddressImpl();
            this._default_internal_transport_addresses.add(internalAddressImpl);
            DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, internalAddressImpl, ADDING);
            this.updateLists();
        }
    }

    private void editInternalTransport() {
        InternalAddressImpl internalAddressImpl;
        int n;
        if (this._pane == 0) {
            InternalAddressImpl internalAddressImpl2;
            int n2 = this._jli_acc_internal_transports.getSelectedIndex();
            if (n2 != -1 && (internalAddressImpl2 = (InternalAddressImpl)this._acc_internal_transport_addresses.get(n2)) != null) {
                DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, internalAddressImpl2, EDITING);
                this.updateLists();
            }
        } else if (this._pane == 1 && (n = this._jli_default_internal_transports.getSelectedIndex()) != -1 && (internalAddressImpl = (InternalAddressImpl)this._default_internal_transport_addresses.get(n)) != null) {
            DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, internalAddressImpl, EDITING);
            this.updateLists();
        }
    }

    private void addExternalTransport() {
        ExternalAddressImpl externalAddressImpl = new ExternalAddressImpl();
        this._acc_external_transport_addresses.add(externalAddressImpl);
        DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, externalAddressImpl, ADDING);
        this.updateLists();
    }

    private void editExternalTransport() {
        ExternalAddressImpl externalAddressImpl;
        int n = this._jli_acc_external_transports.getSelectedIndex();
        if (n != -1 && (externalAddressImpl = (ExternalAddressImpl)this._acc_external_transport_addresses.get(n)) != null) {
            DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, externalAddressImpl, ADDING);
            this.updateLists();
        }
    }

    private void addProtocolMapping() {
        ProtocolMappingImpl protocolMappingImpl = new ProtocolMappingImpl();
        this._default_protocol_mappings.add(protocolMappingImpl);
        DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, protocolMappingImpl, ADDING);
        this.updateLists();
    }

    private void editProtocolMapping() {
        ProtocolMapping protocolMapping;
        int n = this._jli_default_protocol_mappings.getSelectedIndex();
        if (n != -1 && (protocolMapping = (ProtocolMapping)this._default_protocol_mappings.get(n)) != null) {
            DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, protocolMapping, EDITING);
            this.updateLists();
        }
    }

    private void addLoaderAgentDescription() {
        AgentDescriptionImpl agentDescriptionImpl = new AgentDescriptionImpl();
        this._loader_agent_mappings.add(agentDescriptionImpl);
        DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, agentDescriptionImpl, ADDING);
        this.updateLists();
    }

    private void editLoaderAgentDescription() {
        AgentDescription agentDescription;
        int n = this._jli_loader_agent_mappings.getSelectedIndex();
        if (n != -1 && (agentDescription = (AgentDescription)this._loader_agent_mappings.get(n)) != null) {
            DataBindingEditor dataBindingEditor = new DataBindingEditor((Object)this, agentDescription, EDITING);
            this.updateLists();
        }
    }

    private void saveNewValues() {
        this.updatePlatformProfile();
        this.updateACCProfile();
        this.updateDefaultProfile();
        this.updateScriptEditor();
        this.updateLoaderProfile();
        try {
            this._owner.saveProfile(this._platform_profile);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this._owner.saveProfile(this._acc_profile);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this._owner.saveProfile(this._default_profile);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this._owner.saveProfile(this._loader_profile);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this._script_editor.saveNewConfiguration();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void updatePlatformProfile() {
        this._platform_profile = new PlatformProfileImpl();
        this._platform_profile.setAMSAddress(this._jtf_ams_url.getText());
        this._platform_profile.setHAPName(this._jtf_hap_name.getText());
        this._platform_profile.setProfileDirectory(this._jtf_profile_directory.getText());
    }

    private void updateACCProfile() {
        this._acc_profile = new ACCProfileImpl();
        this._acc_profile.setLocalAddressesLocation(this._jtf_local_address_location.getText());
        if (this._acc_internal_transport_addresses != null) {
            // empty if block
        }
        Iterator iterator = this._acc_internal_transport_addresses.iterator();
        while (iterator.hasNext()) {
            this._acc_profile.addInternalAddress((InternalAddress)iterator.next());
        }
        Iterator iterator2 = this._acc_external_transport_addresses.iterator();
        while (iterator2.hasNext()) {
            this._acc_profile.addExternalAddress((ExternalAddress)iterator2.next());
        }
        Iterator iterator3 = this._remote_platform_profiles.iterator();
        while (iterator3.hasNext()) {
            this._acc_profile.addRemoteAgentPlatformProfile((RemoteAgentPlatformProfile)iterator3.next());
        }
        DatabaseProfileImpl databaseProfileImpl = new DatabaseProfileImpl();
        databaseProfileImpl.setDatabaseType((String)this._jcb_acc_database_type.getSelectedItem());
        databaseProfileImpl.setDatabaseLocation(this._jtf_acc_database_location.getText());
        this._acc_profile.setDatabaseProfile(databaseProfileImpl);
    }

    private void updateDefaultProfile() {
        this._default_profile = new AgentProfileImpl();
        Iterator iterator = this._default_internal_transport_addresses.iterator();
        while (iterator.hasNext()) {
            this._default_profile.addInternalAddress((InternalAddress)iterator.next());
        }
        Iterator iterator2 = this._default_protocol_mappings.iterator();
        ProtocolProfileImpl protocolProfileImpl = new ProtocolProfileImpl();
        while (iterator2.hasNext()) {
            protocolProfileImpl.addProtocolMapping((ProtocolMapping)iterator2.next());
        }
        this._default_profile.setProtocolProfile(protocolProfileImpl);
        DatabaseProfileImpl databaseProfileImpl = new DatabaseProfileImpl();
        databaseProfileImpl.setDatabaseType((String)this._jcb_default_database_type.getSelectedItem());
        databaseProfileImpl.setDatabaseLocation(this._jtf_default_database_location.getText());
        this._default_profile.setDatabaseProfile(databaseProfileImpl);
        this._default_profile.setTaskManagerProfile(this._tm_profile);
    }

    private void updateLoaderProfile() {
        this._loader_profile = new LoaderProfileImpl();
        Iterator iterator = this._loader_agent_mappings.iterator();
        while (iterator.hasNext()) {
            this._loader_profile.addAgentDescription((AgentDescription)iterator.next());
        }
    }

    private void updateScriptEditor() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("FIPAOS", this._jtf_fipa_os_location.getText());
        hashtable.put("JDK", this._jtf_jdk_location.getText());
        hashtable.put("FIPAOS_VER", this._jtf_fipa_os_ver.getText());
        hashtable.put("PLATFORM", this._jtf_platform_profile_location.getText());
        String string = (String)this._jcb_debug_option.getSelectedItem();
        String string2 = (String)this._jcb_jit_option.getSelectedItem();
        String string3 = (String)this._jcb_loader_gui_option.getSelectedItem();
        String string4 = (String)this._jcb_dbg_lvl_mem.getSelectedItem();
        String string5 = (String)this._jcb_dbg_lvl_file.getSelectedItem();
        hashtable.put("DEBUGVER", this._debug_on_mappings.get(string));
        hashtable.put("NOJIT", this._jit_mappings.get(string2));
        hashtable.put("LOADER_GUI", this._loader_gui_mappings.get(string3));
        hashtable.put("DBG_LVL_MEM", this._dbg_lvl_mappings.get(string4));
        hashtable.put("DBG_LVL_FILE", this._dbg_lvl_mappings.get(string5));
        this._script_editor.setScriptVariables(hashtable);
    }

    private void updateLists() {
        this.updateList(this._remote_platform_profiles, this._jli_remote_profiles);
        this.updateList(this._acc_internal_transport_addresses, this._jli_acc_internal_transports);
        this.updateList(this._acc_external_transport_addresses, this._jli_acc_external_transports);
        this.updateList(this._default_internal_transport_addresses, this._jli_default_internal_transports);
        this.updateList(this._default_protocol_mappings, this._jli_default_protocol_mappings);
        this.updateList(this._loader_agent_mappings, this._jli_loader_agent_mappings);
        this.pack();
    }

    private void confirmExit() {
        int n = JOptionPane.showConfirmDialog(null, "Save Settings Before Exiting?", "Save Settings?", 1);
        if (n == 0) {
            this.saveNewValues();
        } else if (n == 2) {
            return;
        }
        this.dispose();
        System.exit(0);
    }

    private void centre() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    static {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.ipady = 10;
        _spacer = new JPanel();
        gridBagLayout.setConstraints(_spacer, gridBagConstraints);
        DBG_LVL_KEY1 = "Highest";
        DBG_LVL_KEY2 = "High";
        DBG_LVL_KEY3 = "Medium";
        DBG_LVL_KEY4 = "Low";
        DBG_LVL_KEY5 = "Lowest";
        DBG_LVL_VAL1 = "1";
        DBG_LVL_VAL2 = "2";
        DBG_LVL_VAL3 = "3";
        DBG_LVL_VAL4 = "4";
        DBG_LVL_VAL5 = "5";
    }
}

