/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.configurator;

import fipaos.tool.configurator.FIPAOSConfiguratorTools;
import fipaos.tool.configurator.ScriptVars;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;

public class ScriptEditor
implements ScriptVars {
    private static final String _separator = System.getProperty("file.separator");
    private String[] _script_variables;
    private String[] _script_values;
    private String[] _script_lines;
    private Map _script_keys_values;
    private Map _vars_to_lines;
    public static final String SETUP_WINDOWS = "SetupFIPAOS.bat";
    public static final String SETUP_UNIX = "SetupFIPAOS";
    private boolean _is_windows;
    private String _setupscript_filename;
    private String _real_fipaos_location;
    private String _setupscript;
    private List _editable_vars;
    private boolean _legacy;

    public ScriptEditor() {
        this._legacy = true;
        this._is_windows = this.isWindowsOS();
        this._editable_vars = new LinkedList();
        this._editable_vars.addAll(ScriptVars.SETUPFIPAOS_VARS);
    }

    public ScriptEditor(File file, List list) throws IOException {
        this._editable_vars = new LinkedList(list);
        this._setupscript_filename = file.getCanonicalPath();
        this._is_windows = this._setupscript_filename.endsWith(".bat");
        this._setupscript = FIPAOSConfiguratorTools.loadFileIntoString(this._setupscript_filename);
        this.extractSetupParameters();
    }

    public boolean isWindowsOS() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().indexOf("windows") != -1;
    }

    public boolean populate(String string) {
        this._real_fipaos_location = string;
        if (string == null) {
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setDialogTitle("Select location of setup script");
            int n = jFileChooser.showDialog(null, "Select");
            if (n == 0) {
                this._setupscript_filename = jFileChooser.getSelectedFile().getAbsolutePath();
            }
        } else {
            this._setupscript_filename = string + _separator + "bat" + _separator + SETUP_UNIX;
            if (this._is_windows) {
                this._setupscript_filename = this._setupscript_filename + ".bat";
            }
        }
        try {
            this._setupscript = FIPAOSConfiguratorTools.loadFileIntoString(this._setupscript_filename);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this.populate(null);
        }
        this.extractSetupParameters();
        return true;
    }

    private String getValueOfScriptVariable(String string) {
        int n = 0;
        while (n < this._script_variables.length) {
            if (this._script_variables[n] != null && this._script_variables[n].equals(string)) {
                return this._script_values[n];
            }
            ++n;
        }
        return null;
    }

    private void extractSetupParameters() {
        StringTokenizer stringTokenizer = new StringTokenizer(this._setupscript, "\n", false);
        String string = "";
        if (this._is_windows) {
            string = "set ";
        }
        int n = stringTokenizer.countTokens();
        this._vars_to_lines = new HashMap();
        this._script_keys_values = new HashMap();
        this._script_variables = new String[n];
        this._script_values = new String[n];
        this._script_lines = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            this._script_lines[n3] = string2 = stringTokenizer.nextToken();
            int n4 = string2.toLowerCase().indexOf(string);
            int n5 = string2.indexOf(61, n4);
            if (n4 != -1 && n5 != -1) {
                String string3 = this.getName(string2);
                String string4 = this.getValue(string2);
                if (string3 != null && this._editable_vars.contains(string3)) {
                    if (string3.equals("FIPAOS") && this._legacy) {
                        string4 = this._real_fipaos_location;
                    }
                    this._script_variables[n2] = string3;
                    this._script_values[n2] = string4;
                    this._script_keys_values.put(string3, string4);
                    this._vars_to_lines.put(string3, new Integer(n3));
                    ++n2;
                }
            }
            ++n3;
        }
    }

    public Map getScriptVariables() {
        return this._script_keys_values;
    }

    private String getName(String string) {
        int n;
        int n2;
        String string2 = "";
        if (this._is_windows) {
            string2 = "set ";
            n2 = string.toLowerCase().indexOf(string2);
            n = string.indexOf(61, n2);
        } else {
            n2 = 0;
            n = string.indexOf(61, n2);
        }
        if (n2 != -1 && n != -1) {
            return string.substring(n2 + string2.length(), n);
        }
        return null;
    }

    private String getValue(String string) {
        int n = string.indexOf(61);
        if (n != -1) {
            return string.substring(n + 1, string.length());
        }
        return null;
    }

    public void setScriptVariables(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            Integer n = (Integer)this._vars_to_lines.get(string);
            if (n == null) continue;
            int n2 = n;
            String string3 = this._is_windows ? "SET " + string + "=" + string2 : string + "=" + string2;
            this._script_lines[n2] = string3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        int n = 0;
        while (n < this._script_lines.length) {
            stringBuffer.append(this._script_lines[n]);
            stringBuffer.append(string);
            ++n;
        }
        this._setupscript = stringBuffer.toString();
    }

    public void saveNewConfiguration() {
        try {
            FIPAOSConfiguratorTools.saveStringIntoFile(this._setupscript_filename, this._setupscript);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

