/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.loader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FIPAOSClassLoader
extends ClassLoader {
    private static String[] ABS_PATH_PROPERTIES;
    private static List __cp_elements;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class array$Ljava$lang$String;

    private FIPAOSClassLoader() {
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        byte[] byArray = null;
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        String string3 = string.replace('.', '/');
        string3 = string3 + ".class";
        try {
            byArray = this.getFileContents(string3);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Class not found", iOException);
        }
        if (byArray == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            if (this.getPackage(string2) == null) {
                this.definePackage(string2, null, null, null, null, null, null, null);
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (Throwable throwable) {
            throw new ClassNotFoundException(string, throwable);
        }
        return clazz;
    }

    protected URL findResource(String string) {
        try {
            Enumeration enumeration = this.findResources(string);
            if (enumeration.hasMoreElements()) {
                return (URL)enumeration.nextElement();
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected Enumeration findResources(String string) throws IOException {
        Vector<URL> vector = new Vector<URL>();
        Iterator iterator = __cp_elements.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object e = iterator.next();
            if (e instanceof ZipFile) {
                object2 = (ZipFile)e;
                object = ((ZipFile)object2).getEntry(string);
                if (object == null || ((ZipEntry)object).isDirectory()) continue;
                URL uRL = null;
                uRL = !string.startsWith("/") ? new URL("jar", "", "file:" + ((ZipFile)object2).getName() + "!/" + string) : new URL("jar", "", "file:" + ((ZipFile)object2).getName() + "!" + string);
                vector.add(uRL);
                continue;
            }
            if (!(e instanceof File)) continue;
            object2 = (File)e;
            object = new File((File)e, string);
            if (!((File)object).exists() || !((File)object).isFile()) continue;
            if (!string.startsWith("/")) {
                vector.add(new URL("file", "", ((File)object2).getPath() + File.separatorChar + string));
                continue;
            }
            vector.add(new URL("file", "", ((File)object2).getPath() + string));
        }
        return vector.elements();
    }

    protected Package getPackage(String string) {
        return super.getPackage(string);
    }

    private byte[] getFileContents(String string) throws IOException {
        byte[] byArray = null;
        InputStream inputStream = null;
        URL uRL = this.findResource(string);
        if (uRL == null) {
            throw new IOException("Couldn't find \"" + string + "\"");
        }
        inputStream = uRL.openStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        int n = inputStream.read(byArray2);
        while (n > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
            n = inputStream.read(byArray2);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public static void setupSystemProperties() {
        File file;
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("fipa-os.properties");
        if (inputStream != null) {
            try {
                System.getProperties().load(inputStream);
            }
            catch (Throwable throwable) {
                System.err.println("WARNING: Couldn't parse fipa-os.properties file on classpath");
            }
        }
        if ((file = new File(System.getProperty("user.dir"), "fipa-os.properties")).exists()) {
            try {
                System.getProperties().load(new FileInputStream(file));
            }
            catch (Throwable throwable) {
                System.err.println("WARNING: Couldn't parse fipa-os.properties file");
            }
            FIPAOSClassLoader.makePropertiesAbsolute(file.getParent());
        }
    }

    private static void makePropertiesAbsolute(String string) {
        String string2 = new File(string).getAbsolutePath();
        File file = new File(string2);
        int n = 0;
        while (n < ABS_PATH_PROPERTIES.length) {
            File file2;
            String string3 = System.getProperty(ABS_PATH_PROPERTIES[n]);
            if (string3 != null && !(file2 = new File(string3)).isAbsolute()) {
                try {
                    file2 = new File(file, string3);
                    string3 = file2.getCanonicalPath();
                    Properties properties = System.getProperties();
                    properties.put(ABS_PATH_PROPERTIES[n], string3);
                    System.setProperties(properties);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    private static List getJarFiles(String string) {
        LinkedList<JarFile> linkedList = new LinkedList<JarFile>();
        File file = new File(string);
        if (file.exists()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    File file2 = new File(file, stringArray[n]).getCanonicalFile();
                    ZipFile zipFile = null;
                    String string2 = stringArray[n].substring(stringArray[n].lastIndexOf(46) + 1);
                    if (string2.equalsIgnoreCase("jar")) {
                        zipFile = new JarFile(file2, true);
                    } else if (string2.equalsIgnoreCase("zip")) {
                        zipFile = new ZipFile(file2);
                    }
                    if (zipFile != null) {
                        linkedList.add((JarFile)zipFile);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                ++n;
            }
        }
        return linkedList;
    }

    private static void executeClass(String string, String[] stringArray) {
        try {
            Method method;
            Class clazz;
            Object[] objectArray;
            Object object;
            FIPAOSClassLoader fIPAOSClassLoader = new FIPAOSClassLoader();
            Thread thread = Thread.currentThread();
            try {
                object = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = FIPAOSClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
                objectArray = new Object[]{fIPAOSClassLoader};
                clazz = class$java$lang$Thread == null ? (class$java$lang$Thread = FIPAOSClassLoader.class$("java.lang.Thread")) : class$java$lang$Thread;
                method = clazz.getMethod("setContextClassLoader", (Class<?>)object);
                method.invoke((Object)thread, objectArray);
            }
            catch (Throwable throwable) {
                System.err.println("WARNING: Couldn't set context ClassLoader - JDK 1.1 in use?");
            }
            object = Class.forName("fipaos.FIPAOSFactory", true, fIPAOSClassLoader);
            objectArray = ((Class)object).getMethod("populateFactories", null);
            objectArray.invoke(null, null);
            clazz = fIPAOSClassLoader.loadClass(string);
            method = clazz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = FIPAOSClassLoader.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    private static void executeCommand(String string, String[] stringArray) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        String[] stringArray3 = new String[]{"CLASSPATH=" + FIPAOSClassLoader.createClasspath()};
        Process process = runtime.exec(stringArray2, stringArray3, new File(System.getProperty("user.dir")));
        new IOStreamer(process.getInputStream(), System.out);
        new IOStreamer(process.getErrorStream(), System.err);
        process.waitFor();
    }

    private static String createClasspath() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = __cp_elements.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!bl) {
                stringBuffer.append(File.pathSeparator);
            } else {
                bl = false;
            }
            if (e instanceof ZipFile) {
                stringBuffer.append(((ZipFile)e).getName());
                continue;
            }
            stringBuffer.append(((File)e).getCanonicalPath());
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Throwable {
        String[] stringArray2 = null;
        String string = null;
        boolean bl = false;
        if (stringArray.length <= 0) {
            System.exit(-10);
        }
        string = stringArray[0];
        stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        if (stringArray[0].startsWith("-")) {
            if (stringArray[0].indexOf("d") >= 0) {
                // empty if block
            }
            if (stringArray[0].indexOf("c") >= 0) {
                bl = true;
            }
            if (stringArray2.length > 0) {
                string = stringArray2[0];
                String[] stringArray3 = new String[stringArray2.length - 1];
                System.arraycopy(stringArray2, 1, stringArray3, 0, stringArray3.length);
                stringArray2 = stringArray3;
            } else {
                string = null;
            }
        }
        if (string != null) {
            if (bl) {
                FIPAOSClassLoader.executeCommand(string, stringArray2);
            } else {
                FIPAOSClassLoader.executeClass(string, stringArray2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        block16: {
            ABS_PATH_PROPERTIES = new String[]{"fipaos.home", "fipaos.profile.platform"};
            __cp_elements = new LinkedList();
            try {
                FIPAOSClassLoader.setupSystemProperties();
                if (System.getProperty("fipaos.home") != null) {
                    File file;
                    string = System.getProperty("fipaos.home") + File.separatorChar + "classes";
                    String string2 = System.getProperty("fipaos.home") + File.separatorChar + "ext";
                    File file2 = new File(string);
                    if (!file2.exists() || file2.isFile()) {
                        System.err.println("WARNING: Couldn't find classes directory to add to classpath");
                    } else {
                        __cp_elements.add(file2.getCanonicalFile());
                    }
                    File file3 = new File(string2);
                    if (!file3.exists() || file3.isFile()) {
                        System.err.println("WARNING: Couldn't find ext directory to add to classpath");
                    } else {
                        try {
                            __cp_elements.addAll(FIPAOSClassLoader.getJarFiles(string2));
                        }
                        catch (Throwable throwable) {
                            System.err.println("Error when locating 3rd party JARs/ZIPs to include in classpath: " + throwable);
                        }
                    }
                    String string3 = System.getProperty("fipaos.version").replace('.', '_');
                    boolean bl = System.getProperty("fipaos.debug", "true").equals("true");
                    String string4 = string + File.separatorChar + "FIPA_OSv" + string3;
                    if (bl) {
                        string4 = string4 + "_debug";
                    }
                    if (!(file = new File(string4 = string4 + ".jar")).exists() || file.isDirectory()) {
                        System.err.println("WARNING: Couldn't find FIPA-OS JAR to add to classpath");
                    } else {
                        try {
                            __cp_elements.add(new JarFile(file.getCanonicalFile()));
                        }
                        catch (IOException iOException) {
                            System.err.println("WARNING: Couldn't add FIPA-OS JAR to classpath");
                        }
                    }
                    break block16;
                }
                System.err.println("ERROR: fipaos.home not specified - possible cause is\n       that fipa-os.properties file couldn't be found.\n       (Is it in the current directory, or the directory\n       indicated by the user.dir system property?)");
                System.exit(-10);
            }
            catch (Throwable throwable) {
                System.err.println("ERROR: Exception during FIPAOSClassLoader initialisation");
                System.exit(-10);
            }
        }
        string = System.getProperty("fipaos.home") + File.separatorChar + "imports";
        try {
            __cp_elements.addAll(FIPAOSClassLoader.getJarFiles(string));
        }
        catch (Throwable throwable) {
            System.err.println("Error when locating 3rd party JARs/ZIPs to include in classpath: " + throwable);
        }
    }

    private static class IOStreamer
    implements Runnable {
        private BufferedInputStream _in;
        private OutputStream _out;

        public IOStreamer(InputStream inputStream, OutputStream outputStream) {
            this._in = new BufferedInputStream(inputStream);
            this._out = outputStream;
            new Thread((Runnable)this, "IOStreamer");
        }

        public void run() {
            try {
                byte[] byArray = new byte[1024];
                int n = this._in.read(byArray);
                while (n >= 0) {
                    this._out.write(byArray, 0, n);
                    n = this._in.read(byArray);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

