/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.loader;

import fipaos.agent.profile.AgentDescription;
import fipaos.tool.loader.AgentLoader;
import fipaos.tool.loader.LoaderDialog;
import fipaos.tool.loader.taskmanagermonitor.TaskManagerMonitorFrame;
import fipaos.tool.loader.threadpoolmonitor.ThreadPoolMonitorFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class LoaderGUI
extends JFrame {
    private AgentLoader _loader;
    private List _started = new LinkedList();
    private List _ready = new LinkedList();
    private List _previous_agents = new LinkedList();
    private List _previous_clases = new LinkedList();
    private long _last_click;
    private List _last_sel = new LinkedList();
    private JMenuBar jMenuBar1;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JList _started_list;
    private JButton _start_button;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JList _ready_to_start;
    private JButton _start_other;
    private JButton _shutdown_button;

    public LoaderGUI(AgentLoader agentLoader) {
        Object object;
        this._loader = agentLoader;
        this.initComponents();
        this.updateLists();
        Iterator iterator = this._loader.getAgents().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            AgentDescription agentDescription = this._loader.getAgentDescription((String)object);
            this._previous_agents.add(object);
            this._previous_clases.add(agentDescription.getClassName());
        }
        this.startPolling();
        this.pack();
        object = Toolkit.getDefaultToolkit();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.setSize(n, n2);
        n = ((Toolkit)object).getScreenSize().width - n;
        n2 = ((Toolkit)object).getScreenSize().height - n2;
        this.setLocation(n / 2, n2 / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._started_list = new JList();
        this._start_button = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this._ready_to_start = new JList();
        this._start_other = new JButton();
        this._shutdown_button = new JButton();
        this.jMenu1.setText("Tools");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jMenuItem1.setText("Thread Pool Monitor");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderGUI.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.jMenuItem2.setText("Task Manager Monitor");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderGUI.this.jMenuItem2ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu1);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/logo.gif")).getImage());
        this.setTitle("FIPA-OS v" + System.getProperty("fipaos.version") + " - Agent Loader");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoaderGUI.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new TitledBorder("Running Agents"));
        this.jScrollPane1.setPreferredSize(new Dimension(150, 100));
        this._started_list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LoaderGUI.this.startedListMouseClick(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this._started_list);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this._start_button.setText("< Start");
        this._start_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderGUI.this._start_buttonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this._start_button, gridBagConstraints);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setBorder(new TitledBorder("Known Agents"));
        this.jScrollPane2.setPreferredSize(new Dimension(150, 100));
        this.jScrollPane2.setViewportView(this._ready_to_start);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this._start_other.setText("Start other...");
        this._start_other.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderGUI.this._start_otherActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this._start_other, gridBagConstraints);
        this._shutdown_button.setActionCommand("Shutdown");
        this._shutdown_button.setText("Shutdown >");
        this._shutdown_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderGUI.this._shutdown_buttonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this._shutdown_button, gridBagConstraints);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void jMenuItem2ActionPerformed(ActionEvent actionEvent) {
        new TaskManagerMonitorFrame();
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        new ThreadPoolMonitorFrame();
    }

    private void startedListMouseClick(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis();
        List<Object> list = Arrays.asList(this._started_list.getSelectedValues());
        if (this._last_click == 0L) {
            this._last_click = System.currentTimeMillis();
            this._last_sel.clear();
            this._last_sel.addAll(list);
        } else if (l - this._last_click > 500L) {
            this._last_click = l;
            this._last_sel.clear();
            this._last_sel.addAll(list);
        } else if (list.containsAll(this._last_sel) && this._last_sel.containsAll(list)) {
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                this._loader.activate((String)iterator.next());
            }
            this._last_click = 0L;
        }
    }

    private void _start_otherActionPerformed(ActionEvent actionEvent) {
        LoaderDialog loaderDialog = new LoaderDialog((Frame)this, this._previous_agents, this._previous_clases);
        String string = loaderDialog.getAgentName();
        String string2 = loaderDialog.getClassName();
        if (string != null) {
            this._previous_agents.add(0, string);
            this._previous_clases.add(0, string2);
            this._loader.startAgent(string, string2);
        }
    }

    private void _shutdown_buttonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = null;
        LoaderGUI loaderGUI = this;
        synchronized (loaderGUI) {
            objectArray = this._started_list.getSelectedValues();
        }
        if (objectArray == null || objectArray.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select an Agent to shutdown");
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this._loader.shutdownAgent((String)objectArray[n]);
            this.updateLists();
            ++n;
        }
    }

    private void _start_buttonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = null;
        LoaderGUI loaderGUI = this;
        synchronized (loaderGUI) {
            objectArray = this._ready_to_start.getSelectedValues();
        }
        if (objectArray == null || objectArray.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select an Agent to start");
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this._loader.startAgent((String)objectArray[n], true);
            this.updateLists();
            ++n;
        }
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
    }

    private void shutdownButton2ActionPerformed(ActionEvent actionEvent) {
    }

    private void exitForm(WindowEvent windowEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                LoaderGUI.this._loader.shutdownAgents();
                System.exit(0);
            }
        });
        thread.start();
        this.dispose();
    }

    private void updateLists() {
        LoaderGUI loaderGUI = this;
        synchronized (loaderGUI) {
            Vector vector;
            Object[] objectArray = this._ready_to_start.getSelectedValues();
            Object[] objectArray2 = this._started_list.getSelectedValues();
            List list = this._loader.getAliveAgents();
            List list2 = this._loader.getAgents();
            list2.removeAll(list);
            if (!this._started.containsAll(list) || !list.containsAll(this._started)) {
                vector = new Vector(list);
                this._started_list.setListData(vector.toArray());
                this.updateSelected(objectArray2, this._started_list, vector);
                this._started.clear();
                this._started.addAll(list);
            }
            if (!this._ready.containsAll(list2) || !list2.containsAll(this._ready)) {
                vector = new Vector(list2);
                this._ready_to_start.setListData(vector.toArray());
                this.updateSelected(objectArray, this._ready_to_start, vector);
                this._ready.clear();
                this._ready.addAll(list2);
            }
        }
    }

    private void updateSelected(Object[] objectArray, JList jList, List list) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        int n = 0;
        int[] nArray = new int[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            int n3 = list.indexOf(objectArray[n2]);
            if (n3 != -1) {
                nArray[n++] = n3;
            }
            ++n2;
        }
        if (n != 0) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            jList.setSelectedIndices(nArray2);
        } else {
            jList.clearSelection();
        }
    }

    private void startPolling() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    LoaderGUI.this.updateLists();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        });
        thread.start();
    }
}

