/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.loader.taskmanagermonitor;

import fipaos.agent.task.TaskManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TaskManagerMonitorFrame
extends JFrame {
    private int _refresh = 1000;
    private List _known_tms = new Vector();
    private boolean _shutdown;
    private JPanel jPanel2;
    private JSplitPane jSplitPane1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JList _jlist;
    private JPanel jPanel4;
    private JLabel jLabel3;
    private JLabel _count;
    private JLabel jLabel5;
    private JLabel _timeouts;
    private JLabel jLabel2;
    private JLabel _pending_events;
    private JScrollPane jScrollPane2;
    private JList jList1;
    private JPanel jPanel6;
    private JSlider _rate;

    public TaskManagerMonitorFrame() {
        this.initComponents();
        this.pack();
        this.refreshGUI();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                TaskManagerMonitorFrame.this.monitor();
            }
        });
        thread.start();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.setSize(n, n2);
        n = toolkit.getScreenSize().width - n;
        n2 = toolkit.getScreenSize().height - n2;
        this.setLocation(n / 2, n2 / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._jlist = new JList();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this._count = new JLabel();
        this.jLabel5 = new JLabel();
        this._timeouts = new JLabel();
        this.jLabel2 = new JLabel();
        this._pending_events = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel6 = new JPanel();
        this._rate = new JSlider();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/logo.gif")).getImage());
        this.setTitle("TaskManager Monitor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TaskManagerMonitorFrame.this.exitForm(windowEvent);
            }
        });
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setBorder(new TitledBorder("VM Task Managers"));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this._jlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TaskManagerMonitorFrame.this.selectionChanged(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this._jlist);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("Task Manager Details"));
        this.jLabel3.setText("Task Count:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this._count.setText("jLabel1");
        this._count.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this._count, gridBagConstraints);
        this.jLabel5.setText("Timeout Count:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this._timeouts.setText("jLabel1");
        this._timeouts.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this._timeouts, gridBagConstraints);
        this.jLabel2.setText("Pending TaskEvents:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this._pending_events.setText("jLabel1");
        this._pending_events.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this._pending_events, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel4);
        this.jPanel2.add((Component)this.jSplitPane1, "Center");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints2);
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel6.setBorder(new TitledBorder("Refresh Period (ms)"));
        this._rate.setMinorTickSpacing(250);
        this._rate.setPaintLabels(true);
        this._rate.setPaintTicks(true);
        this._rate.setMinimum(250);
        this._rate.setMajorTickSpacing(1000);
        this._rate.setMaximum(2250);
        this._rate.setValue(this._refresh);
        this._rate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TaskManagerMonitorFrame.this.refreshRateChanged(changeEvent);
            }
        });
        this.jPanel6.add((Component)this._rate, "Center");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 0.8;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints2);
    }

    private void refreshRateChanged(ChangeEvent changeEvent) {
        this._refresh = this._rate.getValue();
    }

    private void selectionChanged(MouseEvent mouseEvent) {
        this.refreshGUI();
    }

    private void exitForm(WindowEvent windowEvent) {
        this._shutdown = true;
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new TaskManagerMonitorFrame();
    }

    private void refreshGUI() {
        TaskManager taskManager = (TaskManager)this._jlist.getSelectedValue();
        Set set = TaskManager.getVMTaskManagers();
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(this._known_tms);
        HashSet hashSet2 = new HashSet(this._known_tms);
        hashSet2.removeAll(set);
        this._known_tms.removeAll(hashSet2);
        this._known_tms.addAll(hashSet);
        if (taskManager != null && hashSet2.contains(taskManager)) {
            taskManager = null;
        }
        if (hashSet2.size() > 0 || hashSet.size() > 0) {
            this._jlist.setListData(this._known_tms.toArray());
            this._jlist.setSelectedValue(taskManager, false);
        }
        this.refreshGUI(taskManager);
    }

    private void refreshGUI(TaskManager taskManager) {
        if (taskManager == null) {
            this._count.setText("N/A");
            this._timeouts.setText("N/A");
            this._pending_events.setText("N/A");
            this.jList1.setListData(new Object[0]);
        } else {
            Object object;
            Serializable serializable;
            this._count.setText("" + taskManager.getTaskCount());
            this._timeouts.setText("" + taskManager.getTimeoutCount());
            this._pending_events.setText("" + taskManager.getPendingTaskEvents());
            Set set = taskManager.getActiveTasks();
            HashMap<Serializable, Integer> hashMap = new HashMap<Serializable, Integer>();
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                serializable = iterator.next().getClass();
                if (hashMap.get(serializable) == null) {
                    hashMap.put(serializable, new Integer(1));
                    continue;
                }
                object = (Integer)hashMap.get(serializable);
                int n2 = (Integer)object + 1;
                if (n2 > n) {
                    n = n2;
                }
                hashMap.put(serializable, new Integer(n2));
            }
            n = new String("" + n).length();
            serializable = new Vector(hashMap.size());
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                Class clazz = (Class)object.next();
                int n3 = (Integer)hashMap.get(clazz);
                ((Vector)serializable).add(n3 + "x " + clazz.getName());
            }
            this.jList1.setListData(((Vector)serializable).toArray());
        }
    }

    public void monitor() {
        while (!this._shutdown) {
            try {
                Thread.sleep(this._refresh);
                this.refreshGUI();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

