/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.loader.threadpoolmonitor;

import fipaos.util.ThreadPool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ThreadPoolMonitorFrame
extends JFrame {
    private int _refresh = 1000;
    private List _known_tps = new Vector();
    private boolean _shutdown;
    private long _last_active;
    private long _last_inactive;
    private JPanel jPanel2;
    private JSplitPane jSplitPane1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JList _jlist;
    private JPanel jPanel4;
    private JLabel jLabel3;
    private JLabel _count;
    private JLabel jLabel5;
    private JLabel _active;
    private JLabel jLabel2;
    private JLabel _time_active;
    private JLabel jLabel6;
    private JLabel _time_inactive;
    private JLabel jLabel7;
    private JLabel _pending;
    private JPanel jPanel5;
    private JProgressBar _utilisation;
    private JPanel jPanel6;
    private JSlider _rate;

    public ThreadPoolMonitorFrame() {
        this.initComponents();
        this.pack();
        this.refreshGUI();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ThreadPoolMonitorFrame.this.monitor();
            }
        });
        thread.start();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.setSize(n, n2);
        n = toolkit.getScreenSize().width - n;
        n2 = toolkit.getScreenSize().height - n2;
        this.setLocation(n / 2, n2 / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._jlist = new JList();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this._count = new JLabel();
        this.jLabel5 = new JLabel();
        this._active = new JLabel();
        this.jLabel2 = new JLabel();
        this._time_active = new JLabel();
        this.jLabel6 = new JLabel();
        this._time_inactive = new JLabel();
        this.jLabel7 = new JLabel();
        this._pending = new JLabel();
        this.jPanel5 = new JPanel();
        this._utilisation = new JProgressBar();
        this.jPanel6 = new JPanel();
        this._rate = new JSlider();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/logo.gif")).getImage());
        this.setTitle("ThreadPool Monitor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThreadPoolMonitorFrame.this.exitForm(windowEvent);
            }
        });
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setBorder(new TitledBorder("VM Thread Pools"));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this._jlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ThreadPoolMonitorFrame.this.selectionChanged(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this._jlist);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("Thread Pool Details"));
        this.jLabel3.setText("Thread Count:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this._count.setText("jLabel1");
        this._count.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this._count, gridBagConstraints);
        this.jLabel5.setText("Active Thread Count:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this._active.setText("jLabel1");
        this._active.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this._active, gridBagConstraints);
        this.jLabel2.setText("Total Time Active:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this._time_active.setText("jLabel1");
        this._time_active.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this._time_active, gridBagConstraints);
        this.jLabel6.setText("Total Time Inactive:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.jPanel4.add((Component)this.jLabel6, gridBagConstraints);
        this._time_inactive.setText("jLabel1");
        this._time_inactive.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this._time_inactive, gridBagConstraints);
        this.jLabel7.setText("Pending Jobs:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jLabel7, gridBagConstraints);
        this._pending.setText("jLabel1");
        this._pending.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this._pending, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel4);
        this.jPanel2.add((Component)this.jSplitPane1, "Center");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints2);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel5.setBorder(new TitledBorder("Overall Thread Utilisation"));
        this.jPanel5.add((Component)this._utilisation, "Center");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel5, gridBagConstraints2);
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel6.setBorder(new TitledBorder("Refresh Period (ms)"));
        this._rate.setMinorTickSpacing(250);
        this._rate.setPaintLabels(true);
        this._rate.setPaintTicks(true);
        this._rate.setMinimum(250);
        this._rate.setMajorTickSpacing(1000);
        this._rate.setMaximum(2250);
        this._rate.setValue(this._refresh);
        this._rate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ThreadPoolMonitorFrame.this.refreshRateChanged(changeEvent);
            }
        });
        this.jPanel6.add((Component)this._rate, "Center");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 0.8;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints2);
    }

    private void refreshRateChanged(ChangeEvent changeEvent) {
        this._refresh = this._rate.getValue();
    }

    private void selectionChanged(MouseEvent mouseEvent) {
        this.refreshGUI();
    }

    private void exitForm(WindowEvent windowEvent) {
        this._shutdown = true;
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new ThreadPoolMonitorFrame();
    }

    private void refreshGUI() {
        ThreadPool threadPool = (ThreadPool)this._jlist.getSelectedValue();
        Set set = ThreadPool.getThreadPools();
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(this._known_tps);
        HashSet hashSet2 = new HashSet(this._known_tps);
        hashSet2.removeAll(set);
        this._known_tps.removeAll(hashSet2);
        this._known_tps.addAll(hashSet);
        if (threadPool != null && hashSet2.contains(threadPool)) {
            threadPool = null;
        }
        if (hashSet2.size() > 0 || hashSet.size() > 0) {
            this._jlist.setListData(this._known_tps.toArray());
            this._jlist.setSelectedValue(threadPool, false);
        }
        this.refreshGUI(threadPool);
        this.refreshGUI(this._known_tps);
    }

    private void refreshGUI(ThreadPool threadPool) {
        if (threadPool == null) {
            this._active.setText("N/A");
            this._count.setText("N/A");
            this._pending.setText("N/A");
            this._time_active.setText("N/A");
            this._time_inactive.setText("N/A");
        } else {
            this._active.setText("" + threadPool.getActiveThreadCount());
            this._count.setText("" + threadPool.getThreadCount());
            this._pending.setText("" + threadPool.getWaitingJobCount());
            this._time_active.setText("" + threadPool.getTotalActiveTime() + " ms");
            this._time_inactive.setText("" + threadPool.getTotalInactiveTime() + " ms");
        }
    }

    private void refreshGUI(List list) {
        long l = 0L;
        long l2 = 0L;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ThreadPool threadPool = (ThreadPool)iterator.next();
            l += threadPool.getTotalInactiveTime() + threadPool.getTotalActiveTime();
            l2 += threadPool.getTotalActiveTime();
        }
        int n = 0;
        if (this._last_inactive != 0L && l != this._last_inactive) {
            n = (int)((l2 - this._last_active) * 100L / (l - this._last_inactive));
        }
        this._last_active = l2;
        this._last_inactive = l;
        this._utilisation.setValue(n);
        this._utilisation.setString(n + "%");
        this._utilisation.setToolTipText(n + "%");
    }

    public void monitor() {
        while (!this._shutdown) {
            try {
                Thread.sleep(this._refresh);
                this.refreshGUI();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

