/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.profile.Profile;
import fipaos.parser.datamapping.DataMapperFactory;
import fipaos.tool.configurator.ScriptEditor;
import fipaos.tool.configurator.ScriptVars;
import fipaos.tool.profile.FIPAOSProperties;
import fipaos.tool.wizard.TransportDefinition;
import fipaos.tool.wizard.WizardPanel;
import fipaos.tool.wizard.panels.ACCConfiguration;
import fipaos.tool.wizard.panels.DefaultAgentProfilePanel;
import fipaos.tool.wizard.panels.EndPanel;
import fipaos.tool.wizard.panels.GarbageSettingsPanel;
import fipaos.tool.wizard.panels.IntroductionPanel;
import fipaos.tool.wizard.panels.LoaderPanel;
import fipaos.tool.wizard.panels.PlatformDetails;
import fipaos.tool.wizard.panels.PlatformDistribution;
import fipaos.tool.wizard.panels.PropertiesPanel;
import fipaos.tool.wizard.panels.SetupOptionsPanel;
import fipaos.util.DocumentRetriever;
import fipaos.util.XMLDataBinding;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class FIPAOSWizard
extends JFrame
implements ScriptVars {
    public static final TransportDefinition[] TRANSPORTS;
    public static final String STANDALONE_AP_NAME = "localap";
    private static final String PROFILES = "profiles";
    private static final String PLATFORM_PROFILE = "platform.profile";
    private static final String ACC_PROFILE = "acc.profile";
    private static final String DEFAULT_PROFILE = "default.profile";
    private static final String LOADER_PROFILE = "loader.profile";
    private static final String FIPAOS_LOCATION;
    private static final String FIPAOS_PROPERTIES = "fipa-os.properties";
    private PlatformProfile _platform_profile;
    private AgentProfile _default_profile;
    private ACCProfile _acc_profile;
    private LoaderProfile _loader_profile;
    private ScriptEditor _startfipaos_script;
    private ScriptEditor _setupfipaos_script;
    private Map _startfipaos_vars;
    private Map _setupfipaos_vars;
    private FIPAOSProperties _fipaos_properties;
    private String _properties_comments;
    private boolean _custom_setup = false;
    private boolean _distributed_platform = false;
    private PlatformDistribution _platform_distribution = new PlatformDistribution(this);
    private List _panels = new LinkedList<WizardPanel>(Arrays.asList(new IntroductionPanel(), new SetupOptionsPanel(this, this._platform_distribution), this._platform_distribution, new EndPanel()));
    private int _current_pane = 0;
    private JButton _cancel;
    private JButton _prev;
    private JButton _finish;
    private JScrollPane jScrollPane2;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel jPanel4;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JSeparator jSeparator2;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JButton _next;

    public FIPAOSWizard() {
        this.initComponents();
        this.initialiseWizardPanels();
        this.setCurrentPane((JComponent)this._panels.get(0));
        this.pack();
        this.setResizable(true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        n = 640;
        n2 = 550;
        if (toolkit.getScreenSize().width < n) {
            n = toolkit.getScreenSize().width;
        }
        if (toolkit.getScreenSize().height < n2) {
            n2 = toolkit.getScreenSize().height;
        }
        this.setSize(n, n2);
        n = toolkit.getScreenSize().width - n;
        n2 = toolkit.getScreenSize().height - n2;
        this.setLocation(n / 2, n2 / 2);
        this.setResizable(false);
        this.setVisible(true);
        this.makeButtonsAvailable();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._cancel = new JButton();
        this._prev = new JButton();
        this._next = new JButton();
        this._finish = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.setTitle("FIPA-OS Wizard");
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/logo.gif")).getImage());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FIPAOSWizard.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this._cancel.setText("Cancel");
        this._cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FIPAOSWizard.this.cancel(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.jPanel1.add((Component)this._cancel, gridBagConstraints);
        this._prev.setText("< Prev");
        this._prev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FIPAOSWizard.this.prev(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 1, 5, 1);
        this.jPanel1.add((Component)this._prev, gridBagConstraints);
        this._next.setText("Next >");
        this._next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FIPAOSWizard.this.next(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 1, 5, 1);
        this.jPanel1.add((Component)this._next, gridBagConstraints);
        this._finish.setText("Finish");
        this._finish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FIPAOSWizard.this.finish(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.jPanel1.add((Component)this._finish, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Configuration Wizard");
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setFont(new Font("Dialog", 0, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/wizard-banner.jpg")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane2.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.jScrollPane2.setVerticalScrollBarPolicy(20);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel4.setBackground(new Color(51, 51, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel3, "Center");
    }

    private void cancel(ActionEvent actionEvent) {
        this.dispose();
        System.exit(0);
    }

    private void prev(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FIPAOSWizard.this.prev();
            }
        });
        thread.start();
    }

    private void next(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FIPAOSWizard.this.next();
            }
        });
        thread.start();
    }

    private void finish(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                WizardPanel wizardPanel = (WizardPanel)FIPAOSWizard.this._panels.get(FIPAOSWizard.this._current_pane);
                if (!wizardPanel.isOk()) {
                    return;
                }
                FIPAOSWizard.this.saveIfModified();
                FIPAOSWizard.this.dispose();
                System.exit(0);
            }
        });
        thread.start();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.cancel(null);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            Object object = UIManager.get("Label.background");
            UIManager.put("TextArea.background", object);
            UIManager.put("Panel.background", object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        new FIPAOSWizard().show();
    }

    private void setCurrentPane(JComponent jComponent) {
        this.jScrollPane2.setViewportView(jComponent);
    }

    private void prev() {
        if (this._current_pane > 0) {
            --this._current_pane;
        }
        this.makeButtonsAvailable();
        this.setCurrentPane((JComponent)this._panels.get(this._current_pane));
    }

    private void next() {
        WizardPanel wizardPanel = (WizardPanel)this._panels.get(this._current_pane);
        if (!wizardPanel.isOk()) {
            return;
        }
        if (this._current_pane < this._panels.size() - 1) {
            ++this._current_pane;
        }
        this.makeButtonsAvailable();
        this.setCurrentPane((JComponent)this._panels.get(this._current_pane));
    }

    private void makeButtonsAvailable() {
        boolean bl = this._current_pane >= this._panels.size() - 1;
        this._prev.setEnabled(this._current_pane > 0);
        this._next.setEnabled(!bl);
        this._finish.setEnabled(bl);
    }

    public void insertPanel(WizardPanel wizardPanel, WizardPanel wizardPanel2) {
        int n = this._panels.indexOf(wizardPanel);
        if (++n <= this._current_pane) {
            ++this._current_pane;
        }
        this._panels.add(n, wizardPanel2);
        wizardPanel2.initialise(this._acc_profile, this._default_profile, this._loader_profile, this._platform_profile, this._setupfipaos_vars, this._startfipaos_vars, this._fipaos_properties);
        this.sortPanels();
        this.makeButtonsAvailable();
    }

    public void removePanel(WizardPanel wizardPanel) {
        int n = this._panels.indexOf(wizardPanel);
        if (n <= this._current_pane) {
            --this._current_pane;
        }
        this._panels.remove(wizardPanel);
        this.sortPanels();
        this.makeButtonsAvailable();
    }

    public void sortPanels() {
        Collections.sort(this._panels, new PanelCompare());
    }

    private void initialiseWizardPanels() {
        this.loadProfiles();
        Iterator iterator = new LinkedList(this._panels).iterator();
        while (iterator.hasNext()) {
            WizardPanel wizardPanel = (WizardPanel)iterator.next();
            wizardPanel.initialise(this._acc_profile, this._default_profile, this._loader_profile, this._platform_profile, this._setupfipaos_vars, this._startfipaos_vars, this._fipaos_properties);
        }
        this.sortPanels();
    }

    private boolean isModified() {
        boolean bl = false;
        Iterator iterator = this._panels.iterator();
        while (iterator.hasNext() && !bl) {
            WizardPanel wizardPanel = (WizardPanel)iterator.next();
            bl |= wizardPanel.isModified();
        }
        return bl;
    }

    private void resetModified() {
        Iterator iterator = this._panels.iterator();
        while (iterator.hasNext()) {
            WizardPanel wizardPanel = (WizardPanel)iterator.next();
            wizardPanel.resetModified();
        }
    }

    private void saveIfModified() {
        if (this.isModified()) {
            this.saveProfiles();
            this.resetModified();
        }
    }

    private String getCommentsFromProperties(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (!string4.trim().startsWith("#")) continue;
            string2 = string2 + string4 + System.getProperty("line.separator");
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, System.getProperty("line.separator"));
        string4 = stringTokenizer2.nextToken();
        string3 = string4.substring(1) + System.getProperty("line.separator");
        while (stringTokenizer2.hasMoreTokens()) {
            string4 = stringTokenizer2.nextToken();
            if (!stringTokenizer2.hasMoreTokens()) continue;
            string3 = string3 + string4 + System.getProperty("line.separator");
        }
        return string3;
    }

    private void loadProfiles() {
        Object object;
        Object object2;
        boolean bl = false;
        File file = new File(FIPAOS_LOCATION);
        File file2 = new File(file, PROFILES);
        File file3 = new File(file2, PLATFORM_PROFILE);
        this._platform_profile = (PlatformProfile)this.fetchProfile(file3);
        if (this._platform_profile.getProfileDirectory() == null || this._platform_profile.getProfileDirectory().equals("")) {
            try {
                this._platform_profile.setProfileDirectory(file2.getCanonicalPath() + File.separator);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            bl = true;
        } else {
            file2 = new File(this._platform_profile.getProfileDirectory());
        }
        this._acc_profile = (ACCProfile)this.fetchProfile(new File(file2, ACC_PROFILE));
        this._default_profile = (AgentProfile)this.fetchProfile(new File(file2, DEFAULT_PROFILE));
        this._loader_profile = (LoaderProfile)this.fetchProfile(new File(file2, LOADER_PROFILE));
        File file4 = new File(file, "bat");
        try {
            object2 = new File(file4, "SetupFIPAOS.bat");
            if (!((File)object2).exists()) {
                object2 = new File(file4, "SetupFIPAOS");
            }
            if (((File)object2).exists()) {
                this._setupfipaos_script = new ScriptEditor((File)object2, ScriptVars.SETUPFIPAOS_VARS);
                this._setupfipaos_vars = this._setupfipaos_script.getScriptVariables();
            }
            object = new File(file4, "StartFIPAOS.bat");
            if (!((File)object).exists()) {
                object = new File(file4, "StartFIPAOS.sh");
            }
            if (((File)object).exists()) {
                this._startfipaos_script = new ScriptEditor((File)object, ScriptVars.STARTFIPAOS_VARS);
                this._startfipaos_vars = this._startfipaos_script.getScriptVariables();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            object2 = DocumentRetriever.getDoc(FIPAOS_PROPERTIES);
            this._properties_comments = this.getCommentsFromProperties((String)object2);
            object = DataMapperFactory.createDataMapper(FIPAOS_PROPERTIES, (String)object2, null);
            this._fipaos_properties = (FIPAOSProperties)object.unmarshall((String)object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl) {
            try {
                if (this._acc_profile != null) {
                    this._acc_profile.setLocalAddressesLocation(new File(file, "platform.addresses").getCanonicalPath());
                    this._acc_profile.getDatabaseProfile().setDatabaseLocation(new File(file, "databases").getCanonicalPath() + File.separator);
                }
                if (this._default_profile != null) {
                    this._default_profile.getDatabaseProfile().setDatabaseLocation(new File(file, "databases").getCanonicalPath() + File.separator);
                }
                if (this._setupfipaos_vars != null) {
                    this._setupfipaos_vars.put("FIPAOS", file.getCanonicalPath());
                }
                this.saveProfiles();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void saveProfiles() {
        File file = new File(FIPAOS_LOCATION);
        File file2 = new File(file, PROFILES);
        if (this._acc_profile != null) {
            this.saveProfile(this._acc_profile, new File(file2, ACC_PROFILE));
        }
        if (this._default_profile != null) {
            this.saveProfile(this._default_profile, new File(file2, DEFAULT_PROFILE));
        }
        if (this._loader_profile != null) {
            this.saveProfile(this._loader_profile, new File(file2, LOADER_PROFILE));
        }
        if (this._platform_profile != null) {
            this.saveProfile(this._platform_profile, new File(file2, PLATFORM_PROFILE));
        }
        if (this._setupfipaos_script != null) {
            this._setupfipaos_script.setScriptVariables(this._setupfipaos_vars);
            this._setupfipaos_script.saveNewConfiguration();
        }
        if (this._startfipaos_script != null) {
            this._startfipaos_script.setScriptVariables(this._startfipaos_vars);
            this._startfipaos_script.saveNewConfiguration();
        }
        if (this._fipaos_properties != null) {
            Properties properties = new Properties();
            properties.setProperty("fipaos.debug", this._fipaos_properties.getFipaosDebug());
            properties.setProperty("fipaos.profile.platform", this._fipaos_properties.getFipaosProfilePlatform());
            properties.setProperty("fipaos.agentloader.gui", this._fipaos_properties.getFipaosAgentloaderGui());
            properties.setProperty("fipaos.home", this._fipaos_properties.getFipaosHome());
            properties.setProperty("debug.level.memory", this._fipaos_properties.getDebugLevelMemory());
            properties.setProperty("fipaos.version", this._fipaos_properties.getFipaosVersion());
            properties.setProperty("debug.level.file", this._fipaos_properties.getDebugLevelFile());
            properties.setProperty("fipaos.aggressive_garbage_collect", this._fipaos_properties.getFipaosAggressive_garbage_collect());
            properties.setProperty("fipaos.garbage.limit", this._fipaos_properties.getFipaosGarbageLimit());
            properties.setProperty("fipaos.garbage.more_aggressive_limit", this._fipaos_properties.getFipaosGarbageMore_aggressive_limit());
            properties.setProperty("fipaos.garbage.delay", this._fipaos_properties.getFipaosGarbageDelay());
            properties.setProperty("fipaos.garbage.min_delay", this._fipaos_properties.getFipaosGarbageMin_delay());
            properties.setProperty("fipaos.garbage.priority", this._fipaos_properties.getFipaosGarbagePriority());
            properties.setProperty("fipaos.garbage.abs_memory_value", this._fipaos_properties.getFipaosGarbageAbs_memory_value());
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(FIPAOS_PROPERTIES);
                properties.store(fileOutputStream, this._properties_comments);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveProfile(Profile profile, File file) {
        try {
            XMLDataBinding.marshallFile((Object)profile, file.getCanonicalPath());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private Profile fetchProfile(File file) {
        Profile profile = null;
        try {
            profile = (Profile)XMLDataBinding.unmarshallFile(file.getCanonicalPath());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return profile;
    }

    static {
        FIPAOS_LOCATION = System.getProperty("fipaos.home", System.getProperty("user.dir") + "/..");
        TransportDefinition transportDefinition = new TransportDefinition();
        transportDefinition.setName("fipaos-rmi");
        transportDefinition.setExternal(false);
        transportDefinition.setUsedByAgent(false);
        transportDefinition.setUsedByACC(false);
        transportDefinition.setNSPort(3000);
        transportDefinition.setScriptNSEnableVar("STARTRMINS");
        transportDefinition.setScriptNSPortVar("RMINSPORT");
        TransportDefinition transportDefinition2 = new TransportDefinition();
        transportDefinition2.setName("fipaos-ssl-rmi");
        transportDefinition2.setExternal(false);
        transportDefinition2.setUsedByAgent(false);
        transportDefinition2.setUsedByACC(false);
        transportDefinition2.setNSPort(3000);
        transportDefinition2.setScriptNSEnableVar("STARTSSLRMINS");
        transportDefinition2.setScriptNSPortVar("SSLRMINSPORT");
        TransportDefinition transportDefinition3 = new TransportDefinition();
        transportDefinition3.setName("corbaname");
        transportDefinition3.setExternal(true);
        transportDefinition3.setUsedByAgent(false);
        transportDefinition3.setUsedByACC(false);
        transportDefinition3.setNSPort(4000);
        transportDefinition3.setScriptNSEnableVar("STARTIIOPNS");
        transportDefinition3.setScriptNSPortVar("IIOPNSPORT");
        TransportDefinition transportDefinition4 = new TransportDefinition();
        transportDefinition4.setName("http");
        transportDefinition4.setExternal(true);
        transportDefinition4.setUsedByAgent(false);
        transportDefinition4.setUsedByACC(false);
        transportDefinition4.setNSPort(8080);
        transportDefinition4.setScriptNSEnableVar(null);
        transportDefinition4.setScriptNSPortVar(null);
        TRANSPORTS = new TransportDefinition[]{transportDefinition, transportDefinition2, transportDefinition3, transportDefinition4};
    }

    private static class PanelCompare
    implements Comparator,
    Serializable {
        private static final int INTRODUCTION_PANEL = 0;
        private static final int SETUP_OPTIONS_PANEL = 1;
        private static final int PLATFORM_DISTRIBUTION_PANEL = 2;
        private static final int PLATFORM_DETAILS_PANEL = 3;
        private static final int ACC_CONFIGURATION_PANEL = 4;
        private static final int DEFAULT_AGENT_PROFILE_PANEL = 5;
        private static final int LOADER_PANEL = 6;
        private static final int PROPERTIES_PANEL = 7;
        private static final int GARBAGE_PANEL = 8;
        private static final int END_PANEL = 8;

        private PanelCompare() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            n = this.getObjectValue(object);
            n3 = n == (n2 = this.getObjectValue(object2)) ? 0 : (n < n2 ? -1 : 1);
            return n3;
        }

        private int getObjectValue(Object object) {
            int n = 0;
            if (object instanceof IntroductionPanel) {
                n = 0;
            } else if (object instanceof SetupOptionsPanel) {
                n = 1;
            } else if (object instanceof PlatformDistribution) {
                n = 2;
            } else if (object instanceof PlatformDetails) {
                n = 3;
            } else if (object instanceof DefaultAgentProfilePanel) {
                n = 5;
            } else if (object instanceof ACCConfiguration) {
                n = 4;
            } else if (object instanceof LoaderPanel) {
                n = 6;
            } else if (object instanceof PropertiesPanel) {
                n = 7;
            } else if (object instanceof GarbageSettingsPanel) {
                n = 8;
            } else if (object instanceof EndPanel) {
                n = 8;
            }
            return n;
        }
    }
}

