/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.AgentDescription;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.profile.RemoteAgentPlatformProfile;
import fipaos.agent.profile.RemoteAgentPlatformProfileImpl;
import fipaos.mts.iiop.sun.external.SUNIIOPComms;
import fipaos.tool.profile.FIPAOSProperties;
import fipaos.tool.wizard.FIPAOSWizard;
import fipaos.tool.wizard.WizardPanel;
import fipaos.tool.wizard.panels.ProgressDialog;
import fipaos.util.DocumentRetriever;
import fipaos.util.URL;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ACCConfiguration
extends JPanel
implements WizardPanel {
    private PlatformProfile _platform_profile;
    private AgentProfile _default_profile;
    private ACCProfile _acc_profile;
    private LoaderProfile _loader_profile;
    private AgentDescription _ams;
    private AgentDescription _df;
    private FIPAOSWizard _parent;
    private Map _setupfipaos;
    private Map _startfipaos;
    private List _ap_names = new LinkedList();
    private List _ap_url = new LinkedList();
    private RAPTableModel _tm = new RAPTableModel();
    private boolean _modified = false;
    private JTable jTable1;
    private JButton jButton2;
    private JButton jButton1;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private JTextArea jTextArea3;

    public ACCConfiguration(FIPAOSWizard fIPAOSWizard) {
        this._parent = fIPAOSWizard;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextArea3 = new JTextArea();
        this.jLabel4 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("What platforms should the ACC look for?");
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setVerticalScrollBarPolicy(20);
        this.jScrollPane1.setHorizontalScrollBarPolicy(30);
        this.jScrollPane1.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        this.jTable1.setModel(this._tm);
        this.jTable1.setAutoResizeMode(4);
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.setSelectionModel(new DefaultListSelectionModel());
        this.jTable1.setPreferredScrollableViewportSize(new Dimension(450, 50));
        this.jScrollPane1.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton1.setText("Add");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACCConfiguration.this.jButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("Remove");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACCConfiguration.this.jButton2ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jButton2, gridBagConstraints);
        this.jTextArea3.setWrapStyleWord(true);
        this.jTextArea3.setLineWrap(true);
        this.jTextArea3.setEditable(false);
        this.jTextArea3.setTabSize(4);
        this.jTextArea3.setText("Here you can specify remote Agent Platforms (RAPs) that this platform will interact with.  The name of the RAPs and an MTP address (i.e. a URL) through which individual RAPs can be contacted should be specified.  Generally this will be an MTP address of a RAP's ACC.\n\nExample MTP addresses:\ncorbaname::my-ap.somedomain.com:4000/NameService#acc\nhttp://my-ap.somedomain.com:8080/acc");
        this.jTextArea3.setAutoscrolls(false);
        this.jTextArea3.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextArea3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabel4, gridBagConstraints);
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        int n = this.jTable1.getSelectedRow();
        if (n >= 0 && n < this._ap_names.size()) {
            this._ap_names.remove(n);
            this._ap_url.remove(n);
            this._modified = true;
            this._tm.notifyChange();
        }
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this._ap_names.add(new String());
        this._ap_url.add(new String());
        this._tm.notifyChange();
    }

    public void resetModified() {
        this._modified = false;
    }

    public void initialise(ACCProfile aCCProfile, AgentProfile agentProfile, LoaderProfile loaderProfile, PlatformProfile platformProfile, Map map, Map map2, FIPAOSProperties fIPAOSProperties) {
        this._acc_profile = aCCProfile;
        this._default_profile = agentProfile;
        this._loader_profile = loaderProfile;
        this._platform_profile = platformProfile;
        this._setupfipaos = map;
        this._startfipaos = map2;
        List list = this._acc_profile.getRemoteAgentPlatformProfiles();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RemoteAgentPlatformProfile remoteAgentPlatformProfile = (RemoteAgentPlatformProfile)iterator.next();
                this._ap_names.add(remoteAgentPlatformProfile.getHAPName());
                this._ap_url.add(remoteAgentPlatformProfile.getAddressesLocation());
            }
        }
    }

    public boolean isOk() {
        try {
            if (this._ap_names.size() > 0) {
                int n = 100 / this._ap_names.size();
                ProgressDialog progressDialog = new ProgressDialog(this._parent, "", "Validating remote address locations", "Starting....");
                LinkedList linkedList = this._acc_profile.getRemoteAgentPlatformProfiles();
                LinkedList<RemoteAgentPlatformProfileImpl> linkedList2 = new LinkedList<RemoteAgentPlatformProfileImpl>();
                int n2 = 0;
                while (n2 < this._ap_names.size()) {
                    RemoteAgentPlatformProfileImpl remoteAgentPlatformProfileImpl = new RemoteAgentPlatformProfileImpl();
                    remoteAgentPlatformProfileImpl.setHAPName((String)this._ap_names.get(n2));
                    remoteAgentPlatformProfileImpl.setAddressesLocation((String)this._ap_url.get(n2));
                    progressDialog.setText("Checking " + (String)this._ap_url.get(n2));
                    if (!this.validate((String)this._ap_names.get(n2), (String)this._ap_url.get(n2))) {
                        progressDialog.dispose();
                        return false;
                    }
                    linkedList2.add(remoteAgentPlatformProfileImpl);
                    progressDialog.setProgress(n2 * n);
                    ++n2;
                }
                boolean bl = false;
                if (linkedList == null) {
                    linkedList = new LinkedList();
                    bl = true;
                } else {
                    linkedList.clear();
                }
                linkedList.addAll(linkedList2);
                if (bl) {
                    int n3 = 0;
                    while (n3 < linkedList.size()) {
                        this._acc_profile.addRemoteAgentPlatformProfile((RemoteAgentPlatformProfile)linkedList.get(n3));
                        ++n3;
                    }
                }
                this._modified = true;
                progressDialog.dispose();
            } else if (this._acc_profile.getRemoteAgentPlatformProfiles() != null) {
                this._acc_profile.getRemoteAgentPlatformProfiles().clear();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return true;
    }

    public boolean isModified() {
        return this._modified;
    }

    private boolean validate(String string, String string2) {
        boolean bl = true;
        if (string2.toLowerCase().startsWith("corbaname")) {
            try {
                bl = SUNIIOPComms.corbaNameResolve(new URL(string2)) != null;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        } else {
            String string3 = DocumentRetriever.getDoc(string2);
            boolean bl2 = bl = string3 != null;
        }
        if (!bl) {
            int n = JOptionPane.showConfirmDialog(this, "The addresses for " + string + " are not accessible!", "", 2);
            bl = n == 0;
        }
        return bl;
    }

    private class RAPTableModel
    implements TableModel {
        private final String[] COLUMN = new String[]{"Remote Platform Name", "MTP Address for Remote Platform"};
        private final Class[] COLUMN_CLASS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RAPTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RAPTableModel.class$("java.lang.String")) : class$java$lang$String};
        private final boolean[] EDITABLE = new boolean[]{true, true};
        private List _listeners = new LinkedList();
        static /* synthetic */ Class class$java$lang$String;

        private RAPTableModel() {
        }

        public String getColumnName(int n) {
            return this.COLUMN[n];
        }

        public Class getColumnClass(int n) {
            return this.COLUMN_CLASS[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return this.EDITABLE[n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    ACCConfiguration.this._ap_names.set(n, object);
                    break;
                }
                case 1: {
                    ACCConfiguration.this._ap_url.set(n, object);
                }
            }
        }

        public int getRowCount() {
            return ACCConfiguration.this._ap_names.size();
        }

        public int getColumnCount() {
            return this.COLUMN.length;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ACCConfiguration.this._ap_names.get(n);
                }
                case 1: {
                    return ACCConfiguration.this._ap_url.get(n);
                }
            }
            return null;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this._listeners.remove(tableModelListener);
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this._listeners.add(tableModelListener);
        }

        public void notifyChange() {
            Iterator iterator = this._listeners.iterator();
            while (iterator.hasNext()) {
                TableModelListener tableModelListener = (TableModelListener)iterator.next();
                tableModelListener.tableChanged(new TableModelEvent(this));
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

