/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.AgentDescription;
import fipaos.agent.profile.AgentDescriptionImpl;
import fipaos.agent.profile.LoaderProfile;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AgentDescriptionDialog
extends JDialog {
    private LoaderProfile _loader_profile;
    private AgentDescription _agent_description;
    private boolean _edit;
    private JTextField txt_owner;
    private JButton btn_ok;
    private JTextField txt_agent_name;
    private JLabel jLabel8;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private JButton btn_cancel;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JTextField txt_class_name;
    private JPanel jPanel1;
    private JComboBox cbo_start;

    public AgentDescriptionDialog(Frame frame, boolean bl, LoaderProfile loaderProfile) {
        super(frame, bl);
        this.initComponents();
        this.centreDlg();
        this._loader_profile = loaderProfile;
        this._agent_description = null;
        this._edit = false;
        this.setTitle("Add Agent Description");
    }

    public AgentDescriptionDialog(Frame frame, boolean bl, AgentDescription agentDescription, LoaderProfile loaderProfile) {
        super(frame, bl);
        this.initComponents();
        this.centreDlg();
        this.setTitle("Edit Agent Description");
        this._agent_description = agentDescription;
        this.txt_class_name.setText(agentDescription.getClassName());
        this.txt_owner.setText(agentDescription.getOwner());
        this.txt_agent_name.setText(agentDescription.getAgentName());
        this._loader_profile = loaderProfile;
        if (agentDescription.getStart()) {
            this.cbo_start.setSelectedIndex(1);
        } else {
            this.cbo_start.setSelectedIndex(0);
        }
        this._edit = true;
    }

    private void centreDlg() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = (toolkit.getScreenSize().width - this.getWidth()) / 2;
        int n2 = (toolkit.getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txt_agent_name = new JTextField();
        this.txt_owner = new JTextField();
        this.txt_class_name = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.cbo_start = new JComboBox();
        this.jPanel2 = new JPanel();
        this.btn_ok = new JButton();
        this.btn_cancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AgentDescriptionDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel8.setText("(select true to start this agent automatically)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel7.setText("(e.g. GenericAgent)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel6.setText("(e.g. fipaos)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel5.setText("(e.g. fipaos.tutorial.GenericAgent)");
        this.jLabel5.setToolTipText("null");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.txt_agent_name.setToolTipText("The name of the agent that is displayed in the agent loader");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.txt_agent_name, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.txt_owner, gridBagConstraints);
        this.txt_class_name.setToolTipText("The full class name of the agent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.txt_class_name, gridBagConstraints);
        this.jLabel4.setText("Start");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel3.setText("Agent Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel2.setText("Owner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel1.setText("Class Name");
        this.jLabel1.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.cbo_start.setModel(new DefaultComboBoxModel<String>(new String[]{"false", "true"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.cbo_start, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btn_ok.setText("OK");
        this.btn_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgentDescriptionDialog.this.btn_okActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.btn_ok, gridBagConstraints);
        this.btn_cancel.setText("Cancel");
        this.btn_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgentDescriptionDialog.this.btn_cancelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.btn_cancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private boolean fieldsValid() {
        return !this.txt_class_name.getText().equals("") && !this.txt_agent_name.getText().equals("") && !this.txt_owner.getText().equals("");
    }

    private void btn_okActionPerformed(ActionEvent actionEvent) {
        if (this.fieldsValid()) {
            List list = this._loader_profile.getAgentDescriptions();
            if (this._edit) {
                this._agent_description.setAgentName(this.txt_agent_name.getText());
                this._agent_description.setClassName(this.txt_class_name.getText());
                this._agent_description.setOwner(this.txt_owner.getText());
                this._agent_description.setStart(this.cbo_start.getSelectedIndex() == 1);
            } else {
                AgentDescriptionImpl agentDescriptionImpl = new AgentDescriptionImpl();
                agentDescriptionImpl.setAgentName(this.txt_agent_name.getText());
                agentDescriptionImpl.setClassName(this.txt_class_name.getText());
                agentDescriptionImpl.setOwner(this.txt_owner.getText());
                agentDescriptionImpl.setStart(this.cbo_start.getSelectedIndex() == 1);
                list.add(agentDescriptionImpl);
            }
            this.closeDialog();
        }
    }

    private void btn_cancelActionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.closeDialog();
    }

    public static void main(String[] stringArray) {
        new AgentDescriptionDialog((Frame)new JFrame(), true, null).show();
    }
}

