/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.DatabaseProfile;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.profile.ProtocolProfile;
import fipaos.agent.profile.TaskManagerProfile;
import fipaos.tool.profile.FIPAOSProperties;
import fipaos.tool.wizard.FIPAOSWizard;
import fipaos.tool.wizard.WizardPanel;
import fipaos.tool.wizard.panels.ManageProtocolMappingsDlg;
import fipaos.tool.wizard.panels.ManageThreadPoolDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DefaultAgentProfilePanel
extends JPanel
implements WizardPanel {
    private DefaultComboBoxModel _dbase_contents;
    private AgentProfile _default_profile;
    private DatabaseProfile _database_profile;
    private ProtocolProfile _protocol_profile;
    private TaskManagerProfile _task_man_profile;
    private boolean _modified = false;
    private boolean _initialised = false;
    private FIPAOSWizard _parent;
    private JComboBox cbo_dbase_type;
    private JButton btn_tm_profile;
    private JTextField txt_dbase_location;
    private JPanel panel3;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private JLabel jLabel31;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JTextArea jTextArea3;
    private JButton btn_browse;
    private JPanel jPanel3;
    private JTextArea jTextArea2;
    private JPanel jPanel2;
    private JTextArea jTextArea1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator1;
    private JButton btn_protocol_profile;
    private JLabel jLabel11;

    public DefaultAgentProfilePanel(FIPAOSWizard fIPAOSWizard) {
        this._parent = fIPAOSWizard;
        this.initComponents();
        this.populateComboBox();
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jTextArea1 = new JTextArea();
        this.jLabel3 = new JLabel();
        this.cbo_dbase_type = new JComboBox();
        this.jLabel31 = new JLabel();
        this.jLabel4 = new JLabel();
        this.txt_dbase_location = new JTextField();
        this.btn_browse = new JButton();
        this.panel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTextArea2 = new JTextArea();
        this.btn_tm_profile = new JButton();
        this.jTextArea3 = new JTextArea();
        this.btn_protocol_profile = new JButton();
        this.jLabel6 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setText("Default Agent Profile Setup");
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel11.setForeground(Color.black);
        this.jLabel11.setFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel3.add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel2.setText("Database Setup");
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText("Sets the databases used by agents for conversation management.  Generally MemoryDatabase is acceptable if conversation history is not required beyond the lifespan of an Agent.  SerializationDatabase should be used if a persistent record of conversations should be kept.");
        this.jTextArea1.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jLabel3.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.cbo_dbase_type.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultAgentProfilePanel.this.cbo_dbase_typeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.cbo_dbase_type, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabel31, gridBagConstraints);
        this.jLabel4.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.txt_dbase_location.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DefaultAgentProfilePanel.this.txt_dbase_locationPropertyChange(propertyChangeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.txt_dbase_location, gridBagConstraints);
        this.btn_browse.setText("Browse");
        this.btn_browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultAgentProfilePanel.this.btn_browseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.btn_browse, gridBagConstraints);
        this.panel3.setLayout(new GridBagLayout());
        this.jLabel5.setText("Advanced Settings");
        this.jLabel5.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panel3.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel3.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panel3, gridBagConstraints);
        this.jTextArea2.setWrapStyleWord(true);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setText("Control the thread pools utilised by the TaskManager in order to execute tasks.");
        this.jTextArea2.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextArea2, gridBagConstraints);
        this.btn_tm_profile.setText("Manage Thread Pool");
        this.btn_tm_profile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultAgentProfilePanel.this.btn_tm_profileActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.btn_tm_profile, gridBagConstraints);
        this.jTextArea3.setWrapStyleWord(true);
        this.jTextArea3.setLineWrap(true);
        this.jTextArea3.setEditable(false);
        this.jTextArea3.setText("Modify the list of conversation protocols that agents can use.  By default this includes most FIPA defined protocols.");
        this.jTextArea3.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextArea3, gridBagConstraints);
        this.btn_protocol_profile.setText("Manage Protocol Mappings");
        this.btn_protocol_profile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultAgentProfilePanel.this.btn_protocol_profileActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.btn_protocol_profile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabel6, gridBagConstraints);
    }

    private void btn_tm_profileActionPerformed(ActionEvent actionEvent) {
        ManageThreadPoolDlg manageThreadPoolDlg = new ManageThreadPoolDlg((Frame)this._parent, true, this._modified, this._task_man_profile);
        manageThreadPoolDlg.show();
    }

    private void btn_protocol_profileActionPerformed(ActionEvent actionEvent) {
        ManageProtocolMappingsDlg manageProtocolMappingsDlg = new ManageProtocolMappingsDlg((Frame)this._parent, true, this._protocol_profile, this._modified);
        manageProtocolMappingsDlg.show();
    }

    private void btn_browseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.txt_dbase_location.setText(file.getAbsolutePath());
        }
    }

    private void txt_dbase_locationPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this._initialised) {
            this._database_profile.setDatabaseLocation(this.txt_dbase_location.getText());
            this._modified = true;
        }
    }

    private void cbo_dbase_typeActionPerformed(ActionEvent actionEvent) {
        if (this._initialised) {
            String string = (String)this.cbo_dbase_type.getSelectedItem();
            this._database_profile.setDatabaseType(string);
            this._modified = true;
        }
    }

    private void populateComboBox() {
        this._dbase_contents = new DefaultComboBoxModel();
        this._dbase_contents.addElement("SerializationDatabase");
        this._dbase_contents.addElement("MemoryDatabase");
        this._dbase_contents.addElement("NoDatabase");
        this.cbo_dbase_type.setModel(this._dbase_contents);
    }

    public boolean isModified() {
        return this._modified;
    }

    public boolean isOk() {
        return true;
    }

    public void resetModified() {
        this._modified = false;
    }

    public void initialise(ACCProfile aCCProfile, AgentProfile agentProfile, LoaderProfile loaderProfile, PlatformProfile platformProfile, Map map, Map map2, FIPAOSProperties fIPAOSProperties) {
        this._default_profile = agentProfile;
        this._database_profile = this._default_profile.getDatabaseProfile();
        this._protocol_profile = this._default_profile.getProtocolProfile();
        this._task_man_profile = this._default_profile.getTaskManagerProfile();
        this.cbo_dbase_type.setSelectedItem(this._default_profile.getDatabaseProfile().getDatabaseType());
        this.txt_dbase_location.setText(this._default_profile.getDatabaseProfile().getDatabaseLocation());
        this._initialised = true;
    }
}

