/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.tool.profile.FIPAOSProperties;
import fipaos.tool.wizard.WizardPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GarbageSettingsPanel
extends JPanel
implements WizardPanel {
    private FIPAOSProperties _fipaos_properties;
    private boolean _modified = false;
    private JSeparator jSeparator311;
    private JLabel jLabel42;
    private JLabel jLabel41;
    private JTextField txt_delay;
    private JLabel jLabel21;
    private JPanel jPanel11;
    private JPanel jPanel111;
    private JTextField txt_limit;
    private JSeparator jSeparator31;
    private JTextArea jTextArea12;
    private JTextArea jTextArea11;
    private JTextField txt_min_delay;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private JLabel jLabel31;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JCheckBox chk_enable_gc;
    private JSeparator jSeparator3;
    private JPanel jPanel1;
    private JTextArea jTextArea1;
    private JLabel jLabel14;
    private JTextField txt_priority;
    private JLabel jLabel11;
    private JTextField txt_aggr_limit;
    private JTextField txt_abs_mem;

    public GarbageSettingsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.chk_enable_gc = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.txt_abs_mem = new JTextField();
        this.txt_priority = new JTextField();
        this.jTextArea1 = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jLabel21 = new JLabel();
        this.txt_limit = new JTextField();
        this.txt_aggr_limit = new JTextField();
        this.jTextArea11 = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jLabel31 = new JLabel();
        this.txt_delay = new JTextField();
        this.txt_min_delay = new JTextField();
        this.jTextArea12 = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jPanel11 = new JPanel();
        this.jSeparator31 = new JSeparator();
        this.jLabel42 = new JLabel();
        this.jPanel111 = new JPanel();
        this.jSeparator311 = new JSeparator();
        this.jLabel41 = new JLabel();
        this.jLabel14 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.chk_enable_gc.setText("Enable Aggressive Garbage Collection");
        this.chk_enable_gc.setFont(new Font("Dialog", 1, 12));
        this.chk_enable_gc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GarbageSettingsPanel.this.chk_enable_gcActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 7, 0, 5);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.chk_enable_gc, gridBagConstraints);
        this.jLabel1.setText("Java VM Memory Level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel11.setText("VM Garbage Collection Thread Priority");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.jLabel11, gridBagConstraints);
        this.txt_abs_mem.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.txt_abs_mem, gridBagConstraints);
        this.txt_priority.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.txt_priority, gridBagConstraints);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText("Java VM Memory Level - Bytes that the VM has to exceed before garbage collecting\nVM Garbage Collection Thread Priority - VM garbage collection thread priority");
        this.jTextArea1.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 0, 5);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jLabel2.setText("Free Memory Limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel21.setText("Reduce Garbage Collection Delay at Limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.jLabel21, gridBagConstraints);
        this.txt_limit.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.txt_limit, gridBagConstraints);
        this.txt_aggr_limit.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.txt_aggr_limit, gridBagConstraints);
        this.jTextArea11.setWrapStyleWord(true);
        this.jTextArea11.setLineWrap(true);
        this.jTextArea11.setEditable(false);
        this.jTextArea11.setText("Free Memory Limit - The fraction of free memory before garbage collection occurs\nMinimum Delay - Limit at which time the delay between garbage collections is reduced\n                  (Both expressed as a value between 0 and 1, e.g. 0.2 = 20% of free memory)");
        this.jTextArea11.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 0, 5);
        this.add((Component)this.jTextArea11, gridBagConstraints);
        this.jLabel3.setText("Garbage Collection Delay");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel31.setText("Garbage Collection Minimum Delay");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.jLabel31, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.txt_delay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.txt_min_delay, gridBagConstraints);
        this.jTextArea12.setWrapStyleWord(true);
        this.jTextArea12.setLineWrap(true);
        this.jTextArea12.setEditable(false);
        this.jTextArea12.setText("GC Delay - Milliseconds between the check on whether garbage collection is needed\nGC Minimum Delay - Minimum delay (in milliseconds) between garbage collection \n                              attempts (if this is very small it can take up a large amount of cpu time)");
        this.jTextArea12.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 0, 5);
        this.add((Component)this.jTextArea12, gridBagConstraints);
        this.jLabel5.setText("                                                                        ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel4.setText("Java VM Settings");
        this.jLabel4.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel11.add((Component)this.jSeparator31, gridBagConstraints);
        this.jLabel42.setText("Memory Limits");
        this.jLabel42.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.jLabel42, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel111.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel111.add((Component)this.jSeparator311, gridBagConstraints);
        this.jLabel41.setText("Garbage Collection Delays");
        this.jLabel41.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel111.add((Component)this.jLabel41, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel111, gridBagConstraints);
        this.jLabel14.setText("Garbage Collection Properties");
        this.jLabel14.setForeground(Color.black);
        this.jLabel14.setFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 11;
        this.add((Component)this.jLabel14, gridBagConstraints);
    }

    private void chk_enable_gcActionPerformed(ActionEvent actionEvent) {
        String string = this.chk_enable_gc.isSelected() ? "true" : "false";
        this._fipaos_properties.setFipaosAggressive_garbage_collect(string);
        this._modified = true;
    }

    public boolean isModified() {
        return this._modified;
    }

    private boolean fieldNotEmpty(JTextField jTextField, String string) {
        if (jTextField.getText().equals("")) {
            JOptionPane.showMessageDialog(this, string);
            return false;
        }
        return true;
    }

    private boolean allFieldsHaveContent() {
        return this.fieldNotEmpty(this.txt_abs_mem, "Please enter a Java VM Memory Level") && this.fieldNotEmpty(this.txt_priority, "Please enter a value for the VM Thread Priority") && this.fieldNotEmpty(this.txt_delay, "Please enter a value for the Garbage Collection Delay") && this.fieldNotEmpty(this.txt_min_delay, "Please enter a value for the Garbage Collection Minimum Delay") && this.fieldNotEmpty(this.txt_limit, "Please enter a value for the Free Memory Limit") && this.fieldNotEmpty(this.txt_aggr_limit, "Please enter a value for the Reduce Garbage Collection Delay Limit");
    }

    private boolean fieldIsInteger(JTextField jTextField, String string) {
        String string2 = jTextField.getText();
        try {
            int n = Integer.decode(string2);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, string);
            return false;
        }
        return true;
    }

    private boolean integerFieldsValid() {
        return this.fieldIsInteger(this.txt_abs_mem, "The Java VM Memory Level is not a valid integer") && this.fieldIsInteger(this.txt_priority, "The VM Thread Priority is not a valid integer") && this.fieldIsInteger(this.txt_delay, "The Garbage Collection Delay is not a valid integer") && this.fieldIsInteger(this.txt_min_delay, "The Garbage Collection Minimum Delay is not a valid integer");
    }

    private boolean fieldIsFloat(JTextField jTextField, String string) {
        String string2 = jTextField.getText();
        try {
            float f = Float.valueOf(string2).floatValue();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, string);
            return false;
        }
        return true;
    }

    private boolean floatFieldsValid() {
        return this.fieldIsFloat(this.txt_limit, "The Free Memory Limit is not a valid float") && this.fieldIsFloat(this.txt_aggr_limit, "The Reduce Garbage Collection Delay Limit is not a valid float");
    }

    public boolean isOk() {
        if (!this.allFieldsHaveContent()) {
            return false;
        }
        if (!this.integerFieldsValid()) {
            return false;
        }
        if (!this.floatFieldsValid()) {
            return false;
        }
        if (!this.txt_abs_mem.getText().equals(this._fipaos_properties.getFipaosGarbageAbs_memory_value())) {
            this._fipaos_properties.setFipaosGarbageAbs_memory_value(this.txt_abs_mem.getText());
            this._modified = true;
        }
        if (!this.txt_priority.getText().equals(this._fipaos_properties.getFipaosGarbagePriority())) {
            this._fipaos_properties.setFipaosGarbagePriority(this.txt_priority.getText());
            this._modified = true;
        }
        if (!this.txt_limit.getText().equals(this._fipaos_properties.getFipaosGarbageLimit())) {
            this._fipaos_properties.setFipaosGarbageLimit(this.txt_limit.getText());
            this._modified = true;
        }
        if (!this.txt_aggr_limit.getText().equals(this._fipaos_properties.getFipaosGarbageMore_aggressive_limit())) {
            this._fipaos_properties.setFipaosGarbageMore_aggressive_limit(this.txt_aggr_limit.getText());
            this._modified = true;
        }
        if (!this.txt_delay.getText().equals(this._fipaos_properties.getFipaosGarbageDelay())) {
            this._fipaos_properties.setFipaosGarbageDelay(this.txt_delay.getText());
            this._modified = true;
        }
        if (!this.txt_min_delay.getText().equals(this._fipaos_properties.getFipaosGarbageMin_delay())) {
            this._fipaos_properties.setFipaosGarbageMin_delay(this.txt_min_delay.getText());
            this._modified = true;
        }
        return true;
    }

    public void resetModified() {
        this._modified = false;
    }

    public void initialise(ACCProfile aCCProfile, AgentProfile agentProfile, LoaderProfile loaderProfile, PlatformProfile platformProfile, Map map, Map map2, FIPAOSProperties fIPAOSProperties) {
        this._fipaos_properties = fIPAOSProperties;
        this.chk_enable_gc.setSelected(this._fipaos_properties.getFipaosAggressive_garbage_collect().equals("true"));
        this.txt_abs_mem.setText(this._fipaos_properties.getFipaosGarbageAbs_memory_value());
        this.txt_priority.setText(this._fipaos_properties.getFipaosGarbagePriority());
        this.txt_limit.setText(this._fipaos_properties.getFipaosGarbageLimit());
        this.txt_aggr_limit.setText(this._fipaos_properties.getFipaosGarbageMore_aggressive_limit());
        this.txt_delay.setText(this._fipaos_properties.getFipaosGarbageDelay());
        this.txt_min_delay.setText(this._fipaos_properties.getFipaosGarbageMin_delay());
    }
}

