/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.AgentDescription;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.tool.profile.FIPAOSProperties;
import fipaos.tool.wizard.FIPAOSWizard;
import fipaos.tool.wizard.WizardPanel;
import fipaos.tool.wizard.panels.AgentDescriptionDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class LoaderPanel
extends JPanel
implements WizardPanel {
    private DefaultListModel _loader_contents;
    private FIPAOSWizard _parent;
    private LoaderProfile _loader_profile;
    private boolean _modified = false;
    private JButton btn_edit;
    private JList lst_loader;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private JButton btn_add;
    private JTextArea jTextArea1;
    private JSeparator jSeparator1;
    private JButton btn_delete;

    public LoaderPanel(FIPAOSWizard fIPAOSWizard) {
        this.initComponents();
        this._parent = fIPAOSWizard;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lst_loader = new JList();
        this.btn_add = new JButton();
        this.btn_edit = new JButton();
        this.btn_delete = new JButton();
        this.jTextArea1 = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Which agents should be displayed in the Agent Loader?");
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this._loader_contents = new DefaultListModel();
        this.lst_loader.setModel(this._loader_contents);
        this.jScrollPane1.setViewportView(this.lst_loader);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btn_add.setText("Add");
        this.btn_add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderPanel.this.btn_addActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.btn_add, gridBagConstraints);
        this.btn_edit.setText("Edit");
        this.btn_edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderPanel.this.btn_editActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.btn_edit, gridBagConstraints);
        this.btn_delete.setText("Remove");
        this.btn_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderPanel.this.btn_deleteActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.btn_delete, gridBagConstraints);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setTabSize(4);
        this.jTextArea1.setText("Here you can manage the agents that are loaded by the Agent Loader.  \nUse this to add new agents to the Agent Loader, edit existing entries, and remove agents from the Agent Loader.");
        this.jTextArea1.setAutoscrolls(false);
        this.jTextArea1.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }

    private void btn_deleteActionPerformed(ActionEvent actionEvent) {
        if (this.lst_loader.getSelectedIndex() >= 0) {
            JOptionPane jOptionPane = new JOptionPane("Are you sure you want to remove this agent from the loader?", 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this._parent, "Remove this agent?");
            jDialog.show();
            Object object = jOptionPane.getValue();
            if (object != null && ((Integer)object).equals(new Integer(0))) {
                int n = this.lst_loader.getSelectedIndex();
                List list = this._loader_profile.getAgentDescriptions();
                list.remove(n);
                this.refreshList();
                this._modified = true;
            }
        }
    }

    private void btn_editActionPerformed(ActionEvent actionEvent) {
        if (this.lst_loader.getSelectedIndex() >= 0) {
            List list = this._loader_profile.getAgentDescriptions();
            AgentDescription agentDescription = (AgentDescription)list.get(this.lst_loader.getSelectedIndex());
            AgentDescriptionDialog agentDescriptionDialog = new AgentDescriptionDialog((Frame)this._parent, true, agentDescription, this._loader_profile);
            agentDescriptionDialog.show();
            this.refreshList();
            this._modified = true;
        }
    }

    private void btn_addActionPerformed(ActionEvent actionEvent) {
        AgentDescriptionDialog agentDescriptionDialog = new AgentDescriptionDialog((Frame)this._parent, true, this._loader_profile);
        agentDescriptionDialog.show();
        this.refreshList();
        this._modified = true;
    }

    public void initialise(ACCProfile aCCProfile, AgentProfile agentProfile, LoaderProfile loaderProfile, PlatformProfile platformProfile, Map map, Map map2, FIPAOSProperties fIPAOSProperties) {
        this._loader_profile = loaderProfile;
        this.refreshList();
    }

    private void refreshList() {
        this._loader_contents.removeAllElements();
        List list = this._loader_profile.getAgentDescriptions();
        int n = 0;
        while (n < list.size()) {
            AgentDescription agentDescription = (AgentDescription)list.get(n);
            this._loader_contents.addElement(agentDescription.getAgentName());
            ++n;
        }
    }

    public boolean isModified() {
        return this._modified;
    }

    public boolean isOk() {
        return true;
    }

    public void resetModified() {
        this._modified = false;
    }
}

