/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.ProtocolMapping;
import fipaos.agent.profile.ProtocolProfile;
import fipaos.tool.wizard.panels.ProtocolMappingDlg;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ManageProtocolMappingsDlg
extends JDialog {
    private ProtocolProfile _protocol_profile;
    private int _list_position;
    private DefaultListModel _list_contents;
    private Frame _parent;
    private boolean _modified;
    private JList lst_protocol_mappings;
    private JButton btn_ok;
    private JButton btn_add_protocol_mapping;
    private JButton btn_edit_protocol_mapping;
    private JButton btn_cancel;
    private JScrollPane jScrollPane1;
    private JButton btn_remove_protocol_mapping;
    private JPanel jPanel2;
    private JPanel jPanel1;

    public ManageProtocolMappingsDlg(Frame frame, boolean bl, ProtocolProfile protocolProfile, boolean bl2) {
        super(frame, bl);
        this.initComponents();
        this.setResizable(true);
        this.centreDlg();
        this._parent = frame;
        this._protocol_profile = protocolProfile;
        this._modified = bl2;
        this.refreshList();
        this.setResizable(false);
    }

    private void refreshList() {
        this._list_contents.removeAllElements();
        List list = this._protocol_profile.getProtocolMappings();
        int n = 0;
        while (n < list.size()) {
            ProtocolMapping protocolMapping = (ProtocolMapping)list.get(n);
            this._list_contents.addElement(protocolMapping.getProtocolName());
            ++n;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lst_protocol_mappings = new JList();
        this.btn_add_protocol_mapping = new JButton();
        this.btn_edit_protocol_mapping = new JButton();
        this.btn_remove_protocol_mapping = new JButton();
        this.jPanel2 = new JPanel();
        this.btn_ok = new JButton();
        this.btn_cancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Protocol Mappings");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManageProtocolMappingsDlg.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this._list_contents = new DefaultListModel();
        this.lst_protocol_mappings.setModel(this._list_contents);
        this.jScrollPane1.setViewportView(this.lst_protocol_mappings);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btn_add_protocol_mapping.setText("Add");
        this.btn_add_protocol_mapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageProtocolMappingsDlg.this.btn_add_protocol_mappingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 11;
        this.jPanel1.add((Component)this.btn_add_protocol_mapping, gridBagConstraints);
        this.btn_edit_protocol_mapping.setText("Edit");
        this.btn_edit_protocol_mapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageProtocolMappingsDlg.this.btn_edit_protocol_mappingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 11;
        this.jPanel1.add((Component)this.btn_edit_protocol_mapping, gridBagConstraints);
        this.btn_remove_protocol_mapping.setText("Remove");
        this.btn_remove_protocol_mapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageProtocolMappingsDlg.this.btn_remove_protocol_mappingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 11;
        this.jPanel1.add((Component)this.btn_remove_protocol_mapping, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.btn_ok.setText("OK");
        this.btn_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageProtocolMappingsDlg.this.btn_okActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.btn_ok);
        this.btn_cancel.setText("Cancel");
        this.btn_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageProtocolMappingsDlg.this.btn_cancelActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.btn_cancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void btn_remove_protocol_mappingActionPerformed(ActionEvent actionEvent) {
        if (this.lst_protocol_mappings.getSelectedIndex() >= 0) {
            JOptionPane jOptionPane = new JOptionPane("Are you sure you want to remove this protocol?", 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this._parent, "Remove this Protocol?");
            jDialog.show();
            Object object = jOptionPane.getValue();
            if (object != null && ((Integer)object).equals(new Integer(0))) {
                int n = this.lst_protocol_mappings.getSelectedIndex();
                List list = this._protocol_profile.getProtocolMappings();
                list.remove(n);
                this.refreshList();
                this._modified = true;
            }
        }
    }

    private void btn_edit_protocol_mappingActionPerformed(ActionEvent actionEvent) {
        if (this.lst_protocol_mappings.getSelectedIndex() >= 0) {
            List list = this._protocol_profile.getProtocolMappings();
            ProtocolMapping protocolMapping = (ProtocolMapping)list.get(this.lst_protocol_mappings.getSelectedIndex());
            ProtocolMappingDlg protocolMappingDlg = new ProtocolMappingDlg(this._parent, true, this._protocol_profile, protocolMapping, this._modified);
            protocolMappingDlg.show();
            this.refreshList();
            this._modified = true;
        }
    }

    private void btn_add_protocol_mappingActionPerformed(ActionEvent actionEvent) {
        ProtocolMappingDlg protocolMappingDlg = new ProtocolMappingDlg(this._parent, true, this._protocol_profile, this._modified);
        protocolMappingDlg.show();
        this.refreshList();
        this._modified = true;
    }

    private void btn_okActionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void btn_cancelActionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void centreDlg() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = (toolkit.getScreenSize().width - this.getWidth()) / 2;
        int n2 = (toolkit.getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.closeDialog();
    }

    public static void main(String[] stringArray) {
    }
}

