/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.TaskManagerProfile;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ManageThreadPoolDlg
extends JDialog {
    private boolean _modified;
    private TaskManagerProfile _task_man_profile;
    private JButton btn_ok;
    private JTextField txt_number_threads;
    private JButton btn_cancel;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JComboBox cbo_global_threads;

    public ManageThreadPoolDlg(Frame frame, boolean bl, boolean bl2, TaskManagerProfile taskManagerProfile) {
        super(frame, bl);
        this.initComponents();
        this.setResizable(true);
        this.centreDlg();
        this._modified = bl2;
        this._task_man_profile = taskManagerProfile;
        int n = this._task_man_profile.getLocalThreads();
        this.txt_number_threads.setText(String.valueOf(n));
        boolean bl3 = this._task_man_profile.getUseGlobalThreads();
        if (bl3) {
            this.cbo_global_threads.setSelectedIndex(1);
        } else {
            this.cbo_global_threads.setSelectedIndex(0);
        }
        this.setResizable(false);
    }

    private void centreDlg() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = (toolkit.getScreenSize().width - this.getWidth()) / 2;
        int n2 = (toolkit.getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txt_number_threads = new JTextField();
        this.cbo_global_threads = new JComboBox();
        this.jPanel2 = new JPanel();
        this.btn_ok = new JButton();
        this.btn_cancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Manage Thread Pool");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManageThreadPoolDlg.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Number of Local Threads");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Use Global Threads");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel1.add((Component)this.txt_number_threads, gridBagConstraints);
        this.cbo_global_threads.setModel(new DefaultComboBoxModel<String>(new String[]{"No", "Yes"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel1.add((Component)this.cbo_global_threads, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btn_ok.setText("OK");
        this.btn_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageThreadPoolDlg.this.btn_okActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add((Component)this.btn_ok, new GridBagConstraints());
        this.btn_cancel.setText("Cancel");
        this.btn_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageThreadPoolDlg.this.btn_cancelActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add((Component)this.btn_cancel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private boolean fieldsValid() {
        String string = this.txt_number_threads.getText();
        if (!string.equals("")) {
            try {
                Integer n = Integer.decode(string);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    private void btn_okActionPerformed(ActionEvent actionEvent) {
        if (this.fieldsValid()) {
            this._task_man_profile.setUseGlobalThreads(this.cbo_global_threads.getSelectedIndex() == 1);
            this._task_man_profile.setLocalThreads(Integer.decode(this.txt_number_threads.getText()));
            this._modified = true;
            this.closeDialog();
        }
    }

    private void btn_cancelActionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.closeDialog();
    }

    public static void main(String[] stringArray) {
    }
}

