/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.AgentDescription;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.InternalAddress;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.tool.profile.FIPAOSProperties;
import fipaos.tool.wizard.FIPAOSWizard;
import fipaos.tool.wizard.TransportDefinition;
import fipaos.tool.wizard.WizardPanel;
import fipaos.tool.wizard.panels.NamingServicePorts;
import fipaos.tool.wizard.panels.PlatformDistribution;
import fipaos.util.URL;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PlatformDetails
extends JPanel
implements WizardPanel {
    private PlatformProfile _platform_profile;
    private AgentProfile _default_profile;
    private ACCProfile _acc_profile;
    private LoaderProfile _loader_profile;
    private AgentDescription _ams;
    private AgentDescription _df;
    private PlatformDetails _platform_details;
    private FIPAOSWizard _parent;
    private PlatformDistribution _platform_distribution;
    private Map _setupfipaos;
    private Map _startfipaos;
    private boolean _modified = false;
    private JButton _advanced;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JTextArea jTextArea3;
    private JTextField _ns_host;
    private JTextArea jTextArea1;
    private JTextField _hap;

    public PlatformDetails(FIPAOSWizard fIPAOSWizard, PlatformDistribution platformDistribution) {
        this._parent = fIPAOSWizard;
        this._platform_distribution = platformDistribution;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this._hap = new JTextField();
        this.jTextArea1 = new JTextArea();
        this.jLabel3 = new JLabel();
        this._ns_host = new JTextField();
        this.jTextArea3 = new JTextArea();
        this._advanced = new JButton();
        this.jLabel4 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("What are the details of the Agent Platform?");
        this.jLabel1.setForeground(Color.black);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Platform name");
        this.jLabel2.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._hap, gridBagConstraints);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setTabSize(4);
        this.jTextArea1.setText("This should be the name of the computer that will run the Naming Services for the Agent Platform that this installation is part of.  Please do not use \"localhost\" or other potentially ambiguous host names");
        this.jTextArea1.setAutoscrolls(false);
        this.jTextArea1.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jLabel3.setText("Host running Naming Services");
        this.jLabel3.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._ns_host, gridBagConstraints);
        this.jTextArea3.setWrapStyleWord(true);
        this.jTextArea3.setLineWrap(true);
        this.jTextArea3.setEditable(false);
        this.jTextArea3.setTabSize(4);
        this.jTextArea3.setText("This is the name of the Agent Platform that this installation of FIPA-OS will be part of.  It should be globally unique if this platform needs to interact with other platforms - FIPA recommends the use of a fully-qualified hostname for this purpose (e.g. myhost.mydomain.com)");
        this.jTextArea3.setAutoscrolls(false);
        this.jTextArea3.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextArea3, gridBagConstraints);
        this._advanced.setText("Advanced...");
        this._advanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlatformDetails.this._advancedActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 14;
        this.add((Component)this._advanced, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabel4, gridBagConstraints);
    }

    private void _advancedActionPerformed(ActionEvent actionEvent) {
        NamingServicePorts namingServicePorts = new NamingServicePorts(this._parent, this._acc_profile, this._platform_profile, this._default_profile, this);
        this._modified |= namingServicePorts.isModified();
    }

    public void resetModified() {
        this._modified = false;
    }

    public void initialise(ACCProfile aCCProfile, AgentProfile agentProfile, LoaderProfile loaderProfile, PlatformProfile platformProfile, Map map, Map map2, FIPAOSProperties fIPAOSProperties) {
        this._acc_profile = aCCProfile;
        this._default_profile = agentProfile;
        this._loader_profile = loaderProfile;
        this._platform_profile = platformProfile;
        this._setupfipaos = map;
        this._startfipaos = map2;
        this._hap.setText(this._platform_profile.getHAPName());
        try {
            URL uRL = new URL(((InternalAddress)this._default_profile.getInternalAddresss().get(0)).getAddress());
            this._ns_host.setText(uRL.getHost());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isOk() {
        int n;
        String string;
        String string2;
        block9: {
            string2 = this._hap.getText();
            if (string2.equals("")) {
                JOptionPane.showMessageDialog(this, "Please enter a name for the Agent Platform");
                return false;
            }
            if (string2.equals("localap")) {
                JOptionPane.showMessageDialog(this, "Please enter a different name for the Agent Platform");
                return false;
            }
            if (string2.indexOf(" ") > -1) {
                JOptionPane.showMessageDialog(this, "Agent Platform name shouldn't contain spaces");
                return false;
            }
            string = this._ns_host.getText();
            if (string.equalsIgnoreCase("localhost")) {
                JOptionPane.showMessageDialog(this, "Please change the Naming Service host to something other than \"localhost\"");
                return false;
            }
            if (string.equals("")) {
                JOptionPane.showMessageDialog(this, "Please specify a Naming Service host");
                return false;
            }
            try {
                InetAddress.getByName(string);
            }
            catch (Throwable throwable) {
                n = JOptionPane.showConfirmDialog(this, "The Naming Service host specified is not reachable!", "", 2);
                if (n == 0) break block9;
                return false;
            }
        }
        if (!this._platform_profile.getHAPName().equals(string2)) {
            this._platform_profile.setHAPName(string2);
            this._modified = true;
        }
        this._platform_distribution.setNSHost(string);
        n = 0;
        while (n < FIPAOSWizard.TRANSPORTS.length) {
            TransportDefinition transportDefinition = FIPAOSWizard.TRANSPORTS[n];
            this._platform_distribution.setNSPort(transportDefinition.getName(), transportDefinition.getNSPort());
            this.updateScriptVar(this._startfipaos, transportDefinition.getName(), "" + transportDefinition.getNSPort());
            ++n;
        }
        return true;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void updateScriptVar(Map map, String string, String string2) {
        String string3 = (String)map.get(string);
        if (string3 != null && !string3.equals(string2)) {
            map.put(string, string2);
            this._modified = true;
        }
    }
}

