/*
 * Decompiled with CFR 0.152.
 */
package fipaos.tool.wizard.panels;

import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.AgentDescription;
import fipaos.agent.profile.AgentDescriptionImpl;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.ExternalAddress;
import fipaos.agent.profile.InternalAddress;
import fipaos.agent.profile.LoaderProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.tool.profile.FIPAOSProperties;
import fipaos.tool.wizard.FIPAOSWizard;
import fipaos.tool.wizard.TransportDefinition;
import fipaos.tool.wizard.WizardPanel;
import fipaos.tool.wizard.panels.ACCConfiguration;
import fipaos.tool.wizard.panels.PlatformDetails;
import fipaos.util.URL;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PlatformDistribution
extends JPanel
implements WizardPanel {
    private ButtonGroup _bg = new ButtonGroup();
    private PlatformProfile _platform_profile;
    private AgentProfile _default_profile;
    private ACCProfile _acc_profile;
    private LoaderProfile _loader_profile;
    private AgentDescription _ams;
    private AgentDescription _df;
    private PlatformDetails _platform_details;
    private ACCConfiguration _acc_conf;
    private FIPAOSWizard _parent;
    private Map _setupfipaos;
    private Map _startfipaos;
    private boolean _modified = false;
    private JRadioButton _standalone;
    private JCheckBox _start_acc;
    private JCheckBox _start_ns;
    private JCheckBox _start_ams_and_df;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JTextArea jTextArea5;
    private JLabel jLabel1;
    private JTextArea jTextArea4;
    private JTextArea jTextArea3;
    private JTextArea jTextArea2;
    private JTextArea jTextArea1;
    private JRadioButton _dist_platform;

    public PlatformDistribution(FIPAOSWizard fIPAOSWizard) {
        this._parent = fIPAOSWizard;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this._standalone = new JRadioButton();
        this._dist_platform = new JRadioButton();
        this._start_ns = new JCheckBox();
        this._start_ams_and_df = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.jTextArea2 = new JTextArea();
        this.jTextArea3 = new JTextArea();
        this.jTextArea4 = new JTextArea();
        this._start_acc = new JCheckBox();
        this.jTextArea5 = new JTextArea();
        this.jLabel4 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("How should this installation of FIPA-OS be configured?");
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this._standalone.setToolTipText("");
        this._standalone.setText("As a stand-alone platform");
        this._standalone.setFont(new Font("Dialog", 1, 12));
        this._bg.add(this._standalone);
        this._standalone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlatformDistribution.this.jRadioButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this._standalone, gridBagConstraints);
        this._dist_platform.setToolTipText("");
        this._dist_platform.setText("As part of a distributed platform / to interoperate with other platforms");
        this._dist_platform.setFont(new Font("Dialog", 1, 12));
        this._bg.add(this._dist_platform);
        this._dist_platform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlatformDistribution.this._dist_platformActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this._dist_platform, gridBagConstraints);
        this._start_ns.setToolTipText("");
        this._start_ns.setLabel("Start platform NamingServices here");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this._start_ns, gridBagConstraints);
        this._start_ams_and_df.setToolTipText("");
        this._start_ams_and_df.setLabel("Start platform agents (AMS & DF) here");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this._start_ams_and_df, gridBagConstraints);
        this.jLabel2.setText("      ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("      ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setTabSize(4);
        this.jTextArea1.setText("Select this option if you plan to use FIPA-OS in isolation on this computer.  This is the simplest option, since the majority of configuration will be done automatically");
        this.jTextArea1.setAutoscrolls(false);
        this.jTextArea1.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea2.setWrapStyleWord(true);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setTabSize(4);
        this.jTextArea2.setText("Select this option if you wish to use this installation of FIPA-OS as part of an Agent Platform which spans several computers, and/or interacts with other FIPA platforms.  In this case one of the computers that are part of the AgentPlatform must run the Naming Services for the platform, and one must run the AMS and DF agents");
        this.jTextArea2.setAutoscrolls(false);
        this.jTextArea2.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextArea2, gridBagConstraints);
        this.jTextArea3.setWrapStyleWord(true);
        this.jTextArea3.setLineWrap(true);
        this.jTextArea3.setEditable(false);
        this.jTextArea3.setTabSize(4);
        this.jTextArea3.setText("Select this to start the Agent Platform Naming Services on this computer");
        this.jTextArea3.setAutoscrolls(false);
        this.jTextArea3.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextArea3, gridBagConstraints);
        this.jTextArea4.setWrapStyleWord(true);
        this.jTextArea4.setLineWrap(true);
        this.jTextArea4.setEditable(false);
        this.jTextArea4.setTabSize(4);
        this.jTextArea4.setText("Select this to start the AMS and DF for the Agent Platform here");
        this.jTextArea4.setAutoscrolls(false);
        this.jTextArea4.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextArea4, gridBagConstraints);
        this._start_acc.setToolTipText("");
        this._start_acc.setText("Start platform ACC here");
        this._start_acc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlatformDistribution.this.jCheckBox1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this._start_acc, gridBagConstraints);
        this.jTextArea5.setWrapStyleWord(true);
        this.jTextArea5.setLineWrap(true);
        this.jTextArea5.setEditable(false);
        this.jTextArea5.setTabSize(4);
        this.jTextArea5.setText("Select this to start the ACC for the Agent Platform here (the ACC is only needed if your platform will interact with other Agent Platforms)");
        this.jTextArea5.setAutoscrolls(false);
        this.jTextArea5.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextArea5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabel4, gridBagConstraints);
    }

    private void jCheckBox1ActionPerformed(ActionEvent actionEvent) {
        if (this._start_acc.isSelected() && !this._standalone.isSelected()) {
            if (this._acc_conf == null) {
                this._acc_conf = new ACCConfiguration(this._parent);
                this._parent.insertPanel(this._platform_details, this._acc_conf);
            }
        } else if (this._acc_conf != null) {
            this._parent.removePanel(this._acc_conf);
            this._acc_conf = null;
        }
    }

    private void _dist_platformActionPerformed(ActionEvent actionEvent) {
        this.setupComponents(false);
        this.jCheckBox1ActionPerformed(null);
    }

    private void jRadioButton1ActionPerformed(ActionEvent actionEvent) {
        this.setupComponents(true);
        this.jCheckBox1ActionPerformed(null);
    }

    private void setupComponents(boolean bl) {
        this._start_ams_and_df.setEnabled(!bl);
        this._start_ns.setEnabled(!bl);
        this._start_acc.setEnabled(!bl);
        if (bl) {
            if (this._platform_details != null) {
                this._parent.removePanel(this._platform_details);
                this._platform_details = null;
            }
        } else if (this._platform_details == null) {
            this._platform_details = new PlatformDetails(this._parent, this);
            this._parent.insertPanel(this, this._platform_details);
        }
    }

    private void setupComponents(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._standalone.setSelected(bl);
        this._dist_platform.setSelected(!bl);
        this._start_ams_and_df.setSelected(bl3);
        this._start_ns.setSelected(bl2);
        this._start_acc.setSelected(bl4);
        this.setupComponents(bl);
        if (bl4 && !bl) {
            if (this._acc_conf == null) {
                this._acc_conf = new ACCConfiguration(this._parent);
                this._parent.insertPanel(this._platform_details, this._acc_conf);
            }
        } else if (this._acc_conf != null) {
            this._parent.removePanel(this._acc_conf);
            this._acc_conf = null;
        }
    }

    public void resetModified() {
        this._modified = false;
    }

    public void initialise(ACCProfile aCCProfile, AgentProfile agentProfile, LoaderProfile loaderProfile, PlatformProfile platformProfile, Map map, Map map2, FIPAOSProperties fIPAOSProperties) {
        this._acc_profile = aCCProfile;
        this._default_profile = agentProfile;
        this._loader_profile = loaderProfile;
        this._platform_profile = platformProfile;
        this._setupfipaos = map;
        this._startfipaos = map2;
        List list = this._loader_profile.getAgentDescriptions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AgentDescription agentDescription = (AgentDescription)iterator.next();
            if (agentDescription.getAgentName().equalsIgnoreCase("ams")) {
                this._ams = agentDescription;
                continue;
            }
            if (!agentDescription.getAgentName().equalsIgnoreCase("df")) continue;
            this._df = agentDescription;
        }
        if (this._ams == null) {
            this._ams = new AgentDescriptionImpl();
            this._ams.setAgentName("ams");
            this._ams.setClassName("fipaos.platform.AgentManagementSystem");
            this._ams.setOwner("fipaos");
            this._ams.setStart(false);
            this._loader_profile.addAgentDescription(this._ams);
            this._modified = true;
        }
        if (this._df == null) {
            this._df = new AgentDescriptionImpl();
            this._df.setAgentName("df");
            this._df.setClassName("fipaos.platform.DirectoryFacilitator");
            this._df.setOwner("fipaos");
            this._df.setStart(false);
            this._loader_profile.addAgentDescription(this._df);
            this._modified = true;
        }
        boolean bl = this._platform_profile.getHAPName().equals("localap");
        boolean bl2 = this._ams.getStart() && this._df.getStart();
        boolean bl3 = false;
        int n = 0;
        while (n < FIPAOSWizard.TRANSPORTS.length) {
            TransportDefinition transportDefinition = FIPAOSWizard.TRANSPORTS[n];
            if (transportDefinition.getScriptNSEnableVar() != null) {
                bl3 = true;
            }
            ++n;
        }
        boolean bl4 = !((String)this._startfipaos.get("STARTACC")).equals("");
        this.setupComponents(bl, bl3, bl2, bl4);
    }

    public boolean isOk() {
        boolean bl;
        Object object;
        if (this._standalone.isSelected()) {
            if (this._platform_profile.getHAPName() == null || !this._platform_profile.getHAPName().equals("localap")) {
                this._platform_profile.setHAPName("localap");
                this._modified = true;
            }
            int n = 0;
            while (n < FIPAOSWizard.TRANSPORTS.length) {
                String string = null;
                object = FIPAOSWizard.TRANSPORTS[n];
                if (((TransportDefinition)object).getScriptNSEnableVar() != null) {
                    string = ((TransportDefinition)object).getExternal() ? "" : "yes";
                    this.updateScriptVar(this._startfipaos, ((TransportDefinition)object).getScriptNSEnableVar(), string);
                    string = "" + ((TransportDefinition)object).getNSPort();
                    this.updateScriptVar(this._startfipaos, ((TransportDefinition)object).getScriptNSPortVar(), string);
                }
                this.setNSPort(((TransportDefinition)object).getName(), ((TransportDefinition)object).getNSPort());
                ++n;
            }
            this.setNSHost("localhost");
            this.updateScriptVar(this._startfipaos, "STARTACC", "");
        } else {
            String string;
            object = this._start_ns.isSelected() ? "yes" : "";
            int n = 0;
            while (n < FIPAOSWizard.TRANSPORTS.length) {
                TransportDefinition transportDefinition = FIPAOSWizard.TRANSPORTS[n];
                if (transportDefinition.getScriptNSEnableVar() != null) {
                    this.updateScriptVar(this._startfipaos, transportDefinition.getScriptNSEnableVar(), (String)object);
                    string = "" + transportDefinition.getNSPort();
                    this.updateScriptVar(this._startfipaos, transportDefinition.getScriptNSPortVar(), string);
                }
                this.setNSPort(transportDefinition.getName(), transportDefinition.getNSPort());
                ++n;
            }
            string = this._start_acc.isSelected() ? "yes" : "";
            this.updateScriptVar(this._startfipaos, "STARTACC", string);
        }
        boolean bl2 = bl = this._standalone.isSelected() || this._start_ams_and_df.isSelected();
        if (this._df.getStart() != bl) {
            this._df.setStart(bl);
            this._modified = true;
        }
        if (this._ams.getStart() != bl) {
            this._ams.setStart(bl);
            this._modified = true;
        }
        this._parent.sortPanels();
        return true;
    }

    public void updateScriptVar(Map map, String string, String string2) {
        String string3 = (String)map.get(string);
        if (string3 != null && !string3.equals(string2)) {
            map.put(string, string2);
            this._modified = true;
        }
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setNSHost(String string) {
        List list = this._acc_profile.getInternalAddresss();
        if (list == null) {
            list = new LinkedList();
        }
        this.setNSHost(string, list);
        list = this._acc_profile.getExternalAddresss();
        if (list == null) {
            list = new LinkedList();
        }
        this.setNSHost(string, list);
        list = this._default_profile.getInternalAddresss();
        if (list == null) {
            list = new LinkedList();
        }
        this.setNSHost(string, list);
        URL uRL = new URL(this._platform_profile.getAMSAddress());
        if (!uRL.getHost().equalsIgnoreCase(string)) {
            uRL.setHost(string);
            this._platform_profile.setAMSAddress(uRL.toString());
            this._modified = true;
        }
    }

    public void setNSPort(String string, int n) {
        List list = this._acc_profile.getInternalAddresss();
        if (list == null) {
            list = new LinkedList();
        }
        this.setNSPort(string, n, list);
        list = this._acc_profile.getExternalAddresss();
        if (list == null) {
            list = new LinkedList();
        }
        this.setNSPort(string, n, list);
        list = this._default_profile.getInternalAddresss();
        if (list == null) {
            list = new LinkedList();
        }
        this.setNSPort(string, n, list);
        URL uRL = new URL(this._platform_profile.getAMSAddress());
        if (uRL.getProtocol().equalsIgnoreCase(string) && uRL.getPort() != n) {
            uRL.setPort(n);
            this._platform_profile.setAMSAddress(uRL.toString());
            this._modified = true;
        }
    }

    private void setNSHost(String string, List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string2 = null;
            if (e instanceof InternalAddress) {
                string2 = ((InternalAddress)e).getAddress();
            } else if (e instanceof ExternalAddress) {
                string2 = ((ExternalAddress)e).getAddress();
            }
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (uRL == null || uRL.getHost().equalsIgnoreCase(string)) continue;
            uRL.setHost(string);
            if (e instanceof InternalAddress) {
                ((InternalAddress)e).setAddress(uRL.toString());
            } else if (e instanceof ExternalAddress) {
                ((ExternalAddress)e).setAddress(uRL.toString());
            }
            this._modified = true;
        }
    }

    private void setNSPort(String string, int n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string2 = null;
            if (e instanceof InternalAddress) {
                string2 = ((InternalAddress)e).getAddress();
            } else if (e instanceof ExternalAddress) {
                string2 = ((ExternalAddress)e).getAddress();
            }
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (uRL == null || !uRL.getProtocol().equalsIgnoreCase(string) || uRL.getPort() == n) continue;
            uRL.setPort(n);
            if (e instanceof InternalAddress) {
                ((InternalAddress)e).setAddress(uRL.toString());
            } else if (e instanceof ExternalAddress) {
                ((ExternalAddress)e).setAddress(uRL.toString());
            }
            this._modified = true;
        }
    }
}

