/*
 * Decompiled with CFR 0.152.
 */
package fipaos.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class FlagHandler
implements Serializable {
    private BitSet _bits;
    private List _names = new ArrayList();
    private Hashtable _mx = new Hashtable();

    public FlagHandler() {
        this._bits = new BitSet();
    }

    public synchronized boolean addFlag(String string) {
        if (this._names.contains(string)) {
            return false;
        }
        this._names.add(string);
        return true;
    }

    public synchronized boolean addFlag(String string, String string2) {
        if (this._names.contains(string)) {
            return false;
        }
        MXFlags mXFlags = new MXFlags();
        mXFlags.addMXFlag(string2);
        this._mx.put(string, mXFlags);
        this._names.add(string);
        return true;
    }

    public synchronized boolean addFlag(String string, String[] stringArray) {
        if (this._names.contains(string)) {
            return false;
        }
        MXFlags mXFlags = new MXFlags();
        int n = 0;
        while (n < stringArray.length) {
            mXFlags.addMXFlag(stringArray[n]);
            ++n;
        }
        this._mx.put(string, mXFlags);
        this._names.add(string);
        return true;
    }

    public synchronized void setFlag(String string) {
        if (this._names.contains(string)) {
            int n = this._names.indexOf(string);
            this._bits.set(n);
            if (this._mx.containsKey(string)) {
                String[] stringArray = ((MXFlags)this._mx.get(string)).getMXFlags();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.clearFlag(stringArray[n2]);
                    ++n2;
                }
            }
        }
    }

    public synchronized void clearFlag(String string) {
        if (this._names.contains(string)) {
            int n = this._names.indexOf(string);
            this._bits.clear(n);
        }
    }

    public synchronized boolean testFlag(String string) {
        if (this._names.contains(string)) {
            int n = this._names.indexOf(string);
            return this._bits.get(n);
        }
        return false;
    }

    public synchronized void toggleFlag(String string) {
        if (this._names.contains(string)) {
            if (this.testFlag(string)) {
                this.clearFlag(string);
            } else {
                this.setFlag(string);
            }
        }
    }

    public boolean containsFlag(String string) {
        return this._names.contains(string);
    }

    public synchronized void clearAllFlags() {
        Iterator iterator = this._names.iterator();
        while (iterator.hasNext()) {
            this.clearFlag((String)iterator.next());
        }
    }

    public int getNumberOfFlags() {
        return this._names.size();
    }

    public synchronized void setMutualExclusions(String string, String[] stringArray) {
        if (this._names.contains(string)) {
            MXFlags mXFlags = (MXFlags)this._mx.get(string);
            int n = 0;
            while (n < stringArray.length) {
                mXFlags.addMXFlag(stringArray[n]);
                ++n;
            }
        }
    }

    public String toString() {
        Iterator iterator = this._names.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("Flag ");
            stringBuffer.append(string);
            stringBuffer.append(" is ");
            if (this.testFlag(string)) {
                stringBuffer.append("TRUE\n");
                continue;
            }
            stringBuffer.append("FALSE\n");
        }
        return stringBuffer.toString();
    }

    private class MXFlags
    implements Serializable {
        private List _mx = new ArrayList();

        private MXFlags() {
        }

        private void addMXFlag(String string) {
            if (!this._mx.contains(string)) {
                this._mx.add(string);
            }
        }

        private String[] getMXFlags() {
            return this._mx.toArray(new String[0]);
        }
    }
}

