/*
 * Decompiled with CFR 0.152.
 */
package fipaos.util;

import fipaos.util.FIFOQueue;
import fipaos.util.Monitor;
import fipaos.util.MonitorListener;
import fipaos.util.Queue;
import java.util.Enumeration;
import java.util.Vector;

public class MultiThreadedMonitor
extends Monitor
implements MonitorListener {
    private Vector _receivers = new Vector();
    private Monitor[] _monitors;
    private Queue[] _queues;
    private int _next = 0;

    public MultiThreadedMonitor(Queue queue, int n) {
        super(queue, null);
        this._target = this;
        this._monitors = new Monitor[n];
        this._queues = new Queue[n];
        int n2 = 0;
        while (n2 < n) {
            FIFOQueue fIFOQueue = new FIFOQueue();
            this._queues[n2] = fIFOQueue;
            this._monitors[n2] = new Monitor(fIFOQueue, new MonitorListener(){

                public void monitorUpdate(Object object) {
                    Object[] objectArray = (Object[])object;
                    Object object2 = objectArray[0];
                    MonitorListener monitorListener = (MonitorListener)objectArray[1];
                    monitorListener.monitorUpdate(object2);
                }
            });
            ++n2;
        }
    }

    public synchronized void monitorUpdate(Object object) {
        Enumeration enumeration = this._receivers.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = new Object[]{object, enumeration.nextElement()};
            this._queues[this._next].addItem(objectArray);
            this._next = (this._next + 1) % this._queues.length;
        }
    }

    public synchronized void addMonitorListener(MonitorListener monitorListener) {
        this._receivers.addElement(monitorListener);
    }

    public synchronized void removeMonitorListener(MonitorListener monitorListener) {
        this._receivers.remove(monitorListener);
    }

    public void halt() {
        super.halt();
        int n = 0;
        while (n < this._monitors.length) {
            this._monitors[n].halt();
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        int n = 10;
        int n2 = 50;
        int n3 = 5;
        FIFOQueue fIFOQueue = new FIFOQueue();
        MultiThreadedMonitor multiThreadedMonitor = new MultiThreadedMonitor((Queue)fIFOQueue, n);
        int n4 = 0;
        while (n4 < n3) {
            multiThreadedMonitor.addMonitorListener(new Monitor.MonitorListenerTest(n4));
            ++n4;
        }
        int n5 = 0;
        while (n5 < n2) {
            String string = "Msg. No. " + n5;
            fIFOQueue.addItem(string);
            ++n5;
        }
    }
}

