/*
 * Decompiled with CFR 0.152.
 */
package fipaos.util;

import java.lang.reflect.Constructor;
import java.util.Vector;

public abstract class Queue {
    protected Vector _queue = new Vector();
    private int _max;
    private boolean _block = true;

    protected Queue(int n) {
        this._max = n;
    }

    public int queueLength() {
        return this._queue.size();
    }

    public synchronized void addItem(Object object) {
        if (!this.isFull()) {
            this._queue.addElement(object);
            this.notify();
        }
    }

    public synchronized Object getItem() {
        while (this._queue.isEmpty() && this._block) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getNextItem();
    }

    public synchronized Object getItemWithoutBlocking() {
        return this.getNextItem();
    }

    public synchronized boolean isFull() {
        return this._max != -1 && this._queue.size() >= this._max;
    }

    public synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    public synchronized void flush() {
        this._queue.clear();
    }

    public synchronized void releaseBlock() {
        this._block = false;
        this.notifyAll();
    }

    protected abstract Object getNextItem();

    public static void main(String[] stringArray) throws Throwable {
        String[] stringArray2 = new String[]{"fipaos.util.FIFOQueue", "fipaos.util.LIFOQueue"};
        Class[] classArray = new Class[]{Integer.TYPE};
        Object[] objectArray = new Object[]{new Integer(10)};
        int n = 0;
        while (n < objectArray.length) {
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            Class<?> clazz = Class.forName(stringArray2[n2]);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Queue queue = (Queue)constructor.newInstance(objectArray);
            int n3 = 1;
            while (n3 <= 20) {
                queue.addItem(new Integer(n3));
                ++n3;
            }
            while (!queue.isEmpty()) {
            }
            ++n2;
        }
    }
}

