/*
 * Decompiled with CFR 0.152.
 */
package fipaos.util;

import fipaos.util.FIFOQueue;
import fipaos.util.Queue;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ThreadPool
implements Runnable {
    private static ThreadPool __global_thread_pool;
    private static Set __all_thread_pools;
    private List _threads;
    private Queue _jobs;
    private boolean _shutdown;
    private int _active = 0;
    private long _total_active = 0L;
    private long _total_inactive = 0L;
    private String _name;
    private int _no_global_threads = 10;

    public ThreadPool(int n, String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Properties properties = new Properties();
        try {
            properties.load(classLoader.getResourceAsStream("fipa-os.properties"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string2 = properties.getProperty("no_global_threads", "10");
        if (string2 != null) {
            this._no_global_threads = Integer.valueOf(string2);
        }
        this._name = string;
        this._threads = new LinkedList();
        this._jobs = new FIFOQueue();
        int n2 = 0;
        while (n2 < n) {
            TPThread tPThread = new TPThread((Runnable)this, string + "-" + n2);
            this._threads.add(tPThread);
            tPThread.start();
            ++n2;
        }
        __all_thread_pools.add(this);
    }

    public void run() {
        long l;
        long l2 = l = System.currentTimeMillis();
        while (!this._shutdown) {
            Object object;
            Object[] objectArray = (Object[])this._jobs.getItem();
            l2 = System.currentTimeMillis();
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                ++this._active;
                this._total_inactive += l2 - l;
            }
            if (objectArray != null) {
                ThreadGroup threadGroup;
                object = (Job)objectArray[0];
                ((TPThread)Thread.currentThread())._parent_thread_group = threadGroup = (ThreadGroup)objectArray[1];
                try {
                    object.go();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object = null;
                objectArray[0] = null;
                objectArray[1] = null;
                objectArray = null;
            }
            l = System.currentTimeMillis();
            object = this;
            synchronized (object) {
                --this._active;
                this._total_active += l - l2;
            }
        }
    }

    public synchronized void addJob(Job job) {
        if (!this._shutdown) {
            this._jobs.addItem(new Object[]{job, Thread.currentThread().getThreadGroup()});
        }
    }

    public synchronized void shutdown() {
        if (!this._shutdown) {
            this._shutdown = true;
            this._jobs.releaseBlock();
            __all_thread_pools.remove(this);
        }
    }

    public String getName() {
        return this._name;
    }

    public synchronized int getActiveThreadCount() {
        return this._active;
    }

    public int getThreadCount() {
        return this._threads.size();
    }

    public synchronized long getTotalActiveTime() {
        return this._total_active;
    }

    public synchronized long getTotalInactiveTime() {
        return this._total_inactive;
    }

    public int getWaitingJobCount() {
        return this._jobs.queueLength();
    }

    public String toString() {
        return this._name;
    }

    public static synchronized ThreadPool getGlobalThreadPool() {
        if (__global_thread_pool == null) {
            __global_thread_pool = new ThreadPool(10, "GlobalThreadPool");
        }
        return __global_thread_pool;
    }

    public static Set getThreadPools() {
        return new HashSet(__all_thread_pools);
    }

    public static void main(String[] stringArray) {
        int n = 10;
        ThreadPool threadPool = new ThreadPool(n, "test");
        Job job = new Job(){

            public synchronized void go() {
            }
        };
        int n2 = 0;
        while (n2 < n * 3) {
            threadPool.addJob(job);
            ++n2;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        threadPool.shutdown();
    }

    static {
        __all_thread_pools = Collections.synchronizedSet(new HashSet());
    }

    public class TPThread
    extends Thread {
        public ThreadGroup _parent_thread_group;

        public TPThread(Runnable runnable, String string) {
            super(runnable, string);
        }

        public ThreadGroup getTPThreadGroup() {
            if (this._parent_thread_group != null) {
                return this._parent_thread_group;
            }
            return super.getThreadGroup();
        }
    }

    public static interface Job {
        public void go();
    }
}

