/*
 * Decompiled with CFR 0.152.
 */
package fipaos.util;

import fipaos.util.UTCContainer;
import fipaos.util.UTCDuration;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.SimpleTimeZone;

public class UTCTime
extends UTCContainer
implements Cloneable,
Serializable {
    private static final String[] __time_zones = new String[]{"Z", "A", "B", "C", "C*", "D", "D*", "E", "E*", "F", "F*", "G", "H", "I", "I*", "K", "K*", "L", "L*", "M", "M*", "N", "O", "P", "P*", "Q", "R", "S", "T", "U", "U*", "V", "V*", "W", "X", "Y"};
    private static final int[] __time_zone_offsets = new int[]{0, 2, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 19, 20, 21, 22, 23, 24, 26, -2, -4, -6, -7, -8, -10, -12, -14, -16, -17, -18, -19, -20, -22, -24};
    private static Hashtable __timezone_to_offset = new Hashtable();
    private static int __local_offset_from_GMT;
    private static int __local_dst_offset;
    private static int[] __local_dst_start;
    private static int[] __local_dst_end;
    private String _time_zone;
    private boolean _use_seconds;
    private boolean _use_millis;

    public UTCTime(String string) {
        this._use_seconds = false;
        this._use_millis = false;
        UTCTime uTCTime = new UTCTime();
        String string2 = string;
        boolean bl = false;
        if (string.substring(0, 1).equals("+")) {
            string2 = string.substring(1);
            bl = true;
        }
        try {
            this._date_data[0] = Integer.parseInt(string2.substring(0, 4));
            this._date_data[1] = Integer.parseInt(string2.substring(4, 6));
            this._date_data[2] = Integer.parseInt(string2.substring(6, 8));
            this._date_data[3] = Integer.parseInt(string2.substring(9, 11));
            this._date_data[4] = Integer.parseInt(string2.substring(11, 13));
            try {
                this._date_data[5] = Integer.parseInt(string2.substring(13, 15));
                this._use_seconds = true;
                this._date_data[6] = Integer.parseInt(string2.substring(15, 18));
                this._use_millis = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                this._time_zone = !this._use_seconds ? string2.substring(13, string.length()).toUpperCase() : (!this._use_millis ? string2.substring(15, string.length()).toUpperCase() : string2.substring(18, string.length()).toUpperCase());
                if (!this._time_zone.equals("") && !__timezone_to_offset.containsKey(this._time_zone)) {
                    throw new RuntimeException("ERROR PARSING UTC STRING - Unknown timezone \"" + this._time_zone + "\"");
                }
            } else {
                this._time_zone = "";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("ERROR PARSING UTC STRING - " + arrayIndexOutOfBoundsException.toString());
        }
        if (bl) {
            int n = 6;
            while (n >= 0) {
                int n2 = n;
                this._date_data[n2] = this._date_data[n2] + uTCTime._date_data[n];
                this.validate();
                --n;
            }
        } else {
            this.validate();
        }
    }

    public UTCTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        this._use_seconds = false;
        this._use_millis = false;
        this._date_data[0] = n;
        this._date_data[1] = n2;
        this._date_data[2] = n3;
        this._date_data[3] = n4;
        this._date_data[4] = n5;
        if (n6 != -1) {
            this._date_data[5] = n6;
            this._use_seconds = true;
        }
        if (n7 != -1) {
            this._date_data[6] = n7;
            this._use_millis = true;
        }
        if (string == null || string.equals("")) {
            this._time_zone = "";
        } else {
            if (!__timezone_to_offset.containsKey(string)) {
                throw new RuntimeException("ERROR CREATING UTCTime OBJECT - Unknown timezone \"" + string + "\"");
            }
            this._time_zone = string;
        }
        this.validate();
    }

    public UTCTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this._use_seconds = true;
        this._use_millis = true;
        this._date_data[0] = gregorianCalendar.get(1);
        this._date_data[1] = gregorianCalendar.get(2) + 1;
        this._date_data[2] = gregorianCalendar.get(5);
        this._date_data[3] = gregorianCalendar.get(11);
        this._date_data[4] = gregorianCalendar.get(12);
        this._date_data[5] = gregorianCalendar.get(13);
        this._date_data[6] = gregorianCalendar.get(14);
        if (this.isInDaylightSavingTime()) {
            this._date_data[3] = this._date_data[3] + __local_dst_offset / 2;
        }
        this._time_zone = "";
        this.validate();
    }

    public void add(int n, int n2) {
        if (n < 0 || n > 6) {
            throw new RuntimeException("ERROR IN UTCTime OBJECT - UNKNOWN FIELD");
        }
        int n3 = n;
        this._date_data[n3] = this._date_data[n3] + n2;
        this.validate();
    }

    public void addDuration(UTCDuration uTCDuration) {
        int n = 6;
        while (n >= 0) {
            this.add(n, uTCDuration.get(n));
            this.validate();
            --n;
        }
    }

    public void set(int n, int n2) {
        super.set(n, n2);
        this.validate();
    }

    public boolean isBefore(UTCTime uTCTime) {
        UTCTime uTCTime2 = (UTCTime)this.clone();
        uTCTime2.changeTimeZone("Z");
        UTCTime uTCTime3 = (UTCTime)uTCTime.clone();
        uTCTime3.changeTimeZone("Z");
        return uTCTime2.isBefore((UTCContainer)uTCTime3);
    }

    public boolean isAfter(UTCTime uTCTime) {
        return !this.isBefore(uTCTime) && !this.equals(uTCTime);
    }

    public boolean equals(UTCTime uTCTime) {
        UTCTime uTCTime2 = (UTCTime)this.clone();
        uTCTime2.changeTimeZone("Z");
        UTCTime uTCTime3 = (UTCTime)uTCTime.clone();
        uTCTime3.changeTimeZone("Z");
        return uTCTime2.equals((UTCContainer)uTCTime3);
    }

    public void setTimeZone(String string) {
        if (!__timezone_to_offset.containsKey(string.toUpperCase())) {
            throw new RuntimeException("ERROR PARSING UTC STRING - Unknown timezone \"" + this._time_zone + "\"");
        }
        this._time_zone = string.toUpperCase();
    }

    public String getTimeZone() {
        return this._time_zone;
    }

    public UTCTime getZTime() {
        UTCTime uTCTime = (UTCTime)this.clone();
        uTCTime.changeTimeZone("Z");
        return uTCTime;
    }

    public void changeTimeZone(String string) {
        int n;
        int n2 = this._time_zone.equals("") ? this.getLocalOffset() : ((Integer)__timezone_to_offset.get(this._time_zone)).intValue();
        if (string == null || string.equals("")) {
            n = this.getLocalOffset();
        } else if (__timezone_to_offset.containsKey(string.toUpperCase())) {
            n = (Integer)__timezone_to_offset.get(string.toUpperCase());
        } else {
            throw new RuntimeException("ERROR IN UTCTime OBJECT - UNKNOWN TIMEZONE \"" + string + "\"");
        }
        int n3 = (n - n2) * 30;
        this.add(4, n3);
        this._time_zone = string.toUpperCase();
    }

    public long getTimeInMillis() {
        UTCTime uTCTime = (UTCTime)this.clone();
        long l = uTCTime.getLeapYearsSince1970();
        long l2 = (long)(365 * (uTCTime._date_data[0] - 1970)) + l;
        long l3 = (l2 += (long)uTCTime.getDaysSinceYearStart()) * 24L * 60L * 60L * 1000L;
        if (this._use_millis) {
            l3 += (long)uTCTime._date_data[6];
        }
        if (this._use_seconds) {
            l3 += (long)(uTCTime._date_data[5] * 1000);
        }
        l3 += (long)(uTCTime._date_data[4] * 60 * 1000);
        return l3 += (long)(uTCTime._date_data[3] * 60 * 60 * 1000);
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n <= 6) {
            if (n == 0) {
                string = string + this._date_data[n];
            } else if ((n != 5 || this._use_seconds) && (n != 6 || this._use_millis)) {
                if (n == 3) {
                    string = string + "T";
                }
                string = string + (n == 6 ? (this._date_data[n] < 100 ? "0" : "") : "");
                string = string + (this._date_data[n] < 10 ? "0" : "");
                string = string + this._date_data[n];
            }
            ++n;
        }
        string = string + this._time_zone;
        return string;
    }

    public int getDayOfWeek() {
        int n = this._date_data[0];
        int n2 = this._date_data[1];
        int n3 = this._date_data[2];
        if (n2 == 1) {
            n2 = 13;
            --n;
        } else if (n2 == 2) {
            n2 = 14;
            --n;
        }
        int n4 = (int)((double)(n3 + n2 * 2) + Math.floor((n2 + 1) * 3 / 5) + Math.floor(n / 4) + (double)n - Math.floor(n / 100) + Math.floor(n / 400) + 2.0 - Math.floor(((double)(n3 + n2 * 2) + Math.floor((n2 + 1) * 3 / 5) + Math.floor(n / 4) + (double)n - Math.floor(n / 100) + Math.floor(Math.floor(n / 400) + 2.0)) / 7.0) * 7.0);
        if (n4 == 0) {
            n4 = 7;
        }
        return n4;
    }

    private int getLeapYearsSince1970() {
        int n = 1972;
        int n2 = 0;
        while (n < this._date_data[0]) {
            if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
                ++n2;
            }
            n += 4;
        }
        return n2;
    }

    private int getDaysSinceYearStart() {
        int n = 1;
        int n2 = 0;
        while (n < this._date_data[1]) {
            n2 += this.getDaysInMonth(this._date_data[0], n);
            ++n;
        }
        return n2 += this._date_data[2] - 1;
    }

    /*
     * Unable to fully structure code
     */
    private void validate() {
        block4: {
            this._date_data[5] = this._date_data[5] + (int)Math.floor((double)this._date_data[6] / 1000.0);
            this._date_data[6] = this.modulus(this._date_data[6], 1000);
            this._date_data[4] = this._date_data[4] + (int)Math.floor((double)this._date_data[5] / 60.0);
            this._date_data[5] = this.modulus(this._date_data[5], 60);
            this._date_data[3] = this._date_data[3] + (int)Math.floor((double)this._date_data[4] / 60.0);
            this._date_data[4] = this.modulus(this._date_data[4], 60);
            this._date_data[2] = this._date_data[2] + (int)Math.floor((double)this._date_data[3] / 24.0);
            this._date_data[3] = this.modulus(this._date_data[3], 24);
            this._date_data[0] = this._date_data[0] + (int)Math.floor((double)(this._date_data[1] - 1) / 12.0);
            this._date_data[1] = this.modulus(this._date_data[1] - 1, 12) + 1;
            if (this._date_data[2] <= 0) ** GOTO lbl28
            var1_1 = this.getDaysInMonth(this._date_data[0], this._date_data[1]);
            while (this._date_data[2] > var1_1) {
                this._date_data[1] = this._date_data[1] + 1;
                this._date_data[2] = this._date_data[2] - var1_1;
                if (this._date_data[1] > 12) {
                    this._date_data[0] = this._date_data[0] + 1;
                    this._date_data[1] = 1;
                }
                var1_1 = this.getDaysInMonth(this._date_data[0], this._date_data[1]);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                this._date_data[1] = this._date_data[1] - 1;
                if (this._date_data[1] < 1) {
                    this._date_data[0] = this._date_data[0] - 1;
                    this._date_data[1] = 12;
                }
                var1_2 = this.getDaysInMonth(this._date_data[0], this._date_data[1]);
                this._date_data[2] = this._date_data[2] + var1_2;
lbl28:
                // 2 sources

                ** while (this._date_data[2] < 1)
            }
        }
    }

    private int getDaysInMonth(int n, int n2) {
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (n2 == 2 && n % 4 == 0) {
            if (n % 400 == 0) {
                return 29;
            }
            if (n % 100 == 0) {
                return 28;
            }
            return 29;
        }
        return nArray[n2 - 1];
    }

    private int modulus(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        int n3 = Math.abs(n) / n2;
        int n4 = n + n3 * n2;
        if (n4 == 0) {
            return 0;
        }
        return n2 + n4;
    }

    private int getLocalOffset() {
        int n = __local_offset_from_GMT;
        return n += this.isInDaylightSavingTime() ? __local_dst_offset : 0;
    }

    private boolean isInDaylightSavingTime() {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "GMT");
        simpleTimeZone.setStartRule(__local_dst_start[0] - 1, __local_dst_start[1], __local_dst_start[2] + 1, __local_dst_start[3] * 3600000);
        simpleTimeZone.setEndRule(__local_dst_end[0] - 1, __local_dst_end[1], __local_dst_end[2] + 1, __local_dst_end[3] * 3600000);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this._date_data[0], this._date_data[1] - 1, this._date_data[2], this._date_data[3], this._date_data[4]);
        gregorianCalendar.setTimeZone(simpleTimeZone);
        return gregorianCalendar.get(16) != 0;
    }

    private String getpackage(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        return string2;
    }

    public static void main(String[] stringArray) {
        UTCDuration uTCDuration = new UTCDuration("+00000000T002000000");
        UTCTime uTCTime = stringArray.length >= 1 ? new UTCTime(stringArray[0]) : new UTCTime();
        if (stringArray.length >= 2) {
            UTCTime uTCTime2 = new UTCTime(stringArray[1]);
        } else {
            UTCTime uTCTime3 = new UTCTime("19990520T1500Z");
        }
        uTCTime.addDuration(uTCDuration);
    }

    static {
        int n = 0;
        while (n < __time_zones.length) {
            __timezone_to_offset.put(__time_zones[n], new Integer(__time_zone_offsets[n]));
            ++n;
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("user.profile"));
            String string = properties.getProperty("TimeZoneOffset", "0.0");
            String string2 = properties.getProperty("DSTOffset");
            __local_offset_from_GMT = (int)(new Double(string) * 2.0);
            if (string2 != null && !string2.equals("")) {
                __local_dst_offset = (int)(new Double(string2) * 2.0);
                String string3 = properties.getProperty("DSTStartMonth", "3");
                String string4 = properties.getProperty("DSTStartDayOfWeek", "0");
                String string5 = properties.getProperty("DSTStartWeekOfMonth", "-1");
                String string6 = properties.getProperty("DSTStartHourOfDay", "2");
                String string7 = properties.getProperty("DSTEndMonth", "10");
                String string8 = properties.getProperty("DSTEndDayOfWeek", "0");
                String string9 = properties.getProperty("DSTEndWeekOfMonth", "-1");
                String string10 = properties.getProperty("DSTEndHourOfDay", "2");
                __local_dst_start = new int[4];
                __local_dst_end = new int[4];
                UTCTime.__local_dst_start[0] = Integer.parseInt(string3);
                UTCTime.__local_dst_start[1] = Integer.parseInt(string5);
                UTCTime.__local_dst_start[2] = Integer.parseInt(string4);
                UTCTime.__local_dst_start[3] = Integer.parseInt(string6);
                UTCTime.__local_dst_end[0] = Integer.parseInt(string7);
                UTCTime.__local_dst_end[1] = Integer.parseInt(string9);
                UTCTime.__local_dst_end[2] = Integer.parseInt(string8);
                UTCTime.__local_dst_end[3] = Integer.parseInt(string10);
            } else {
                __local_dst_offset = 0;
            }
        }
        catch (Exception exception) {
            __local_offset_from_GMT = 0;
            __local_dst_offset = 2;
            __local_dst_start = new int[4];
            __local_dst_end = new int[4];
            UTCTime.__local_dst_start[0] = 3;
            UTCTime.__local_dst_start[1] = -1;
            UTCTime.__local_dst_start[2] = 0;
            UTCTime.__local_dst_start[3] = 2;
            UTCTime.__local_dst_end[0] = 10;
            UTCTime.__local_dst_end[1] = -1;
            UTCTime.__local_dst_end[2] = 0;
            UTCTime.__local_dst_end[3] = 2;
        }
    }
}

