/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd;

import com.hp.hpl.jena.datatypes.xsd.AbstractDateTime;
import com.hp.hpl.jena.datatypes.xsd.IllegalDateTimeFieldException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.xerces.impl.dv.XSSimpleType;

public class XSDDateTime
extends AbstractDateTime {
    public static final short YEAR_MASK = 1;
    public static final short MONTH_MASK = 2;
    public static final short DAY_MASK = 4;
    public static final short TIME_MASK = 8;
    public static final short FULL_MASK = 15;
    public static final HashMap maskMap = new HashMap();
    protected short mask;

    public XSDDateTime(Object object, XSSimpleType xSSimpleType) {
        super(object, xSSimpleType);
        this.mask = ((Integer)maskMap.get(xSSimpleType.getName())).shortValue();
    }

    public Calendar asCalendar() throws IllegalDateTimeFieldException {
        TimeZone timeZone = this.data[7] == 90 ? TimeZone.getTimeZone("GMT") : TimeZone.getDefault();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(this.data[0], this.data[1], this.data[2], this.data[3], this.data[4], this.data[5]);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar;
    }

    public int getYears() throws IllegalDateTimeFieldException {
        if ((this.mask & 1) == 0) {
            throw new IllegalDateTimeFieldException("Year not available");
        }
        return this.data[0];
    }

    public int getMonths() throws IllegalDateTimeFieldException {
        if ((this.mask & 2) == 0) {
            throw new IllegalDateTimeFieldException("Month not available");
        }
        return this.data[1];
    }

    public int getDays() throws IllegalDateTimeFieldException {
        if ((this.mask & 4) == 0) {
            throw new IllegalDateTimeFieldException("Day not available");
        }
        return this.data[2];
    }

    public int getHours() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[3];
    }

    public int getMinutes() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[4];
    }

    public int getFullSeconds() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return this.data[5];
    }

    public double getSeconds() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return (double)this.data[5] + this.fractionalSeconds;
    }

    public double getTimePart() throws IllegalDateTimeFieldException {
        if ((this.mask & 8) == 0) {
            throw new IllegalDateTimeFieldException("Time not available");
        }
        return (double)(((long)this.data[3] * 60L + (long)this.data[4]) * 60L) + this.getSeconds();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.mask & 1) != 0) {
            stringBuffer.append(this.data[0]);
        } else {
            stringBuffer.append("-");
        }
        if ((this.mask & 6) != 0) {
            stringBuffer.append("-");
            if ((this.mask & 2) != 0) {
                if (this.data[1] <= 9) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(this.data[1]);
            } else {
                stringBuffer.append("-");
            }
            if ((this.mask & 4) != 0) {
                if (this.mask != 4) {
                    stringBuffer.append("-");
                }
                if (this.data[2] <= 9) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(this.data[2]);
            }
        }
        if ((this.mask & 8) != 0) {
            stringBuffer.append("T");
            stringBuffer.append(this.data[3]);
            stringBuffer.append(":");
            stringBuffer.append(this.data[4]);
            stringBuffer.append(":");
            stringBuffer.append(this.data[5]);
            if (this.data[6] != 0) {
                stringBuffer.append(".");
                stringBuffer.append(this.data[6]);
            }
            stringBuffer.append("Z");
        }
        return stringBuffer.toString();
    }

    static {
        maskMap.put("dateTime", new Integer(15));
        maskMap.put("date", new Integer(7));
        maskMap.put("time", new Integer(8));
        maskMap.put("gYearMonth", new Integer(3));
        maskMap.put("gMonthDay", new Integer(6));
        maskMap.put("gYear", new Integer(1));
        maskMap.put("gMonth", new Integer(2));
        maskMap.put("gDay", new Integer(4));
    }
}

