/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBPattern;
import com.hp.hpl.jena.db.impl.DBQueryStage;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarIndex;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.shared.JenaException;
import java.util.ArrayList;
import java.util.Iterator;

public class DBQueryHandler
extends SimpleQueryHandler {
    private GraphRDB graph;
    boolean queryOnlyStmt;
    boolean queryOnlyReif;
    boolean queryFullReif;
    private boolean doFastpath;

    public DBQueryHandler(GraphRDB graphRDB) {
        super(graphRDB);
        this.graph = graphRDB;
        if (graphRDB.reificationBehavior() == 1) {
            this.queryOnlyStmt = false;
            this.queryOnlyReif = false;
            this.queryFullReif = false;
        } else {
            this.queryOnlyReif = false;
            this.queryFullReif = false;
            this.queryOnlyStmt = true;
        }
        this.doFastpath = true;
    }

    public void setDoFastpath(boolean bl) {
        this.doFastpath = bl;
    }

    public boolean getDoFastpath() {
        return this.doFastpath;
    }

    public Stage patternStage(Mapping mapping, Graph graph, Triple[] tripleArray) {
        final Stage[] stageArray = new Stage[tripleArray.length];
        int n = 0;
        DBPattern[] dBPatternArray = new DBPattern[tripleArray.length];
        int n2 = tripleArray.length;
        int n4 = this.graph.reificationBehavior();
        if (n2 == 1 || !this.doFastpath) {
            for (int i = 0; i < n2; ++i) {
                stageArray[n++] = super.patternStage(mapping, graph, new Triple[]{tripleArray[i]});
            }
        } else {
            DBPattern dBPattern;
            Triple triple;
            int n5;
            for (n5 = 0; n5 < tripleArray.length; ++n5) {
                triple = tripleArray[n5];
                dBPattern = new DBPattern(n5, triple, mapping);
                triple = tripleArray[n5];
                Iterator iterator = this.graph.getSpecializedGraphs();
                while (iterator.hasNext()) {
                    SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
                    char c = specializedGraph.subsumes(triple, n4);
                    if (c == 'n') continue;
                    dBPattern.sourceAdd(specializedGraph, c);
                    if (c != 'a') continue;
                }
                if (!dBPattern.hasSource()) {
                    throw new RDFRDBException("Pattern is not bound by any specialized graph: " + triple);
                }
                dBPatternArray[n5] = dBPattern;
            }
            DBPattern dBPattern2 = null;
            boolean bl = false;
            while (n2 > 0) {
                int c2 = 100;
                int c3 = 100;
                bl = false;
                DBPattern dBPattern3 = null;
                for (n5 = 0; n5 < tripleArray.length; ++n5) {
                    dBPattern = dBPatternArray[n5];
                    if (dBPattern.isStaged) continue;
                    triple = tripleArray[n5];
                    int n6 = dBPattern.cost(mapping);
                    if (bl || dBPattern.isConnected) {
                        if (!dBPattern.isConnected || n6 >= c2) continue;
                        dBPattern3 = dBPattern;
                        c2 = n6;
                        bl = true;
                        continue;
                    }
                    if (n6 < c3) {
                        c3 = n6;
                        dBPattern3 = dBPattern;
                        continue;
                    }
                    dBPattern2 = dBPattern;
                }
                dBPattern = dBPattern3 == null ? dBPattern2 : dBPattern3;
                dBPattern.isStaged = true;
                --n2;
                boolean bl2 = dBPattern.isSingleSource();
                if (bl2) {
                    ArrayList arrayList = new ArrayList();
                    ArrayList<DBPattern> arrayList2 = new ArrayList<DBPattern>();
                    arrayList2.add(dBPattern);
                    dBPattern.getVars(arrayList, mapping);
                    boolean bl3 = false;
                    do {
                        bl3 = false;
                        for (n5 = 0; n5 < tripleArray.length; ++n5) {
                            if (dBPatternArray[n5].isStaged || !dBPatternArray[n5].joinsWith(dBPattern, arrayList, this.queryOnlyStmt, this.queryOnlyReif)) continue;
                            arrayList2.add(dBPatternArray[n5]);
                            --n2;
                            dBPatternArray[n5].getVars(arrayList, mapping);
                            dBPatternArray[n5].isStaged = true;
                            bl3 = true;
                        }
                    } while (bl3 && n2 > 0);
                    if (arrayList2.size() > 1) {
                        for (n5 = 0; n5 < arrayList.size(); ++n5) {
                            VarIndex varIndex = (VarIndex)arrayList.get(n5);
                            if (varIndex.isArgVar) continue;
                            varIndex.bindToVarMap(mapping);
                        }
                        stageArray[n] = new DBQueryStage(this.graph, dBPattern.singleSource(), arrayList, arrayList2, graph);
                    } else {
                        stageArray[n] = super.patternStage(mapping, graph, new Triple[]{tripleArray[dBPattern.index]});
                    }
                } else {
                    stageArray[n] = super.patternStage(mapping, graph, new Triple[]{tripleArray[dBPattern.index]});
                }
                ++n;
            }
        }
        final Integer n7 = new Integer(n);
        return new Stage(){

            public Stage connectFrom(Stage stage) {
                for (int i = 0; i < n7; ++i) {
                    stageArray[i].connectFrom(stage);
                    stage = stageArray[i];
                }
                return super.connectFrom(stage);
            }

            public Pipe deliver(Pipe pipe) {
                return stageArray[n7 - 1].deliver(pipe);
            }
        };
    }

    public void setQueryOnlyAsserted(boolean bl) {
        if (bl && this.queryOnlyReif) {
            throw new JenaException("QueryOnlyAsserted and QueryOnlyReif cannot both be true");
        }
        this.queryOnlyStmt = bl;
    }

    public boolean getQueryOnlyAsserted() {
        return this.queryOnlyStmt;
    }

    public void setQueryOnlyReified(boolean bl) {
        if (this.graph.reificationBehavior() != 1) {
            throw new JenaException("Reified statements cannot be queried for this model's reification style");
        }
        if (bl && this.queryOnlyReif) {
            throw new JenaException("QueryOnlyAsserted and QueryOnlyReif cannot both be true");
        }
        this.queryOnlyReif = true;
        throw new JenaException("QueryOnlyReified is not yet supported");
    }

    public boolean getQueryOnlyReified() {
        return this.queryOnlyReif;
    }

    public void setQueryFullReified(boolean bl) {
        if (this.graph.reificationBehavior() != 1) {
            throw new JenaException("Reified statements cannot be queried for this model's reification style");
        }
        this.queryFullReif = true;
    }

    public boolean getQueryFullReified() {
        return this.queryFullReif;
    }
}

