/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.ICache;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.shared.JenaException;
import java.util.HashMap;
import java.util.Random;

public class LRUCache
implements ICache {
    protected HashMap keyCache;
    protected HashMap valCache;
    protected IDBID[] Keys;
    protected Random rand = new Random();
    protected int maxCount;
    protected int count;

    public LRUCache(int n) {
        this.resize(n);
    }

    protected void resize(int n) {
        this.maxCount = n;
        this.keyCache = new HashMap(n);
        this.valCache = new HashMap(n);
        this.Keys = new IDBID[n];
        this.count = 0;
    }

    public Object get(IDBID iDBID) {
        return this.keyCache.get(iDBID);
    }

    public Object getByValue(String string) {
        return this.valCache.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(IDBID iDBID, Object object) {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            int n = this.keyCache.size();
            this.keyCache.put(iDBID, object);
            this.valCache.put(object, iDBID);
            if (this.keyCache.size() > n) {
                int n2 = this.count++;
                if (this.count > this.maxCount) {
                    n2 = this.rand.nextInt(this.maxCount);
                    Object v = this.keyCache.get(this.Keys[n2]);
                    if (v == null || this.keyCache.remove(this.Keys[n2]) == null) {
                        throw new JenaException("LRUCache keyCache corrupted");
                    }
                    if (this.valCache.remove(v) == null) {
                        throw new JenaException("LRUCache valCache corrupted");
                    }
                    --this.count;
                    this.Keys[n2] = iDBID;
                    if (this.keyCache.size() > this.maxCount) {
                        throw new JenaException("LRUCache exceeds threshold");
                    }
                }
                this.Keys[n2] = iDBID;
            }
        }
    }

    public void clear() {
        this.keyCache.clear();
        this.valCache.clear();
        this.count = 0;
    }

    public void setLimit(int n) {
        this.resize(n);
    }

    public int getLimit() {
        return this.maxCount;
    }
}

