/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBasicOperations
extends TestCase {
    ModelRDB model = null;
    IRDBDriver dbDriver = null;
    IDBConnection conn = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestBasicOperations;

    public TestBasicOperations(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestBasicOperations == null ? (class$com$hp$hpl$jena$db$test$TestBasicOperations = TestBasicOperations.class$("com.hp.hpl.jena.db.test.TestBasicOperations")) : class$com$hp$hpl$jena$db$test$TestBasicOperations);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.model = ModelRDB.createModel(this.conn);
        this.dbDriver = this.conn.getDriver();
    }

    protected void tearDown() throws Exception {
        this.model.close();
        this.model = null;
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    private void addRemove(Statement statement) {
        this.model.add(statement);
        TestBasicOperations.assertTrue((boolean)this.model.contains(statement));
        this.model.remove(statement);
        TestBasicOperations.assertTrue((!this.model.contains(statement) ? 1 : 0) != 0);
        this.model.add(statement);
        TestBasicOperations.assertTrue((boolean)this.model.contains(statement));
        this.model.remove(statement);
        TestBasicOperations.assertTrue((!this.model.contains(statement) ? 1 : 0) != 0);
        this.model.add(statement);
        this.model.add(statement);
        TestBasicOperations.assertTrue((boolean)this.model.contains(statement));
        this.model.remove(statement);
        TestBasicOperations.assertTrue((!this.model.contains(statement) ? 1 : 0) != 0);
        this.model.add(statement);
        this.model.add(statement);
        this.model.add(statement);
        this.model.add(statement);
        this.model.add(statement);
        this.model.add(statement);
        TestBasicOperations.assertTrue((boolean)this.model.contains(statement));
        this.model.remove(statement);
        TestBasicOperations.assertTrue((!this.model.contains(statement) ? 1 : 0) != 0);
    }

    public void testAddRemoveURI() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testAddRemoveLiteral() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createLiteral("testLiteral");
        this.addRemove(this.model.createStatement(resource, property, literal));
    }

    public void testSetLongObjectLenFailure() {
        try {
            int n = this.dbDriver.getLongObjectLength();
            this.dbDriver.setLongObjectLength(n / 2);
            TestBasicOperations.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLongObjectLen() {
        Statement statement;
        Literal literal;
        long l = this.dbDriver.getLongObjectLength();
        TestBasicOperations.assertTrue((l > 0L && l < 100000L ? 1 : 0) != 0);
        String string = ".";
        StringBuffer stringBuffer = new StringBuffer(1024 + (int)l);
        long l2 = l - 32L;
        long l3 = l + 32L;
        TestBasicOperations.assertTrue((l2 > 0L ? 1 : 0) != 0);
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        while ((long)stringBuffer.length() < l2) {
            stringBuffer.append(string);
        }
        long l4 = this.model.size();
        while ((long)stringBuffer.length() < l3) {
            literal = this.model.createLiteral(stringBuffer.toString());
            statement = this.model.createStatement(resource, property, literal);
            this.model.add(statement);
            TestBasicOperations.assertTrue((boolean)this.model.contains(statement));
            TestBasicOperations.assertTrue((boolean)statement.getObject().equals(literal));
            stringBuffer.append(string);
        }
        TestBasicOperations.assertTrue((this.model.size() == l4 + l3 - l2 ? 1 : 0) != 0);
        while ((long)stringBuffer.length() > l2) {
            stringBuffer.deleteCharAt(0);
            literal = this.model.createLiteral(stringBuffer.toString());
            statement = this.model.createStatement(resource, property, literal);
            TestBasicOperations.assertTrue((boolean)this.model.contains(statement));
            this.model.remove(statement);
            TestBasicOperations.assertTrue((!this.model.contains(statement) ? 1 : 0) != 0);
        }
        TestBasicOperations.assertTrue((this.model.size() == l4 ? 1 : 0) != 0);
    }

    public void testSetLongObjectLen() {
        int n = this.dbDriver.getLongObjectLength();
        try {
            this.tearDown();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            n = this.dbDriver.getLongObjectLength();
            this.dbDriver.setLongObjectLength(n / 2);
            this.model = ModelRDB.createModel(this.conn);
        }
        catch (Exception exception) {
            TestBasicOperations.assertTrue((boolean)false);
        }
        this.testLongObjectLen();
        this.model.close();
        try {
            this.conn.close();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            TestBasicOperations.assertTrue((n == this.dbDriver.getLongObjectLength() ? 1 : 0) != 0);
            this.model = ModelRDB.open(this.conn);
            TestBasicOperations.assertTrue((n / 2 == this.dbDriver.getLongObjectLength() ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            TestBasicOperations.assertTrue((boolean)false);
        }
    }

    public void testAddRemoveHugeLiteral() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createLiteral(stringBuffer.toString());
        this.addRemove(this.model.createStatement(resource, property, literal));
    }

    public void testCompressHugeURI() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setDoCompressURI(true);
        this.model = ModelRDB.createModel(iDBConnection);
        String string = "a123456789";
        String string2 = "";
        long l = this.dbDriver.getLongObjectLength();
        while ((long)string2.length() < l) {
            string2 = string2 + string;
        }
        String string3 = string2 + ":/www.foo/#bar";
        Resource resource = this.model.createResource(string3);
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testCompressHugeURI1() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setDoCompressURI(true);
        this.model = ModelRDB.createModel(iDBConnection);
        String string = "a123456789";
        String string2 = "";
        long l = this.dbDriver.getLongObjectLength();
        while ((long)string2.length() < l) {
            string2 = string2 + string;
        }
        String string3 = string2 + ":/www.foo/#bar" + string2;
        Resource resource = this.model.createResource(string3);
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testNoCompressHugeURI() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setDoCompressURI(false);
        this.model = ModelRDB.createModel(iDBConnection);
        String string = "a123456789";
        String string2 = "";
        long l = this.dbDriver.getLongObjectLength();
        while ((long)string2.length() < l) {
            string2 = string2 + string;
        }
        String string3 = string2 + ":/www.foo/#bar";
        Resource resource = this.model.createResource(string3);
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testNoCompressHugeURI1() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setDoCompressURI(false);
        this.model = ModelRDB.createModel(iDBConnection);
        String string = "a123456789";
        String string2 = "";
        long l = this.dbDriver.getLongObjectLength();
        while ((long)string2.length() < l) {
            string2 = string2 + string;
        }
        String string3 = string2 + ":/www.foo/#bar" + string2;
        Resource resource = this.model.createResource(string3);
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testAddRemoveHugeURI() throws Exception {
        String string = "a123456789";
        String string2 = "";
        long l = this.dbDriver.getLongObjectLength();
        while ((long)string2.length() < l) {
            string2 = string2 + string;
        }
        String string3 = string2 + ":/www.foo/#bar" + string2;
        Resource resource = this.model.createResource(string3);
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testPrefixCache() throws Exception {
        Resource resource;
        Property property;
        Resource resource2;
        String string;
        int n;
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setDoCompressURI(true);
        this.model = ModelRDB.createModel(iDBConnection);
        int n2 = iRDBDriver.getCompressCacheSize();
        n2 = 10;
        iRDBDriver.setCompressCacheSize(n2);
        String string2 = "a123456789";
        String string3 = "";
        long l = this.dbDriver.getLongObjectLength();
        while ((long)string3.length() < l) {
            string3 = string3 + string2;
        }
        for (n = 0; n < n2 * 2; ++n) {
            string = string3 + n + ":/www.foo/#bar";
            resource2 = this.model.createResource(string);
            property = this.model.createProperty("test#predicate");
            resource = this.model.createResource("test#object");
            this.model.add(resource2, property, resource);
        }
        for (n = 0; n < n2 * 2; ++n) {
            string = string3 + n + ":/www.foo/#bar";
            resource2 = this.model.createResource(string);
            property = this.model.createProperty("test#predicate");
            resource = this.model.createResource("test#object");
            TestBasicOperations.assertTrue((boolean)this.model.contains(resource2, property, resource));
        }
    }

    public void testAddRemoveDatatype() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createTypedLiteral("stringType");
        this.addRemove(this.model.createStatement(resource, property, literal));
    }

    public void testAddRemoveHugeDatatype() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createTypedLiteral(stringBuffer.toString());
        this.addRemove(this.model.createStatement(resource, property, literal));
    }

    public void testAddRemoveBNode() {
        Resource resource = this.model.createResource();
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource();
        this.addRemove(this.model.createStatement(resource, property, resource2));
    }

    public void testBNodeIdentityPreservation() {
        Resource resource = this.model.createResource();
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource();
        Statement statement = this.model.createStatement(resource, property, resource2);
        Statement statement2 = this.model.createStatement(resource2, property, resource);
        this.model.add(statement);
        this.addRemove(statement2);
        TestBasicOperations.assertTrue((boolean)this.model.contains(statement));
        this.model.remove(statement);
    }

    public void testDuplicateCheck() {
        Resource resource = this.model.createResource();
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource();
        Statement statement = this.model.createStatement(resource, property, resource2);
        this.model.add(statement);
        try {
            this.model.add(statement);
            TestBasicOperations.assertTrue((this.model.size() == 1L ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            TestBasicOperations.assertTrue((boolean)false);
        }
        this.model.setDoDuplicateCheck(false);
        try {
            this.model.add(statement);
            TestBasicOperations.assertTrue((this.model.size() == 2L ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            TestBasicOperations.assertTrue((boolean)false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

