/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSimpleSelector
extends TestCase {
    Model model = null;
    IDBConnection conn = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestSimpleSelector;

    public TestSimpleSelector(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestSimpleSelector == null ? (class$com$hp$hpl$jena$db$test$TestSimpleSelector = TestSimpleSelector.class$("com.hp.hpl.jena.db.test.TestSimpleSelector")) : class$com$hp$hpl$jena$db$test$TestSimpleSelector);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.model = ModelRDB.createModel(this.conn, TestPackage.M_DB);
        this.model.createResource().addProperty(RDF.type, RDFS.Resource).addProperty(RDFS.label, "foo").addProperty(RDF.value, "123");
        this.model.createResource().addProperty(RDF.type, RDFS.Resource).addProperty(RDFS.label, "bar").addProperty(RDF.value, "123");
    }

    protected void tearDown() throws Exception {
        this.model.close();
        this.model = null;
        this.conn.cleanDB();
        this.conn.close();
    }

    public void testAll() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, null, (RDFNode)null));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        TestSimpleSelector.assertEquals((int)6, (int)n);
    }

    public void testFindProperty() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, RDFS.label, (RDFNode)null));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Statement statement = stmtIterator.nextStatement();
            TestSimpleSelector.assertEquals((Object)RDFS.label, (Object)statement.getPredicate());
        }
        TestSimpleSelector.assertEquals((int)2, (int)n);
    }

    public void testFindObject() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, null, RDFS.Resource));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Statement statement = stmtIterator.nextStatement();
            TestSimpleSelector.assertEquals((Object)RDFS.Resource, (Object)statement.getObject());
        }
        TestSimpleSelector.assertEquals((int)2, (int)n);
    }

    public void testFindSubject() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, null, RDFS.Resource));
        TestSimpleSelector.assertTrue((boolean)stmtIterator.hasNext());
        Resource resource = stmtIterator.nextStatement().getSubject();
        stmtIterator = this.model.listStatements(new SimpleSelector(resource, null, (RDFNode)null));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Statement statement = stmtIterator.nextStatement();
            TestSimpleSelector.assertEquals((Object)resource, (Object)statement.getSubject());
        }
        TestSimpleSelector.assertEquals((int)3, (int)n);
    }

    public void testFindPropertyAndObject() {
        StmtIterator stmtIterator = this.model.listStatements(new SimpleSelector(null, RDF.value, 123L));
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Statement statement = stmtIterator.nextStatement();
            TestSimpleSelector.assertEquals((Object)RDF.value, (Object)statement.getPredicate());
            TestSimpleSelector.assertEquals((int)123, (int)statement.getInt());
        }
        TestSimpleSelector.assertEquals((int)2, (int)n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

