/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Query;
import java.util.HashMap;

public class Mapping {
    private HashMap map = new HashMap();
    private int index = 0;
    private int preIndex = 0;

    public Mapping(Node[] nodeArray) {
        this.index = nodeArray.length;
        for (int i = 0; i < nodeArray.length; ++i) {
            this.preDeclare(nodeArray[i]);
        }
    }

    private void preDeclare(Node node) {
        this.map.put(node, new Integer(--this.preIndex));
    }

    public int indexOf(Node node) {
        int n = this.lookUp(node);
        if (n < 0) {
            throw new Query.UnboundVariableException(node);
        }
        return n;
    }

    public int lookUp(Node node) {
        Integer n = (Integer)this.map.get(node);
        if (n == null || n < 0) {
            return -1;
        }
        return n;
    }

    public int newIndex(Node node) {
        int n;
        Integer n2 = (Integer)this.map.get(node);
        if (n2 == null) {
            int n4 = this.index;
            n = n4;
            this.index = n4 + 1;
        } else {
            n = -n2.intValue() - 1;
        }
        int n5 = n;
        this.map.put(node, new Integer(n5));
        return n5;
    }

    public int size() {
        return this.map.size();
    }

    public boolean hasBound(Node node) {
        return this.map.containsKey(node) && (Integer)this.map.get(node) > -1;
    }

    public String toString() {
        return this.map.toString();
    }
}

