/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.IllegalDateTimeFieldException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.test.Rational;
import com.hp.hpl.jena.graph.test.RationalType;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTypedLiterals
extends TestCase {
    private Model m = new ModelMem();
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$test$TestTypedLiterals;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$hp$hpl$jena$datatypes$xsd$XSDDuration;
    static /* synthetic */ Class class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime;

    public TestTypedLiterals(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$test$TestTypedLiterals == null ? (class$com$hp$hpl$jena$graph$test$TestTypedLiterals = TestTypedLiterals.class$("com.hp.hpl.jena.graph.test.TestTypedLiterals")) : class$com$hp$hpl$jena$graph$test$TestTypedLiterals);
    }

    public void testUnknown() {
        boolean bl;
        String string = "urn:x-hp-dt:unknown";
        String string2 = "urn:x-hp-dt:unknown2";
        boolean bl2 = JenaParameters.enableSilentAcceptanceOfUnknownDatatypes;
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = true;
        Literal literal = this.m.createTypedLiteral("foo", string);
        Literal literal2 = this.m.createTypedLiteral("15", string);
        Literal literal3 = this.m.createTypedLiteral("foo", string2);
        Literal literal4 = this.m.createLiteral("foo", "lang1");
        Literal literal5 = this.m.createLiteral("foo");
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = bl2;
        TestTypedLiterals.assertNotNull((Object)literal);
        TestTypedLiterals.assertNotNull((Object)literal2);
        TestTypedLiterals.assertNotNull((Object)literal3);
        this.assertDiffer("datatype sensitive", literal, literal3);
        this.assertDiffer("value sensitive", literal, literal2);
        this.assertDiffer("typed and plain differ", literal, literal4);
        try {
            int bl3 = literal2.getInt();
            TestTypedLiterals.assertTrue((String)"Allowed int conversion", (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
        TestTypedLiterals.assertEquals((String)"Extract value", (Object)literal.getValue(), (Object)"foo");
        TestTypedLiterals.assertEquals((String)"Extract xml tag", (boolean)literal.getWellFormed(), (boolean)false);
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = false;
        boolean bl4 = false;
        try {
            Literal literal6 = this.m.createTypedLiteral("food", string + "3");
        }
        catch (DatatypeFormatException datatypeFormatException) {
            bl = true;
        }
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = bl2;
        TestTypedLiterals.assertTrue((String)"Detected unknown datatype", (boolean)bl);
    }

    public void testUserDef() {
        RDFDatatype rDFDatatype = RationalType.theRationalType;
        TypeMapper.getInstance().registerDatatype(rDFDatatype);
        Literal literal = this.m.createTypedLiteral("3/5", rDFDatatype);
        Literal literal2 = this.m.createTypedLiteral("7/5", rDFDatatype);
        TestTypedLiterals.assertNotNull((Object)literal);
        TestTypedLiterals.assertNotNull((Object)literal2);
        this.assertDiffer("values should be tested!", literal, literal2);
        TestTypedLiterals.assertSame((String)"Datatype incorrect", (Object)literal.getDatatype(), (Object)rDFDatatype);
        TestTypedLiterals.assertEquals((String)"Datatype uri incorrect", (String)literal.getDatatypeURI(), (String)"urn:x-hp-dt:rational");
        Object object = literal.getValue();
        TestTypedLiterals.assertTrue((String)"Value space check", (boolean)(object instanceof Rational));
        TestTypedLiterals.assertTrue((String)"Value check", (((Rational)object).getNumerator() == 3 ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((String)"Value check", (((Rational)object).getDenominator() == 5 ? 1 : 0) != 0);
        try {
            int n = literal.getInt();
            TestTypedLiterals.assertTrue((String)"Allowed int conversion", (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
        TestTypedLiterals.assertEquals((String)"Extract xml tag", (boolean)literal.getWellFormed(), (boolean)false);
    }

    public void testXSDbasics() {
        String string = "http://www.w3.org/2001/XMLSchema#int";
        Literal literal = this.m.createTypedLiteral(42);
        Literal literal2 = this.m.createTypedLiteral("42", (RDFDatatype)XSDDatatype.XSDint);
        Literal literal3 = this.m.createTypedLiteral("63");
        this.assertEquals("Default map failed", literal, literal2);
        TestTypedLiterals.assertEquals((String)"Value wrong", (Object)literal.getValue(), (Object)new Integer(42));
        TestTypedLiterals.assertEquals((String)"class wrong", literal.getValue().getClass(), (Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer));
        TestTypedLiterals.assertEquals((String)"Value accessor problem", (int)literal.getInt(), (int)42);
        TestTypedLiterals.assertEquals((String)"wrong type name", (String)literal2.getDatatypeURI(), (String)string);
        TestTypedLiterals.assertEquals((String)"wrong type", (Object)literal2.getDatatype(), (Object)XSDDatatype.XSDint);
        this.assertDiffer("Not value sensitive", literal, literal3);
        this.checkIllegalLiteral("zap", XSDDatatype.XSDint);
        this.checkIllegalLiteral("42.1", XSDDatatype.XSDint);
        Literal literal4 = this.m.createTypedLiteral("42", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.assertEquals("type coercion", literal2, literal4);
        literal = this.m.createTypedLiteral(42.42);
        literal2 = this.m.createTypedLiteral("42.42", (RDFDatatype)XSDDatatype.XSDfloat);
        Literal literal5 = this.m.createTypedLiteral("42.42", (RDFDatatype)XSDDatatype.XSDdouble);
        TestTypedLiterals.assertEquals((String)"class wrong", literal.getValue().getClass(), (Object)(class$java$lang$Double == null ? (class$java$lang$Double = TestTypedLiterals.class$("java.lang.Double")) : class$java$lang$Double));
        this.assertFloatEquals("value wrong", ((Double)literal.getValue()).floatValue(), 42.42);
        TestTypedLiterals.assertEquals((String)"class wrong", literal2.getValue().getClass(), (Object)(class$java$lang$Float == null ? (class$java$lang$Float = TestTypedLiterals.class$("java.lang.Float")) : class$java$lang$Float));
        this.assertFloatEquals("value wrong", ((Float)literal2.getValue()).floatValue(), 42.42);
        this.assertFloatEquals("Value accessor problem", literal.getFloat(), 42.42);
        TestTypedLiterals.assertEquals((String)"wrong type", (Object)literal2.getDatatype(), (Object)XSDDatatype.XSDfloat);
        this.assertEquals("equality fn", literal, literal5);
        this.checkLegalLiteral("12345", XSDDatatype.XSDlong, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDlong, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(-12345L));
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDlong);
        this.checkLegalLiteral("1234", XSDDatatype.XSDshort, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(1234));
        this.checkLegalLiteral("-1234", XSDDatatype.XSDshort, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(-1234));
        this.checkLegalLiteral("32767", XSDDatatype.XSDshort, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MAX_VALUE));
        this.checkLegalLiteral("-32768", XSDDatatype.XSDshort, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MIN_VALUE));
        this.checkIllegalLiteral("32769", XSDDatatype.XSDshort);
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDshort);
        this.checkLegalLiteral("42", XSDDatatype.XSDbyte, class$java$lang$Byte == null ? (class$java$lang$Byte = TestTypedLiterals.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(42));
        this.checkLegalLiteral("-42", XSDDatatype.XSDbyte, class$java$lang$Byte == null ? (class$java$lang$Byte = TestTypedLiterals.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-42));
        this.checkLegalLiteral("127", XSDDatatype.XSDbyte, class$java$lang$Byte == null ? (class$java$lang$Byte = TestTypedLiterals.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(127));
        this.checkLegalLiteral("-128", XSDDatatype.XSDbyte, class$java$lang$Byte == null ? (class$java$lang$Byte = TestTypedLiterals.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-128));
        this.checkIllegalLiteral("32769", XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("128", XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDbyte);
        this.checkLegalLiteral("12345", XSDDatatype.XSDunsignedLong, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDunsignedLong, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9223372036854775808"));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedLong);
        this.checkLegalLiteral("12345", XSDDatatype.XSDunsignedInt, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("2147483648", XSDDatatype.XSDunsignedInt, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(0x80000000L));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedInt);
        this.checkLegalLiteral("1234", XSDDatatype.XSDunsignedShort, class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(1234));
        this.checkLegalLiteral("32679", XSDDatatype.XSDunsignedShort, class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(32679));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedShort);
        this.checkLegalLiteral("123", XSDDatatype.XSDunsignedByte, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(123));
        this.checkLegalLiteral("129", XSDDatatype.XSDunsignedByte, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(129));
        this.checkIllegalLiteral("-123", XSDDatatype.XSDunsignedByte);
        this.checkLegalLiteral("12345", XSDDatatype.XSDinteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDinteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDinteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(-12345L));
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDinteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDpositiveInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkIllegalLiteral("0", XSDDatatype.XSDpositiveInteger);
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDpositiveInteger);
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDpositiveInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDnonNegativeInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDnonNegativeInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDnonNegativeInteger);
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDnonNegativeInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDnegativeInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(-12345L));
        this.checkIllegalLiteral("0", XSDDatatype.XSDnegativeInteger);
        this.checkIllegalLiteral("12345", XSDDatatype.XSDnegativeInteger);
        this.checkLegalLiteral("-9223372036854775808", XSDDatatype.XSDnegativeInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDnonPositiveInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(-12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDnonPositiveInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        this.checkIllegalLiteral("12345", XSDDatatype.XSDnonPositiveInteger);
        this.checkLegalLiteral("-9223372036854775808", XSDDatatype.XSDnonPositiveInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDdecimal, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long("12345"));
        this.checkLegalLiteral("42.45", XSDDatatype.XSDdecimal, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TestTypedLiterals.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("42.45"));
        this.checkLegalLiteral("9223372036854775808.1234", XSDDatatype.XSDdecimal, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TestTypedLiterals.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("9223372036854775808.1234"));
        this.checkLegalLiteral("123.4", XSDDatatype.XSDdecimal, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TestTypedLiterals.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("123.4"));
        this.checkIllegalLiteral("123,4", XSDDatatype.XSDdecimal);
        this.checkLegalLiteral("true", XSDDatatype.XSDboolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = TestTypedLiterals.class$("java.lang.Boolean")) : class$java$lang$Boolean, new Boolean(true));
        this.checkLegalLiteral("false", XSDDatatype.XSDboolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = TestTypedLiterals.class$("java.lang.Boolean")) : class$java$lang$Boolean, new Boolean(false));
        literal = this.m.createTypedLiteral(true);
        TestTypedLiterals.assertEquals((String)"boolean mapping", (Object)XSDDatatype.XSDboolean, (Object)literal.getDatatype());
        this.checkLegalLiteral("hello world", XSDDatatype.XSDstring, class$java$lang$String == null ? (class$java$lang$String = TestTypedLiterals.class$("java.lang.String")) : class$java$lang$String, "hello world");
        literal = this.m.createTypedLiteral("foo bar");
        TestTypedLiterals.assertEquals((String)"string mapping", (Object)XSDDatatype.XSDstring, (Object)literal.getDatatype());
    }

    public void testMiscEquality() {
        Literal literal = this.m.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal literal2 = this.m.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertEquals("Int lex form", literal, literal2);
        literal = this.m.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDint);
        literal2 = this.m.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.assertEquals("numeric comparisons", literal, literal2);
    }

    public void testPlainSameValueAs() {
        Literal literal = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDstring);
        Literal literal2 = this.m.createTypedLiteral("10", (RDFDatatype)null);
        Literal literal3 = this.m.createTypedLiteral("10", (String)null);
        Literal literal4 = this.m.createLiteral("10");
        Literal literal5 = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDint);
        this.assertEquals("Null type = plain literal", literal2, literal4);
        this.assertEquals("Null type = plain literal", literal2, literal3);
        this.assertEquals("Null type = plain literal", literal4, literal3);
        TestTypedLiterals.assertTrue((String)"null type", (literal3.getDatatype() == null ? 1 : 0) != 0);
        this.assertDiffer("String != int", literal, literal5);
        this.assertDiffer("Plain != int", literal2, literal5);
        this.assertDiffer("Plain != int", literal4, literal5);
        if (JenaParameters.enablePlainLiteralSameAsString) {
            this.assertEquals("String != plain??", literal, literal2);
            this.assertEquals("String != plain??", literal, literal4);
        } else {
            this.assertDiffer("String != plain??", literal, literal2);
            this.assertDiffer("String != plain??", literal, literal4);
        }
    }

    public void testUserDefined() throws IOException {
        String string = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String string2 = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper typeMapper = TypeMapper.getInstance();
        List list = XSDDatatype.loadUserDefined(string, new FileReader(string2), null, typeMapper);
        this.assertIteratorValues(list.iterator(), new Object[]{string + "#XSDEnumerationHeight", string + "#over12", string + "#over17", string + "#over59", string + "#clothingsize"});
        RDFDatatype rDFDatatype = typeMapper.getSafeTypeByName(string + "#XSDEnumerationHeight");
        this.checkLegalLiteral("short", rDFDatatype, class$java$lang$String == null ? (class$java$lang$String = TestTypedLiterals.class$("java.lang.String")) : class$java$lang$String, "short");
        this.checkLegalLiteral("tall", rDFDatatype, class$java$lang$String == null ? (class$java$lang$String = TestTypedLiterals.class$("java.lang.String")) : class$java$lang$String, "tall");
        this.checkIllegalLiteral("shortish", rDFDatatype);
        RDFDatatype rDFDatatype2 = typeMapper.getSafeTypeByName(string + "#over12");
        this.checkLegalLiteral("15", rDFDatatype2, class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(15));
        this.checkIllegalLiteral("12", rDFDatatype2);
        RDFDatatype rDFDatatype3 = typeMapper.getSafeTypeByName(string + "#clothingsize");
        this.checkLegalLiteral("42", rDFDatatype3, class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(42));
        this.checkLegalLiteral("short", rDFDatatype3, class$java$lang$String == null ? (class$java$lang$String = TestTypedLiterals.class$("java.lang.String")) : class$java$lang$String, "short");
    }

    public void testDateTime() {
        Literal literal = this.m.createTypedLiteral("P1Y2M3DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration);
        TestTypedLiterals.assertEquals((String)"duration data type", (Object)XSDDatatype.XSDduration, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"duration java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDuration == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDuration = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDuration")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDuration), literal.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"duration value", (int)1, (int)((XSDDuration)literal.getValue()).getYears());
        TestTypedLiterals.assertEquals((String)"duration value", (int)2, (int)((XSDDuration)literal.getValue()).getMonths());
        TestTypedLiterals.assertEquals((String)"duration value", (int)3, (int)((XSDDuration)literal.getValue()).getDays());
        TestTypedLiterals.assertEquals((String)"duration value", (int)5, (int)((XSDDuration)literal.getValue()).getHours());
        TestTypedLiterals.assertEquals((String)"duration value", (int)6, (int)((XSDDuration)literal.getValue()).getMinutes());
        TestTypedLiterals.assertEquals((String)"duration value", (int)7, (int)((XSDDuration)literal.getValue()).getFullSeconds());
        this.assertFloatEquals("duration value", 18367.5, ((XSDDuration)literal.getValue()).getTimePart());
        TestTypedLiterals.assertEquals((String)"serialization", (String)"P1Y2M3DT5H6M7.5S", (String)literal.getValue().toString());
        this.assertEquals("equality test", literal, this.m.createTypedLiteral("P1Y2M3DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration));
        TestTypedLiterals.assertTrue((String)"inequality test", (literal != this.m.createTypedLiteral("P1Y2M2DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("1999-05-31T12:56:32Z", (RDFDatatype)XSDDatatype.XSDdateTime);
        XSDDateTime xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDdateTime, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)31, (int)xSDDateTime.getDays());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)12, (int)xSDDateTime.getHours());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)56, (int)xSDDateTime.getMinutes());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)32, (int)xSDDateTime.getFullSeconds());
        TestTypedLiterals.assertEquals((String)"serialization", (String)"1999-05-31T12:56:32Z", (String)literal.getValue().toString());
        Calendar calendar = xSDDateTime.asCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.set(1999, 5, 31, 12, 56, 32);
        gregorianCalendar.set(14, 0);
        TestTypedLiterals.assertEquals((String)"calendar value", (Object)calendar, (Object)gregorianCalendar);
        this.assertEquals("equality test", literal, this.m.createTypedLiteral("1999-05-31T12:56:32Z", (RDFDatatype)XSDDatatype.XSDdateTime));
        TestTypedLiterals.assertTrue((String)"inequality test", (literal != this.m.createTypedLiteral("1999-04-31T12:56:32Z", (RDFDatatype)XSDDatatype.XSDdateTime) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("1999-05-31", (RDFDatatype)XSDDatatype.XSDdate);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDdate, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)31, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getHours();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("12:56:32", (RDFDatatype)XSDDatatype.XSDtime);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDtime, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)12, (int)xSDDateTime.getHours());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)56, (int)xSDDateTime.getMinutes());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)32, (int)xSDDateTime.getFullSeconds());
        try {
            xSDDateTime.getDays();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("1999-05", (RDFDatatype)XSDDatatype.XSDgYearMonth);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgYearMonth, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        try {
            xSDDateTime.getDays();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("1999", (RDFDatatype)XSDDatatype.XSDgYear);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgYear, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        try {
            xSDDateTime.getMonths();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("--05--", (RDFDatatype)XSDDatatype.XSDgMonth);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgMonth, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        try {
            xSDDateTime.getYears();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("--05-25", (RDFDatatype)XSDDatatype.XSDgMonthDay);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgMonthDay, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)25, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getYears();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("---25", (RDFDatatype)XSDDatatype.XSDgDay);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgDay, (Object)literal.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)25, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getMonths();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
    }

    public void testTypedQueries() {
        ModelMem modelMem = new ModelMem();
        Property property = modelMem.createProperty("urn:x-eg/p");
        Literal literal = modelMem.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal literal2 = modelMem.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertEquals("sameas test", literal, literal2);
        Resource resource = modelMem.createResource("urn:x-eg/a");
        resource.addProperty(property, literal);
        TestTypedLiterals.assertTrue((boolean)modelMem.getGraph().find(null, property.asNode(), literal.asNode()).hasNext());
        TestTypedLiterals.assertTrue((boolean)modelMem.getGraph().find(null, property.asNode(), literal2.asNode()).hasNext());
        TestTypedLiterals.assertTrue((boolean)modelMem.getGraph().find(resource.asNode(), property.asNode(), literal2.asNode()).hasNext());
        Query query = new Query();
        query.addMatch(resource.asNode(), property.asNode(), literal2.asNode());
        ExtendedIterator extendedIterator = modelMem.getGraph().queryHandler().prepareBindings(query, new Node[0]).executeBindings();
        TestTypedLiterals.assertTrue((boolean)extendedIterator.hasNext());
        TestTypedLiterals.assertTrue((boolean)modelMem.listStatements(resource, property, literal2).hasNext());
    }

    public void testIsValidLiteral() {
        Literal literal = this.m.createTypedLiteral("1000", (RDFDatatype)XSDDatatype.XSDinteger);
        LiteralLabel literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDlong.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDint.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDshort.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedInt.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedLong.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedShort.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDpositiveInteger.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDbyte.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnegativeInteger.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("-2", (RDFDatatype)XSDDatatype.XSDinteger);
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDlong.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDint.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDshort.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedInt.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedLong.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedShort.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDpositiveInteger.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDbyte.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnegativeInteger.isValidLiteral(literalLabel));
        literal = this.m.createTypedLiteral("4.5", (RDFDatatype)XSDDatatype.XSDfloat);
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdouble.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdecimal.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Literal literal2 = this.m.createTypedLiteral("foo", (RDFDatatype)XSDDatatype.XSDstring);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literal2.asNode().getLiteral()));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnormalizedString.isValidLiteral(literal2.asNode().getLiteral()));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literal2.asNode().getLiteral()) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("foo bar");
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("12");
        literalLabel = literal.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literalLabel));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnonNegativeInteger.isValidValue(new Long(10L)));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnonNegativeInteger.isValidValue(new Integer(10)));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnonNegativeInteger.isValidValue(new Long(-10L)) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnonNegativeInteger.isValidValue("10") ? 1 : 0) != 0);
    }

    public void testDateTimeBug() {
        String string = XSD.date.getURI();
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype rDFDatatype = typeMapper.getSafeTypeByName(string);
        Object object = rDFDatatype.parse("2003-05-21");
        Literal literal = this.m.createTypedLiteral(object, rDFDatatype);
        String string2 = literal.toString();
        Object object2 = rDFDatatype.parse(object.toString());
        TestTypedLiterals.assertEquals((Object)object, (Object)object2);
        XSDDatatype xSDDatatype = XSDDatatype.XSDdate;
        Literal literal2 = this.m.createTypedLiteral("2003-05-21", (RDFDatatype)xSDDatatype);
        this.checkSerialization("2003-05-21", XSDDatatype.XSDdate);
        this.checkSerialization("2003-05-21T12:56:10Z", XSDDatatype.XSDdateTime);
        this.checkSerialization("2003-05", XSDDatatype.XSDgYearMonth);
        this.checkSerialization("2003", XSDDatatype.XSDgYear);
        this.checkSerialization("--05", XSDDatatype.XSDgMonth);
        this.checkSerialization("--05-12", XSDDatatype.XSDgMonthDay);
        this.checkSerialization("---12", XSDDatatype.XSDgDay);
    }

    public void testFlags() {
        Literal literal;
        boolean bl = JenaParameters.enableEagerLiteralValidation;
        JenaParameters.enableEagerLiteralValidation = true;
        boolean bl2 = false;
        try {
            literal = this.m.createTypedLiteral("fool", (RDFDatatype)XSDDatatype.XSDint);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            bl2 = true;
        }
        JenaParameters.enableEagerLiteralValidation = bl;
        TestTypedLiterals.assertTrue((String)"Early datatype format exception", (boolean)bl2);
        JenaParameters.enableEagerLiteralValidation = false;
        bl2 = false;
        literal = null;
        try {
            literal = this.m.createTypedLiteral("fool", (RDFDatatype)XSDDatatype.XSDint);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            JenaParameters.enableEagerLiteralValidation = bl;
            TestTypedLiterals.assertTrue((String)"Delayed datatype format validation", (boolean)false);
        }
        try {
            literal.getValue();
        }
        catch (DatatypeFormatException datatypeFormatException) {
            bl2 = true;
        }
        JenaParameters.enableEagerLiteralValidation = bl;
        TestTypedLiterals.assertTrue((String)"Early datatype format exception", (boolean)bl2);
        bl = JenaParameters.enablePlainLiteralSameAsString;
        Literal literal2 = this.m.createLiteral("test string");
        Literal literal3 = this.m.createTypedLiteral("test string", (RDFDatatype)XSDDatatype.XSDstring);
        JenaParameters.enablePlainLiteralSameAsString = true;
        boolean bl3 = literal2.sameValueAs(literal3);
        JenaParameters.enablePlainLiteralSameAsString = false;
        boolean bl4 = !literal2.sameValueAs(literal3);
        JenaParameters.enablePlainLiteralSameAsString = bl;
        TestTypedLiterals.assertTrue((boolean)bl3);
        TestTypedLiterals.assertTrue((boolean)bl4);
    }

    private void assertDiffer(String string, Literal literal, Literal literal2) {
        TestTypedLiterals.assertTrue((String)string, (!literal.sameValueAs(literal2) ? 1 : 0) != 0);
    }

    private void assertEquals(String string, Literal literal, Literal literal2) {
        TestTypedLiterals.assertTrue((String)string, (boolean)literal.sameValueAs(literal2));
    }

    private void assertFloatEquals(String string, double d, double d2) {
        TestTypedLiterals.assertTrue((String)string, (Math.abs(d - d2) < 0.001 ? 1 : 0) != 0);
    }

    public void checkIllegalLiteral(String string, RDFDatatype rDFDatatype) {
        try {
            Literal literal = this.m.createTypedLiteral(string, rDFDatatype);
            literal.getValue();
            TestTypedLiterals.assertTrue((String)("Failed to catch '" + string + "' as an illegal " + rDFDatatype), (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
    }

    public void checkLegalLiteral(String string, RDFDatatype rDFDatatype, Class clazz, Object object) {
        Literal literal = this.m.createTypedLiteral(string, rDFDatatype);
        TestTypedLiterals.assertEquals(literal.getValue().getClass(), (Object)clazz);
        TestTypedLiterals.assertEquals((Object)literal.getValue(), (Object)object);
        TestTypedLiterals.assertEquals((Object)literal.getDatatype(), (Object)rDFDatatype);
    }

    public void checkSerialization(String string, RDFDatatype rDFDatatype) {
        Literal literal = this.m.createTypedLiteral(string, rDFDatatype);
        TestTypedLiterals.assertEquals((String)literal.getValue().toString(), (String)string);
    }

    public void assertIteratorValues(Iterator iterator, Object[] objectArray) {
        int n;
        boolean[] blArray = new boolean[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            blArray[n] = false;
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!e.equals(objectArray[i])) continue;
                bl = true;
                blArray[i] = true;
            }
            TestTypedLiterals.assertTrue((boolean)bl);
        }
        for (n = 0; n < objectArray.length; ++n) {
            TestTypedLiterals.assertTrue((boolean)blArray[n]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

