/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchIterator;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class GraphMem
extends GraphBase
implements Graph {
    HashSet triples = new HashSet();
    NodeMap subjects = new NodeMap();
    NodeMap predicates = new NodeMap();
    NodeMap objects = new NodeMap();
    protected int count = 1;
    private QueryHandler q;

    public GraphMem() {
        this(Reifier.Minimal);
    }

    public GraphMem(Reifier.Style style) {
        super(style);
    }

    public void close() {
        if (--this.count == 0) {
            this.triples = null;
            this.objects = null;
            this.predicates = null;
            this.subjects = null;
            super.close();
        }
    }

    public GraphMem openAgain() {
        ++this.count;
        return this;
    }

    public void performAdd(Triple triple) {
        if (this.getReifier().handledAdd(triple) || this.triples.contains(triple)) {
            return;
        }
        this.triples.add(triple);
        this.subjects.add(triple.getSubject(), triple);
        this.predicates.add(triple.getPredicate(), triple);
        this.objects.add(triple.getObject(), triple);
    }

    public void performDelete(Triple triple) {
        if (this.getReifier().handledRemove(triple)) {
            return;
        }
        this.triples.remove(triple);
        this.subjects.remove(triple.getSubject(), triple);
        this.predicates.remove(triple.getPredicate(), triple);
        this.objects.remove(triple.getObject(), triple);
    }

    public int size() {
        this.checkOpen();
        return this.triples.size();
    }

    public boolean isEmpty() {
        this.checkOpen();
        return this.triples.isEmpty();
    }

    public QueryHandler queryHandler() {
        if (this.q == null) {
            this.q = new GraphMemQueryHandler(this);
        }
        return this.q;
    }

    public boolean contains(Triple triple) {
        this.checkOpen();
        return triple.isConcrete() ? this.triples.contains(triple) : this.containsByFind(triple);
    }

    public boolean contains(Node node, Node node2, Node node3) {
        this.checkOpen();
        if (node == null || node2 == null || node3 == null) {
            throw new JenaException("null not allowed");
        }
        return this.contains(Triple.create(node, node2, node3));
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        this.checkOpen();
        Triple triple = tripleMatch.asTriple();
        Node node = tripleMatch.getMatchPredicate();
        Node node2 = tripleMatch.getMatchObject();
        Node node3 = triple.getSubject();
        if (node3.isConcrete()) {
            return new TripleMatchIterator(triple, this.subjects.iterator(node3));
        }
        if (node2 != null && !node2.isLiteral()) {
            return new TripleMatchIterator(triple, this.objects.iterator(node2));
        }
        if (node != null) {
            return new TripleMatchIterator(triple, this.predicates.iterator(node));
        }
        return new TripleMatchIterator(triple, this.triples.iterator());
    }

    protected class NodeMap {
        HashMap map = new HashMap();

        protected NodeMap() {
        }

        protected void add(Node node, Triple triple) {
            LinkedList<Triple> linkedList = (LinkedList<Triple>)this.map.get(node);
            if (linkedList == null) {
                linkedList = new LinkedList<Triple>();
                this.map.put(node, linkedList);
            }
            linkedList.add(triple);
        }

        protected void remove(Node node, Triple triple) {
            LinkedList linkedList = (LinkedList)this.map.get(node);
            if (linkedList != null) {
                linkedList.remove(triple);
                if (linkedList.size() == 0) {
                    this.map.put(node, null);
                }
            }
        }

        protected Iterator iterator(Node node) {
            LinkedList linkedList = (LinkedList)this.map.get(node);
            if (linkedList == null) {
                return new LinkedList().iterator();
            }
            return linkedList.iterator();
        }
    }

    private static class GraphMemQueryHandler
    extends SimpleQueryHandler {
        GraphMemQueryHandler(GraphMem graphMem) {
            super(graphMem);
        }
    }
}

